/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import java.net.InetAddress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ViewQuickNetInfo
implements UISWTViewCoreEventListener {
    private UISWTView swtView;
    private Composite composite;
    private BufferedLabel asn;
    private BufferedLabel current_ip;
    private SpeedManager speed_manager;

    public ViewQuickNetInfo() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                ViewQuickNetInfo.this.speed_manager = core.getSpeedManager();
            }
        });
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)Utils.getSimpleGridLayout(1));
        this.composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(4, false);
        this.composite.setLayout((Layout)layout);
        Label label = new Label(this.composite, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.asn");
        this.asn = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        this.asn.setLayoutData(gridData);
        label = new Label(this.composite, 0);
        Messages.setLanguageText((Widget)label, "label.current_ip");
        this.current_ip = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        this.current_ip.setLayoutData(gridData);
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.net.info");
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
        String str;
        if (this.composite == null) {
            return;
        }
        if (this.speed_manager != null) {
            this.asn.setText(this.speed_manager.getASN());
        }
        InetAddress ip = NetworkAdmin.getSingleton().getDefaultPublicAddress(true);
        InetAddress ip_v6 = NetworkAdmin.getSingleton().getDefaultPublicAddressV6();
        String string = str = ip == null ? "" : ip.getHostAddress();
        if (ip_v6 != null && !ip_v6.equals(ip)) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + ip_v6.getHostAddress();
        }
        this.current_ip.setText(str);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

