/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.impl.CoreTableColumn;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ViewUtils {
    private static SimpleDateFormat formatOverride = null;
    public static final String SM_PROP_PERMIT_UPLOAD_DISABLE = "enable_upload_disable";
    public static final String SM_PROP_PERMIT_DOWNLOAD_DISABLE = "enable_download_disable";
    private static final Map<String, Object> SM_DEFAULTS;

    static {
        COConfigurationManager.addAndFireParameterListener("Table.column.dateformat", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                String temp = COConfigurationManager.getStringParameter("Table.column.dateformat", "");
                if (temp == null || temp.trim().length() == 0) {
                    formatOverride = null;
                } else {
                    try {
                        SimpleDateFormat format = new SimpleDateFormat(temp.trim());
                        format.format(new Date());
                        formatOverride = format;
                    }
                    catch (Throwable e) {
                        formatOverride = null;
                    }
                }
            }
        });
        SM_DEFAULTS = new HashMap<String, Object>();
        SM_DEFAULTS.put(SM_PROP_PERMIT_UPLOAD_DISABLE, false);
        SM_DEFAULTS.put(SM_PROP_PERMIT_DOWNLOAD_DISABLE, false);
    }

    public static CustomDateFormat addCustomDateFormat(CoreTableColumn column) {
        return new CustomDateFormat(column);
    }

    public static void addSpeedMenu(Shell shell, Menu menuAdvanced, boolean doUpMenu, boolean doDownMenu, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, int num_entries, Map<String, Object> _properties, SpeedAdapter adapter) {
        if (doDownMenu) {
            MenuItem itemDownSpeed = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemDownSpeed, "MyTorrentsView.menu.setDownSpeed");
            Utils.setMenuItemImage(itemDownSpeed, "speed");
            Menu menuDownSpeed = new Menu((Decorations)shell, 4);
            itemDownSpeed.setMenu(menuDownSpeed);
            ViewUtils.addSpeedMenuDown(shell, menuDownSpeed, isTorrentContext, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, num_entries, _properties, adapter);
        }
        if (doUpMenu) {
            MenuItem itemUpSpeed = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemUpSpeed, "MyTorrentsView.menu.setUpSpeed");
            Utils.setMenuItemImage(itemUpSpeed, "speed");
            Menu menuUpSpeed = new Menu((Decorations)shell, 4);
            itemUpSpeed.setMenu(menuUpSpeed);
            ViewUtils.addSpeedMenuUp(shell, menuUpSpeed, isTorrentContext, hasSelection, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, num_entries, _properties, adapter);
        }
    }

    public static void addSpeedMenuUp(final Shell shell, Menu menuSpeed, boolean isTorrentContext, boolean hasSelection, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, final int num_entries, Map<String, Object> _properties, final SpeedAdapter adapter) {
        HashMap<String, Object> properties = new HashMap<String, Object>(SM_DEFAULTS);
        if (_properties != null) {
            properties.putAll(_properties);
        }
        String menu_key = "MyTorrentsView.menu.manual";
        if (num_entries > 1) {
            menu_key = String.valueOf(menu_key) + (isTorrentContext ? ".per_torrent" : ".per_peer");
        }
        if (menuSpeed != null) {
            boolean allowDisable;
            MenuItem itemCurrentUpSpeed = new MenuItem(menuSpeed, 8);
            itemCurrentUpSpeed.setEnabled(false);
            String separator = "";
            StringBuilder speedText = new StringBuilder();
            if (upSpeedDisabled) {
                speedText.append(MessageText.getString("label.disabled"));
                separator = " / ";
            }
            if (upSpeedUnlimited) {
                speedText.append(separator);
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
                separator = " / ";
            }
            if (totalUpSpeed > 0L) {
                speedText.append(separator);
                speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalUpSpeed));
            }
            itemCurrentUpSpeed.setText(speedText.toString());
            new MenuItem(menuSpeed, 2);
            Listener itemsUpSpeedListener = new Listener(){

                public void handleEvent(Event e) {
                    if (e.widget != null && e.widget instanceof MenuItem) {
                        MenuItem item = (MenuItem)e.widget;
                        int speed = item.getData("maxul") == null ? 0 : (Integer)item.getData("maxul");
                        adapter.setUpSpeed(speed);
                    }
                }
            };
            if (num_entries > 1 || !upSpeedUnlimited) {
                MenuItem mi = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.unlimit");
                mi.setData("maxul", (Object)new Integer(0));
                mi.addListener(13, itemsUpSpeedListener);
            }
            if ((allowDisable = ((Boolean)properties.get(SM_PROP_PERMIT_UPLOAD_DISABLE)).booleanValue()) && !upSpeedDisabled) {
                MenuItem mi = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.disable");
                mi.setData("maxul", (Object)new Integer(-1));
                mi.addListener(13, itemsUpSpeedListener);
            }
            int kInB = DisplayFormatters.getKinB();
            if (hasSelection) {
                maxUpload = maxUpload == 0L ? (long)(75 * kInB) : (upSpeedSetMax <= 0L ? (long)(200 * kInB) : 4L * (upSpeedSetMax / (long)kInB) * (long)kInB);
                int i = 0;
                while (i < 10) {
                    MenuItem mi = new MenuItem(menuSpeed, 8);
                    mi.addListener(13, itemsUpSpeedListener);
                    int limit = (int)(maxUpload / (long)(10 * num_entries) * (long)(10 - i));
                    String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries);
                    if (num_entries > 1) {
                        speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{speed, String.valueOf(num_entries), DisplayFormatters.formatByteCountToKiBEtcPerSec(limit)});
                    }
                    mi.setText(speed);
                    mi.setData("maxul", (Object)new Integer(limit));
                    ++i;
                }
            }
            new MenuItem(menuSpeed, 2);
            MenuItem itemUpSpeedManualSingle = new MenuItem(menuSpeed, 8);
            Messages.setLanguageText((Widget)itemUpSpeedManualSingle, menu_key);
            itemUpSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewUtils.getManualSpeedValue(shell, false, new manualSpeedValueListener(){

                        @Override
                        public void manualSpeedValueResult(int speed) {
                            if (speed > 0) {
                                adapter.setUpSpeed(speed);
                            }
                        }

                        @Override
                        public void error(String s) {
                        }
                    });
                }
            });
            if (num_entries > 1) {
                MenuItem itemUpSpeedManualShared = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)itemUpSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
                itemUpSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewUtils.getManualSharedSpeedValue(shell, false, num_entries, adapter);
                    }
                });
            }
        }
    }

    public static void addSpeedMenuDown(final Shell shell, Menu menuSpeed, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, final int num_entries, Map<String, Object> _properties, final SpeedAdapter adapter) {
        HashMap<String, Object> properties = new HashMap<String, Object>(SM_DEFAULTS);
        if (_properties != null) {
            properties.putAll(_properties);
        }
        String menu_key = "MyTorrentsView.menu.manual";
        if (num_entries > 1) {
            menu_key = String.valueOf(menu_key) + (isTorrentContext ? ".per_torrent" : ".per_peer");
        }
        if (menuSpeed != null) {
            boolean allowDisable;
            MenuItem itemCurrentDownSpeed = new MenuItem(menuSpeed, 8);
            itemCurrentDownSpeed.setEnabled(false);
            StringBuilder speedText = new StringBuilder();
            String separator = "";
            if (downSpeedDisabled) {
                speedText.append(MessageText.getString("label.disabled"));
                separator = " / ";
            }
            if (downSpeedUnlimited) {
                speedText.append(separator);
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
                separator = " / ";
            }
            if (totalDownSpeed > 0L) {
                speedText.append(separator);
                speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalDownSpeed));
            }
            itemCurrentDownSpeed.setText(speedText.toString());
            new MenuItem(menuSpeed, 2);
            Listener itemsDownSpeedListener = new Listener(){

                public void handleEvent(Event e) {
                    if (e.widget != null && e.widget instanceof MenuItem) {
                        MenuItem item = (MenuItem)e.widget;
                        int speed = item.getData("maxdl") == null ? 0 : (Integer)item.getData("maxdl");
                        adapter.setDownSpeed(speed);
                    }
                }
            };
            if (num_entries > 1 || !downSpeedUnlimited) {
                MenuItem mi = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.unlimit");
                mi.setData("maxdl", (Object)new Integer(0));
                mi.addListener(13, itemsDownSpeedListener);
            }
            if ((allowDisable = ((Boolean)properties.get(SM_PROP_PERMIT_DOWNLOAD_DISABLE)).booleanValue()) && !downSpeedDisabled) {
                MenuItem mi = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.down.disable");
                mi.setData("maxdl", (Object)new Integer(-1));
                mi.addListener(13, itemsDownSpeedListener);
            }
            if (hasSelection) {
                int kInB = DisplayFormatters.getKinB();
                if (maxDownload == 0L) {
                    maxDownload = downSpeedSetMax <= 0L ? (long)(200 * kInB) : 4L * (downSpeedSetMax / (long)kInB) * (long)kInB;
                }
                int i = 0;
                while (i < 10) {
                    MenuItem mi = new MenuItem(menuSpeed, 8);
                    mi.addListener(13, itemsDownSpeedListener);
                    int limit = (int)(maxDownload / (long)(10 * num_entries) * (long)(10 - i));
                    String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries);
                    if (num_entries > 1) {
                        speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{speed, String.valueOf(num_entries), DisplayFormatters.formatByteCountToKiBEtcPerSec(limit)});
                    }
                    mi.setText(speed);
                    mi.setData("maxdl", (Object)new Integer(limit));
                    ++i;
                }
            }
            new MenuItem(menuSpeed, 2);
            MenuItem itemDownSpeedManualSingle = new MenuItem(menuSpeed, 8);
            Messages.setLanguageText((Widget)itemDownSpeedManualSingle, menu_key);
            itemDownSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewUtils.getManualSpeedValue(shell, true, new manualSpeedValueListener(){

                        @Override
                        public void manualSpeedValueResult(int speed) {
                            if (speed > 0) {
                                adapter.setDownSpeed(speed);
                            }
                        }

                        @Override
                        public void error(String s) {
                        }
                    });
                }
            });
            if (num_entries > 1) {
                MenuItem itemDownSpeedManualShared = new MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)itemDownSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
                itemDownSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewUtils.getManualSharedSpeedValue(shell, true, num_entries, adapter);
                    }
                });
            }
        }
    }

    public static void getManualSpeedValue(final Shell shell, boolean for_download, final manualSpeedValueListener l) {
        String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
        String set_num_str = MessageText.getString("MyTorrentsView.dialog.setNumber." + (for_download ? "download" : "upload"));
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setSpeed.title", new String[]{set_num_str}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, set_num_str});
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                if (!receiver.hasSubmittedInput()) {
                    l.manualSpeedValueResult(-1);
                    return;
                }
                String sReturn = receiver.getSubmittedInput();
                if (sReturn == null) {
                    l.manualSpeedValueResult(-1);
                    return;
                }
                try {
                    int result = (int)(Double.valueOf(sReturn) * (double)DisplayFormatters.getKinB());
                    if (DisplayFormatters.isRateUsingBits()) {
                        result /= 8;
                    }
                    if (result <= 0) {
                        l.error("non-positive number entered");
                        return;
                    }
                    l.manualSpeedValueResult(result);
                }
                catch (NumberFormatException er) {
                    MessageBox mb = new MessageBox(shell, 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    l.manualSpeedValueResult(-1);
                }
            }
        });
    }

    public static void getManualSharedSpeedValue(Shell shell, final boolean for_download, final int num_entries, final SpeedAdapter adapter) {
        ViewUtils.getManualSpeedValue(shell, for_download, new manualSpeedValueListener(){

            @Override
            public void manualSpeedValueResult(int result) {
                if (result > 0) {
                    if ((result /= num_entries) == 0) {
                        result = 1;
                    }
                    if (for_download) {
                        adapter.setDownSpeed(result);
                    } else {
                        adapter.setUpSpeed(result);
                    }
                }
            }

            @Override
            public void error(String s) {
            }
        });
    }

    public static void setViewRequiresOneOrMoreDownloads(Composite genComposite) {
        ViewUtils.setViewRequires(genComposite, true);
    }

    public static void setViewRequiresOneDownload(Composite genComposite) {
        ViewUtils.setViewRequires(genComposite, false);
    }

    private static void setViewRequires(Composite genComposite, boolean one_or_more) {
        if (genComposite == null || genComposite.isDisposed()) {
            return;
        }
        Utils.disposeComposite(genComposite, false);
        Label lab = new Label(genComposite, 0);
        if (genComposite.getLayout() instanceof GridLayout) {
            GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
            gridData.verticalIndent = 10;
            lab.setLayoutData((Object)gridData);
        } else {
            lab.setLayoutData((Object)Utils.getFilledFormData());
        }
        Messages.setLanguageText((Widget)lab, one_or_more ? "view.one.or.more.download" : "view.one.download.only");
        genComposite.layout(true);
        Composite parent = genComposite.getParent();
        if (parent instanceof ScrolledComposite) {
            ScrolledComposite scrolled_comp = (ScrolledComposite)parent;
            Rectangle r = scrolled_comp.getClientArea();
            scrolled_comp.setMinSize(genComposite.computeSize(r.width, -1));
        }
    }

    public static DownloadManager getDownloadManagerFromDataSource(Object dataSource, DownloadManager existing) {
        DownloadManager manager = null;
        if (dataSource instanceof Object[] && ((Object[])dataSource).length == 1) {
            dataSource = ((Object[])dataSource)[0];
        }
        if (dataSource instanceof Object[]) {
            Object[] newDataSources;
            Object[] objectArray = newDataSources = (Object[])dataSource;
            int n = newDataSources.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof DownloadManager) {
                    if (manager == null) {
                        manager = (DownloadManager)o;
                    } else if (manager != o) {
                        manager = null;
                        break;
                    }
                } else if (o instanceof DiskManagerFileInfo) {
                    DownloadManager temp = ((DiskManagerFileInfo)o).getDownloadManager();
                    if (manager == null) {
                        manager = temp;
                    } else if (manager != temp) {
                        manager = null;
                        break;
                    }
                } else if (o instanceof PEPiece) {
                    PEPiece piece = (PEPiece)o;
                    DiskManager diskManager = piece.getDMPiece().getManager();
                    if (diskManager instanceof DiskManagerImpl) {
                        DiskManagerImpl dmi = (DiskManagerImpl)diskManager;
                        DownloadManager temp = dmi.getDownloadManager();
                        if (manager == null) {
                            manager = temp;
                        } else if (manager != temp) {
                            manager = null;
                            break;
                        }
                    }
                } else {
                    manager = dataSource instanceof Tag ? existing : null;
                    break;
                }
                ++n2;
            }
        } else if (dataSource instanceof DownloadManager) {
            manager = (DownloadManager)dataSource;
        } else if (dataSource instanceof DiskManagerFileInfo) {
            manager = ((DiskManagerFileInfo)dataSource).getDownloadManager();
        } else if (dataSource instanceof PEPiece) {
            PEPiece piece = (PEPiece)dataSource;
            DiskManager diskManager = piece.getDMPiece().getManager();
            if (diskManager instanceof DiskManagerImpl) {
                DiskManagerImpl dmi = (DiskManagerImpl)diskManager;
                manager = dmi.getDownloadManager();
            }
        } else if (dataSource instanceof Tag) {
            manager = existing;
        }
        return manager;
    }

    public static List<DownloadManager> getDownloadManagersFromDataSource(Object dataSource, List<DownloadManager> existing) {
        LinkedHashSet<DownloadManager> managers = new LinkedHashSet<DownloadManager>();
        if (dataSource instanceof Object[]) {
            Object[] newDataSources;
            Object[] objectArray = newDataSources = (Object[])dataSource;
            int n = newDataSources.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof TagDownload) {
                    Set<DownloadManager> taggedDownloads = ((TagDownload)o).getTaggedDownloads();
                    managers.addAll(taggedDownloads);
                } else if (o instanceof Tag) {
                    return existing;
                }
                DownloadManager dm = ViewUtils.getDownloadManagerFromDataSource(o, null);
                if (dm != null) {
                    managers.add(dm);
                }
                ++n2;
            }
        } else {
            if (dataSource instanceof TagDownload) {
                Set<DownloadManager> taggedDownloads = ((TagDownload)dataSource).getTaggedDownloads();
                managers.addAll(taggedDownloads);
            } else if (dataSource instanceof Tag) {
                return existing;
            }
            DownloadManager dm = ViewUtils.getDownloadManagerFromDataSource(dataSource, null);
            if (dm != null) {
                managers.add(dm);
            }
        }
        return new ArrayList<DownloadManager>(managers);
    }

    public static class CustomDateFormat {
        private CoreTableColumn column;
        private TableContextMenuItem custom_date_menu;
        private SimpleDateFormat custom_date_format;
        private long[] extra_times;
        private SimpleDateFormat[] extra_formats;

        private CustomDateFormat(CoreTableColumn _column) {
            this.column = _column;
            this.custom_date_menu = this.column.addContextMenuItem("label.date.format", 1);
            this.custom_date_menu.setStyle(1);
            this.custom_date_menu.addMultiListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    Object existing_o = column.getUserData("CustomDate");
                    String existing_text = "";
                    if (existing_o instanceof String) {
                        existing_text = (String)existing_o;
                    } else if (existing_o instanceof byte[]) {
                        try {
                            existing_text = new String((byte[])existing_o, "UTF-8");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("ConfigView.section.style.customDateFormat", "label.date.formats");
                    entryWindow.setPreenteredText(existing_text, false);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            String date_format = entryWindow.getSubmittedInput();
                            if (date_format == null) {
                                return;
                            }
                            date_format = date_format.trim();
                            column.setUserData("CustomDate", date_format);
                            this.update();
                            column.invalidateCells();
                        }
                    });
                }
            });
        }

        public void update() {
            Object cd = this.column.getUserData("CustomDate");
            String format_str = null;
            if (cd instanceof byte[]) {
                try {
                    cd = new String((byte[])cd, "UTF-8");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (cd instanceof String) {
                String str = (String)cd;
                if ((str = str.trim()).length() > 0) {
                    String[] bits;
                    ArrayList<Long> l_extra_t = new ArrayList<Long>();
                    ArrayList<SimpleDateFormat> l_extra_f = new ArrayList<SimpleDateFormat>();
                    String[] stringArray = bits = str.split(";");
                    int n = bits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bit = stringArray[n2];
                        if (!(bit = bit.trim()).isEmpty()) {
                            if (bit.startsWith(">")) {
                                char[] chars = bit.toCharArray();
                                String digits = "";
                                char unit = ' ';
                                String format = "";
                                int i = 1;
                                while (i < chars.length) {
                                    char c = chars[i];
                                    if (!Character.isWhitespace(c)) {
                                        if (Character.isDigit(c)) {
                                            digits = String.valueOf(digits) + c;
                                        } else {
                                            unit = Character.toLowerCase(c);
                                            format = bit.substring(i + 1).trim();
                                            break;
                                        }
                                    }
                                    ++i;
                                }
                                try {
                                    long mult;
                                    long num = Integer.parseInt(digits);
                                    switch (unit) {
                                        case 'd': {
                                            mult = 86400L;
                                            break;
                                        }
                                        case 'w': {
                                            mult = 604800L;
                                            break;
                                        }
                                        case 'm': {
                                            mult = 2592000L;
                                            break;
                                        }
                                        case 'y': {
                                            mult = 31536000L;
                                            break;
                                        }
                                        default: {
                                            throw new Exception("Invalid unit: " + unit);
                                        }
                                    }
                                    SimpleDateFormat f = new SimpleDateFormat(format);
                                    l_extra_t.add(num * mult * 1000L);
                                    l_extra_f.add(f);
                                }
                                catch (Throwable e) {
                                    Debug.out("Invalid date specification: " + bit);
                                }
                            } else {
                                try {
                                    this.custom_date_format = new SimpleDateFormat(bit);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        ++n2;
                    }
                    if (l_extra_t.isEmpty()) {
                        this.extra_formats = null;
                        this.extra_times = null;
                    } else {
                        this.extra_formats = l_extra_f.toArray(new SimpleDateFormat[0]);
                        long[] temp = new long[l_extra_t.size()];
                        int i = 0;
                        while (i < temp.length) {
                            temp[i] = (Long)l_extra_t.get(i);
                            ++i;
                        }
                        this.extra_times = temp;
                    }
                    format_str = str;
                }
            }
            if (format_str == null) {
                format_str = MessageText.getString("label.table.default");
                this.custom_date_format = null;
                this.extra_formats = null;
                this.extra_times = null;
            }
            this.custom_date_menu.setText(String.valueOf(MessageText.getString("label.date.format")) + " [" + format_str + "] ...");
        }

        public String formatDate(long time) {
            SimpleDateFormat[] ef;
            long[] et = this.extra_times;
            if (et != null && et.length == (ef = this.extra_formats).length) {
                DateFormat temp = null;
                long max = 0L;
                long age = SystemTime.getCurrentTime() - time;
                int i = 0;
                while (i < et.length) {
                    long a = et[i];
                    if (a > max && age > a) {
                        max = a;
                        temp = ef[i];
                    }
                    ++i;
                }
                if (temp != null) {
                    return temp.format(new Date(time));
                }
            }
            if (this.custom_date_format == null) {
                return null;
            }
            return this.custom_date_format.format(new Date(time));
        }

        public String formatETA(long value, boolean absolute) {
            SimpleDateFormat df;
            SimpleDateFormat override = null;
            if (absolute) {
                SimpleDateFormat[] ef;
                long[] et = this.extra_times;
                if (et != null && et.length == (ef = this.extra_formats).length) {
                    long max = 0L;
                    long age = SystemTime.getCurrentTime() - value;
                    int i = 0;
                    while (i < et.length) {
                        long a = et[i];
                        if (a > max && age > a) {
                            max = a;
                            override = ef[i];
                        }
                        ++i;
                    }
                }
                if (override == null) {
                    override = this.custom_date_format;
                }
            }
            SimpleDateFormat simpleDateFormat = df = override != null ? override : formatOverride;
            if (absolute && df != null && value > 0L && value != 31536000L && value < 1827387392L) {
                try {
                    return df.format(new Date(SystemTime.getCurrentTime() + 1000L * value));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return DisplayFormatters.formatETA(value, absolute);
        }
    }

    public static interface SpeedAdapter {
        public void setUpSpeed(int var1);

        public void setDownSpeed(int var1);
    }

    public static interface ViewTitleExtraInfo {
        public void setCountProvider(Composite var1, CountProvider var2);

        public void searchUpdate(Composite var1, int var2, int var3);

        public void setSearchActive(Composite var1, boolean var2);

        public static interface CountProvider {
            public int[] getCounts();
        }
    }

    public static interface manualSpeedValueListener {
        public void manualSpeedValueResult(int var1);

        public void error(String var1);
    }
}

