/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.clientstats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.views.clientstats.ClientStatsDataSource;
import com.biglybt.util.MapUtils;
import java.util.Map;

public class ColumnCS_Discarded
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "discarded";

    public ColumnCS_Discarded(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setType(3);
        String network = column.getUserDataString("network");
        if (network != null) {
            column.setVisible(false);
            column.setNameOverride(String.valueOf(network) + " " + MessageText.getString("ClientStats.column.discarded"));
        }
    }

    @Override
    public void refresh(TableCell cell) {
        String network;
        ClientStatsDataSource ds = (ClientStatsDataSource)cell.getDataSource();
        if (ds == null) {
            return;
        }
        long val = ds.bytesDiscarded;
        TableColumn column = cell.getTableColumn();
        if (column != null && (network = column.getUserDataString("network")) != null) {
            Map<String, Object> map = ds.perNetworkStats.get(network);
            val = map != null ? MapUtils.getMapLong(map, "bytesDiscarded", 0L) : 0L;
        }
        if (cell.setSortValue(val) || !cell.isValid()) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(val));
        }
    }
}

