/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.columnsetup;

import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnTC_NameInfo
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellMouseMoveListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "TableColumnNameInfo";
    public static Font fontHeader = null;
    private static String[] profText = new String[]{"beginner", "intermediate", "advanced"};

    public ColumnTC_NameInfo(String tableID) {
        super(COLUMN_ID, tableID);
        this.initialize(5, -1, 415, -3);
        this.setType(2);
        this.setDefaultSortAscending(true);
    }

    @Override
    public void refresh(TableCell cell) {
        TableColumnCore column = (TableColumnCore)cell.getDataSource();
        String key = column.getTitleLanguageKey();
        cell.setSortValue((Comparable)((Object)MessageText.getString(key, column.getName())));
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle hitArea;
        TableView tv;
        TableColumnSetupWindow tvs;
        String rename;
        TableColumnCore column = (TableColumnCore)cell.getDataSource();
        String raw_key = column.getTitleLanguageKey(false);
        String current_key = column.getTitleLanguageKey(true);
        Rectangle bounds = cell.getBounds();
        if (bounds == null || bounds.isEmpty()) {
            return;
        }
        Font fontDefault = gc.getFont();
        if (fontHeader == null) {
            FontData[] fontData = gc.getFont().getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight(fontData[0].getHeight() + 1);
            fontHeader = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontHeader);
        bounds.y += 3;
        bounds.x += 7;
        bounds.width -= 14;
        String name = MessageText.getString(raw_key, column.getName());
        if (!raw_key.equals(current_key) && (rename = MessageText.getString(current_key, "")).length() > 0) {
            name = String.valueOf(name) + " (->" + rename + ")";
        }
        GCStringPrinter sp = new GCStringPrinter(gc, name, bounds, 1, 128);
        sp.printString();
        Point titleSize = sp.getCalculatedSize();
        gc.setFont(fontDefault);
        String info = MessageText.getString(String.valueOf(raw_key) + ".info", "");
        Rectangle infoBounds = new Rectangle(bounds.x + 10, bounds.y + titleSize.y + 5, bounds.width - 15, bounds.height - 20);
        GCStringPrinter.printString(gc, info, infoBounds, true, false);
        TableColumnInfo columnInfo = (TableColumnInfo)cell.getTableRow().getData("columninfo");
        if (columnInfo == null) {
            TableColumnManager tcm = TableColumnManager.getInstance();
            columnInfo = tcm.getColumnInfo(column.getForDataSourceType(), column.getTableID(), column.getName());
            cell.getTableRowCore().setData("columninfo", columnInfo);
        }
        Rectangle profBounds = new Rectangle(bounds.width - 100, bounds.y - 2, 100, 20);
        byte proficiency = columnInfo.getProficiency();
        if (proficiency > 0 && proficiency < profText.length) {
            int alpha = gc.getAlpha();
            gc.setAlpha(160);
            GCStringPrinter.printString(gc, MessageText.getString("ConfigView.section.mode." + profText[proficiency]), profBounds, true, false, 131200);
            gc.setAlpha(alpha);
        }
        if ((tvs = (TableColumnSetupWindow)(tv = cell.getTableRowCore().getView()).getParentDataSource()).isColumnAdded(column)) {
            hitArea = Utils.EMPTY_RECT;
        } else {
            int x = bounds.x + titleSize.x + 15;
            int y = bounds.y - 1;
            int h = 15;
            String textAdd = MessageText.getString("Button.add");
            GCStringPrinter sp2 = new GCStringPrinter(gc, textAdd, new Rectangle(x, y, 500, h), true, false, 0x1000000);
            sp2.calculateMetrics();
            int w = sp2.getCalculatedSize().x + 12;
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setBackground(ColorCache.getColor(gc.getDevice(), 255, 255, 255));
            gc.fillRoundRectangle(x, y, w, h, 15, h);
            gc.setBackground(ColorCache.getColor(gc.getDevice(), 215, 215, 215));
            gc.fillRoundRectangle(x + 2, y + 2, w, h, 15, h);
            gc.setForeground(ColorCache.getColor(gc.getDevice(), 145, 145, 145));
            gc.drawRoundRectangle(x, y, w, h, 15, h);
            gc.setForeground(ColorCache.getColor(gc.getDevice(), 50, 50, 50));
            hitArea = new Rectangle(x, y, w + 2, h);
            sp2.printString(gc, hitArea, 0x1000000);
            bounds = cell.getBounds();
            hitArea.x -= bounds.x;
            hitArea.y -= bounds.y;
        }
        cell.getTableRowCore().setData("AddHitArea", hitArea);
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.button == 1 && event2.eventType == 1 && event2.cell instanceof TableCellCore) {
            Rectangle hitArea;
            Object data = event2.cell.getTableRow().getData("AddHitArea");
            if (data instanceof Rectangle && (hitArea = (Rectangle)data).contains(event2.x, event2.y)) {
                TableView tv = ((TableCellCore)event2.cell).getTableRowCore().getView();
                TableColumnSetupWindow tvs = (TableColumnSetupWindow)tv.getParentDataSource();
                Object dataSource = event2.cell.getDataSource();
                if (dataSource instanceof TableColumnCore) {
                    TableColumnCore column = (TableColumnCore)dataSource;
                    tvs.chooseColumn(column);
                }
            }
        } else if (event2.eventType == 3) {
            Rectangle hitArea;
            Object data = event2.cell.getTableRow().getData("AddHitArea");
            if (data instanceof Rectangle && (hitArea = (Rectangle)data).contains(event2.x, event2.y)) {
                ((TableCellSWT)event2.cell).setCursorID(21);
                return;
            }
            ((TableCellSWT)event2.cell).setCursorID(0);
        }
    }

    @Override
    public void cellHover(TableCell cell) {
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
    }
}

