/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.PasswordSwtParameter;
import com.biglybt.ui.swt.views.configsections.BaseConfigSectionSWT;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConfigSectionInterfacePasswordSWT
extends ConfigSectionImpl
implements BaseConfigSectionSWT {
    public static final String SECTION_ID = "interface.password";
    Label passwordMatch;

    public ConfigSectionInterfacePasswordSWT() {
        super(SECTION_ID, "style");
    }

    @Override
    public void build() {
    }

    @Override
    public void configSectionCreate(Composite cSection, Map<ParameterImpl, BaseSwtParameter> mapParamToSwtParam) {
        PasswordSwtParameter pw1 = new PasswordSwtParameter(cSection, "Password", "ConfigView.label.password");
        pw1.setWidthInCharacters(12);
        Text t1 = (Text)pw1.getMainControl();
        PasswordSwtParameter pw2 = new PasswordSwtParameter(cSection, "Password Confirm", "ConfigView.label.passwordconfirm");
        pw2.setWidthInCharacters(12);
        Text t2 = (Text)pw2.getMainControl();
        Label label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cSection, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.passwordMatch.setLayoutData((Object)gridData);
        this.refreshPWLabel();
        t1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePasswordSWT.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePasswordSWT.this.refreshPWLabel();
            }
        });
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                int i = 0;
                while (i < password.length) {
                    if (password[i] != confirm[i]) {
                        same = false;
                    }
                    ++i;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

