/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.file;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class FileInfoView
implements UISWTViewCoreEventListener {
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 2;
    private static final int BLOCK_SIZE = 16;
    private static final int BLOCKCOLOR_DONE = 0;
    private static final int BLOCKCOLOR_SKIPPED = 1;
    private static final int BLOCKCOLOR_ACTIVE = 2;
    private static final int BLOCKCOLOR_NEEDED = 3;
    private Composite fileInfoComposite;
    private ScrolledComposite sc;
    protected Canvas fileInfoCanvas;
    private Color[] blockColors;
    private Label topLabel;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update") * 2;
    private int loopFactor = 0;
    private DiskManagerFileInfo file;
    Image img = null;
    private boolean refreshInfoCanvasQueued;
    private UISWTView swtView;

    public FileInfoView() {
        this.blockColors = new Color[]{Colors.blues[9], Colors.white, Colors.red, Colors.green};
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof Object[] && ((Object[])newDataSource).length > 0) {
            newDataSource = ((Object[])newDataSource)[0];
        }
        this.file = newDataSource instanceof DiskManagerFileInfo ? (DiskManagerFileInfo)newDataSource : null;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileInfoView.this.fillFileInfoSection();
            }
        });
    }

    private String getFullTitle() {
        return MessageText.getString("FileView.BlockView.title");
    }

    private void initialize(Composite composite) {
        if (this.fileInfoComposite != null && !this.fileInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "FileInfoView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createFileInfoPanel(composite);
    }

    private Composite createFileInfoPanel(Composite parent) {
        this.fileInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fileInfoComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.fileInfoComposite.setLayoutData((Object)gridData);
        new Label(this.fileInfoComposite, 0).setLayoutData((Object)new GridData());
        this.topLabel = new Label(this.fileInfoComposite, 0);
        gridData = new GridData(4, -1, false, false);
        this.topLabel.setLayoutData((Object)gridData);
        this.sc = new ScrolledComposite(this.fileInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.fileInfoCanvas = new Canvas((Composite)this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.fileInfoCanvas.setLayoutData((Object)gridData);
        this.fileInfoCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (e.width <= 0 || e.height <= 0) {
                    return;
                }
                try {
                    Rectangle bounds;
                    Rectangle rectangle = bounds = FileInfoView.this.img == null ? null : FileInfoView.this.img.getBounds();
                    if (bounds == null) {
                        e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    } else {
                        if (e.x + e.width > bounds.width) {
                            e.gc.fillRectangle(bounds.width, e.y, e.x + e.width - bounds.width + 1, e.height);
                        }
                        if (e.y + e.height > bounds.height) {
                            e.gc.fillRectangle(e.x, bounds.height, e.width, e.y + e.height - bounds.height + 1);
                        }
                        int width = Math.min(e.width, bounds.width - e.x);
                        int height = Math.min(e.height, bounds.height - e.y);
                        e.gc.drawImage(FileInfoView.this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.fileInfoCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event2) {
                FileInfoView.this.showPieceDetails(event2.x, event2.y);
            }
        });
        Listener doNothingListener = new Listener(){

            public void handleEvent(Event event2) {
            }
        };
        this.fileInfoCanvas.addListener(1, doNothingListener);
        final Menu menu = new Menu((Decorations)this.fileInfoCanvas.getShell(), 8);
        this.fileInfoCanvas.setMenu(menu);
        this.fileInfoCanvas.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                Point pt = FileInfoView.this.fileInfoCanvas.toControl(event2.x, event2.y);
                int piece_number = FileInfoView.this.getPieceNumber(pt.x, pt.y);
                menu.setData("pieceNumber", (Object)piece_number);
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent event2) {
                Integer pn = (Integer)menu.getData("pieceNumber");
                if (pn != null && pn != -1) {
                    DownloadManager download_manager = FileInfoView.this.file.getDownloadManager();
                    if (download_manager == null) {
                        return;
                    }
                    DiskManager disk_manager = download_manager.getDiskManager();
                    PEPeerManager peer_manager = download_manager.getPeerManager();
                    if (disk_manager == null || peer_manager == null) {
                        return;
                    }
                    final PiecePicker picker = peer_manager.getPiecePicker();
                    DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
                    PEPiece[] pe_pieces = peer_manager.getPieces();
                    final int piece_number = pn;
                    final DiskManagerPiece dm_piece = dm_pieces[piece_number];
                    final PEPiece pe_piece = pe_pieces[piece_number];
                    final MenuItem force_piece = new MenuItem(menu, 32);
                    Messages.setLanguageText((Widget)force_piece, "label.force.piece");
                    boolean done = dm_piece.isDone();
                    force_piece.setEnabled(!done);
                    if (!done) {
                        force_piece.setSelection(picker.isForcePiece(piece_number));
                        force_piece.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                picker.setForcePiece(piece_number, force_piece.getSelection());
                            }
                        });
                    }
                    MenuItem reset_piece = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)reset_piece, "label.reset.piece");
                    boolean can_reset = dm_piece.isDone() || dm_piece.getNbWritten() > 0;
                    reset_piece.setEnabled(can_reset);
                    reset_piece.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (pe_piece != null) {
                                pe_piece.reset();
                            } else {
                                dm_piece.reset();
                            }
                        }
                    });
                }
            }
        });
        this.fileInfoCanvas.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (FileInfoView.this.refreshInfoCanvasQueued) {
                    return;
                }
                FileInfoView.this.refreshInfoCanvasQueued = true;
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        int iNewColCount;
                        int iOldColCount;
                        if ((this).FileInfoView.this.img != null && (iOldColCount = (this).FileInfoView.this.img.getBounds().width / 16) != (iNewColCount = (this).FileInfoView.this.fileInfoCanvas.getClientArea().width / 16)) {
                            FileInfoView.this.refreshInfoCanvas();
                        }
                    }
                });
            }
        });
        this.sc.setContent((Control)this.fileInfoCanvas);
        Legend.createLegendComposite(this.fileInfoComposite, this.blockColors, new String[]{"FileView.BlockView.Done", "FileView.BlockView.Skipped", "FileView.BlockView.Active", "FileView.BlockView.Outstanding"}, new GridData(4, -1, true, false, 2, 1));
        return this.fileInfoComposite;
    }

    private void fillFileInfoSection() {
        if (this.topLabel == null || this.topLabel.isDisposed()) {
            return;
        }
        this.topLabel.setText("");
        this.refreshInfoCanvas();
    }

    private void refresh() {
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    private int getPieceNumber(int x, int y) {
        Rectangle bounds = this.fileInfoCanvas.getClientArea();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return -1;
        }
        if (this.file == null) {
            return -1;
        }
        DownloadManager download_manager = this.file.getDownloadManager();
        if (download_manager == null) {
            return -1;
        }
        DiskManager disk_manager = download_manager.getDiskManager();
        PEPeerManager peer_manager = download_manager.getPeerManager();
        if (disk_manager == null || peer_manager == null) {
            return -1;
        }
        int first_piece = this.file.getFirstPieceNumber();
        int num_pieces = this.file.getNbPieces();
        int y_block = y / 16;
        int iNumCols = bounds.width / 16;
        int x_block = x / 16;
        int piece_number = y_block * iNumCols + x_block + first_piece;
        if (piece_number >= first_piece && piece_number < first_piece + num_pieces) {
            return piece_number;
        }
        return -1;
    }

    protected void showPieceDetails(int x, int y) {
        int piece_number = this.getPieceNumber(x, y);
        if (piece_number >= 0) {
            DownloadManager download_manager = this.file.getDownloadManager();
            if (download_manager == null) {
                this.topLabel.setText("");
                return;
            }
            DiskManager disk_manager = download_manager.getDiskManager();
            PEPeerManager peer_manager = download_manager.getPeerManager();
            if (disk_manager == null || peer_manager == null) {
                this.topLabel.setText("");
                return;
            }
            DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
            PEPiece[] pe_pieces = peer_manager.getPieces();
            DiskManagerPiece dm_piece = dm_pieces[piece_number];
            PEPiece pe_piece = pe_pieces[piece_number];
            String text = "Piece " + piece_number + ": " + dm_piece.getString();
            if (pe_piece != null) {
                text = String.valueOf(text) + ", active: " + pe_piece.getString();
            } else if (dm_piece.isNeeded() && !dm_piece.isDone()) {
                text = String.valueOf(text) + ", inactive: " + peer_manager.getPiecePicker().getPieceString(piece_number);
            }
            this.topLabel.setText(text);
        } else {
            this.topLabel.setText("");
        }
    }

    protected void refreshInfoCanvas() {
        block12: {
            PEPeerManager peer_manager;
            if (this.fileInfoCanvas == null || this.fileInfoCanvas.isDisposed()) {
                return;
            }
            this.refreshInfoCanvasQueued = false;
            Rectangle bounds = this.fileInfoCanvas.getClientArea();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return;
            }
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
                this.img = null;
            }
            DownloadManager download_manager = this.file == null ? null : this.file.getDownloadManager();
            DiskManager disk_manager = download_manager == null ? null : download_manager.getDiskManager();
            PEPeerManager pEPeerManager = peer_manager = download_manager == null ? null : download_manager.getPeerManager();
            if (this.file == null || disk_manager == null || peer_manager == null) {
                GC gc = new GC((Drawable)this.fileInfoCanvas);
                gc.fillRectangle(bounds);
                gc.dispose();
                return;
            }
            int first_piece = this.file.getFirstPieceNumber();
            int num_pieces = this.file.getNbPieces();
            int iNumCols = bounds.width / 16;
            int iNeededHeight = ((num_pieces - 1) / iNumCols + 1) * 16;
            if (this.sc.getMinHeight() != iNeededHeight) {
                this.sc.setMinHeight(iNeededHeight);
                this.sc.layout(true, true);
                bounds = this.fileInfoCanvas.getClientArea();
            }
            this.img = new Image((Device)this.fileInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
            GC gcImg = new GC((Drawable)this.img);
            try {
                try {
                    gcImg.setBackground(this.fileInfoCanvas.getBackground());
                    gcImg.fillRectangle(0, 0, bounds.width, bounds.height);
                    DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
                    PEPiece[] pe_pieces = peer_manager.getPieces();
                    int iRow = 0;
                    int iCol = 0;
                    int i = first_piece;
                    while (i < first_piece + num_pieces) {
                        DiskManagerPiece dm_piece = dm_pieces[i];
                        PEPiece pe_piece = pe_pieces[i];
                        int iXPos = iCol * 16;
                        int iYPos = iRow * 16;
                        int colorIndex = dm_piece.isDone() ? 0 : (!dm_piece.isNeeded() ? 1 : (pe_piece != null ? 2 : 3));
                        gcImg.setBackground(this.blockColors[colorIndex]);
                        gcImg.fillRectangle(iXPos, iYPos, 14, 14);
                        if (++iCol >= iNumCols) {
                            iCol = 0;
                            ++iRow;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
                    gcImg.dispose();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                gcImg.dispose();
                throw throwable;
            }
            gcImg.dispose();
        }
        this.fileInfoCanvas.redraw();
    }

    private Composite getComposite() {
        return this.fileInfoComposite;
    }

    private void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                UISWTView parentView;
                MultipleDocumentInterface mdi;
                this.swtView = (UISWTView)event2.getData();
                if (this.swtView instanceof MdiEntry && (mdi = ((MdiEntry)((Object)this.swtView)).getMDI()) instanceof BaseMDI && !((parentView = ((BaseMDI)mdi).getParentView()) instanceof MdiEntry)) {
                    return false;
                }
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.refreshInfoCanvas();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

