/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.peer;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableRefreshListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class PeerFilesView
extends TableViewTab<PeersFilesViewRow>
implements TableDataSourceChangedListener,
TableRefreshListener {
    public static final String TABLEID_PEER_FILES = "PeerFiles";
    public static final String MSGID_PREFIX = "PeerFilesView";
    boolean refreshing = false;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PercentItem(), new PiecesItem()};
    private TableViewSWT<PeersFilesViewRow> tv;
    private PEPeer current_peer;

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames(TABLEID_PEER_FILES, basicItems);
    }

    public PeerFilesView() {
        super(MSGID_PREFIX);
    }

    @Override
    public boolean allowCreate(UISWTView swtView) {
        String viewID;
        if (swtView instanceof MdiEntry && !"Peers".equals(viewID = ((MdiEntry)((Object)swtView)).getMDI().getViewID())) {
            return false;
        }
        return super.allowCreate(swtView);
    }

    @Override
    public TableViewSWT<PeersFilesViewRow> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(PeersFilesViewRow.class, TABLEID_PEER_FILES, this.getPropertiesPrefix(), basicItems, "firstpiece", 0x10010002);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        return this.tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        Object[] temp;
        if (newDataSource instanceof PEPeer) {
            this.current_peer = (PEPeer)newDataSource;
        }
        this.current_peer = newDataSource instanceof Object[] ? ((temp = (Object[])newDataSource).length == 1 && temp[0] instanceof PEPeer ? (PEPeer)temp[0] : null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableRefresh() {
        PeerFilesView peerFilesView = this;
        synchronized (peerFilesView) {
            if (this.refreshing) {
                return;
            }
            this.refreshing = true;
        }
        try {
            PEPeer peer = this.current_peer;
            if (peer == null || peer.getManager().isDestroyed()) {
                this.current_peer = null;
                this.tv.removeAllTableRows();
            } else if (this.tv.getRowCount() == 0) {
                DiskManagerFileInfo[] files = peer.getManager().getDiskManager().getFiles();
                PeersFilesViewRow[] rows = new PeersFilesViewRow[files.length];
                int i = 0;
                while (i < files.length) {
                    rows[i] = new PeersFilesViewRow(files[i], peer);
                    ++i;
                }
                this.tv.addDataSources((PeersFilesViewRow[])rows);
                this.tv.processDataSourceQueueSync();
            } else {
                TableRowCore[] rows;
                TableRowCore[] tableRowCoreArray = rows = this.tv.getRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    ((PeersFilesViewRow)row.getDataSource()).setPeer(peer);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            PeerFilesView peerFilesView2 = this;
            synchronized (peerFilesView2) {
                this.refreshing = false;
            }
            throw throwable;
        }
        PeerFilesView peerFilesView3 = this;
        synchronized (peerFilesView3) {
            this.refreshing = false;
        }
    }

    @Override
    public void tableViewTabInitComplete() {
        super.tableViewTabInitComplete();
    }

    private static class NameItem
    extends CoreTableColumnSWT
    implements TableCellRefreshListener {
        private NameItem() {
            super("name", 1, -2, 300, PeerFilesView.TABLEID_PEER_FILES);
            this.setType(1);
        }

        @Override
        public void fillTableColumnInfo(TableColumnInfo info) {
            info.addCategories(new String[]{"content", "essential"});
            info.setProficiency((byte)0);
        }

        @Override
        public void refresh(TableCell cell) {
            String name;
            PeersFilesViewRow row = (PeersFilesViewRow)cell.getDataSource();
            String string = name = row == null ? "" : row.getFile().getFile(true).getName();
            if (name == null) {
                name = "";
            }
            cell.setText(name);
        }
    }

    protected static class PeersFilesViewRow {
        private DiskManagerFileInfo file;
        private PEPeer peer;

        private PeersFilesViewRow(DiskManagerFileInfo _file, PEPeer _peer) {
            this.file = _file;
            this.peer = _peer;
        }

        private DiskManagerFileInfo getFile() {
            return this.file;
        }

        private void setPeer(PEPeer _peer) {
            this.peer = _peer;
        }

        private PEPeer getPeer() {
            return this.peer;
        }
    }

    private static class PercentItem
    extends CoreTableColumnSWT
    implements TableCellRefreshListener {
        private PercentItem() {
            super("%", 2, -2, 60, PeerFilesView.TABLEID_PEER_FILES);
            this.setRefreshInterval(-2);
        }

        @Override
        public void fillTableColumnInfo(TableColumnInfo info) {
            info.addCategories(new String[]{"progress"});
            info.setProficiency((byte)0);
        }

        @Override
        public void refresh(TableCell cell) {
            PeersFilesViewRow row = (PeersFilesViewRow)cell.getDataSource();
            if (row == null) {
                return;
            }
            DiskManagerFileInfo file = row.getFile();
            PEPeer peer = row.getPeer();
            BitFlags pieces = peer.getAvailable();
            if (pieces == null) {
                cell.setText("");
                cell.setSortValue(-1L);
                return;
            }
            boolean[] flags = pieces.flags;
            int first_piece = file.getFirstPieceNumber();
            int last_piece = file.getLastPieceNumber();
            int done = 0;
            int i = first_piece;
            while (i <= last_piece) {
                if (flags[i]) {
                    ++done;
                }
                ++i;
            }
            int percent = done * 1000 / (last_piece - first_piece + 1);
            if (!cell.setSortValue(percent) && cell.isValid()) {
                return;
            }
            cell.setText(percent < 0 ? "" : DisplayFormatters.formatPercentFromThousands(percent));
        }
    }

    private static class PiecesItem
    extends CoreTableColumnSWT
    implements TableCellAddedListener,
    TableCellDisposeListener,
    TableCellVisibilityListener {
        private static final int borderWidth = 1;

        private PiecesItem() {
            super("pieces", PeerFilesView.TABLEID_PEER_FILES);
            this.initializeAsGraphic(200);
            this.setMinWidth(100);
        }

        @Override
        public void fillTableColumnInfo(TableColumnInfo info) {
            info.addCategories(new String[]{"content", "progress"});
            info.setProficiency((byte)1);
        }

        @Override
        public void cellAdded(TableCell cell) {
            new Cell(cell);
        }

        @Override
        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 1) {
                this.dispose(cell);
            }
        }

        @Override
        public void dispose(TableCell cell) {
            Image img;
            Graphic graphic = cell.getGraphic();
            if (graphic instanceof UISWTGraphic && (img = ((UISWTGraphic)graphic).getImage()) != null && !img.isDisposed()) {
                Utils.execSWTThread(() -> Utils.disposeSWTObjects(img));
                ((UISWTGraphic)graphic).setImage(null);
            }
        }

        private class Cell
        implements TableCellLightRefreshListener {
            private int lastPercentDone = 0;
            private boolean bNoRed = false;
            private long last_draw_time = SystemTime.getMonotonousTime();

            public Cell(TableCell cell) {
                cell.setFillCell(false);
                cell.addListeners(this);
            }

            @Override
            public void refresh(TableCell cell) {
                this.refresh(cell, false);
            }

            @Override
            public void refresh(TableCell cell, boolean sortOnly) {
                boolean bImageBufferValid;
                PeersFilesViewRow row = (PeersFilesViewRow)cell.getDataSource();
                if (row == null) {
                    return;
                }
                DiskManagerFileInfo file = row.getFile();
                PEPeer peer = row.getPeer();
                BitFlags pieces = peer.getAvailable();
                boolean[] flags = pieces == null ? null : pieces.flags;
                int firstPiece = file.getFirstPieceNumber();
                int lastPiece = file.getLastPieceNumber();
                int done = 0;
                if (flags != null) {
                    int i = firstPiece;
                    while (i <= lastPiece) {
                        if (flags[i]) {
                            ++done;
                        }
                        ++i;
                    }
                }
                int percentDone = done * 1000 / (lastPiece - firstPiece + 1);
                cell.setSortValue(percentDone);
                if (sortOnly) {
                    PiecesItem.this.dispose(cell);
                    return;
                }
                int newWidth = cell.getWidth();
                if (newWidth <= 0) {
                    return;
                }
                int newHeight = cell.getHeight() - 2;
                int x1 = newWidth - 1 - 1;
                int y1 = newHeight - 1 - 1;
                if (x1 < 10 || y1 < 3) {
                    return;
                }
                boolean hasGraphic = false;
                Graphic graphic = cell.getGraphic();
                if (graphic instanceof UISWTGraphic) {
                    Image img = ((UISWTGraphic)graphic).getImage();
                    hasGraphic = img != null && !img.isDisposed();
                }
                boolean bl = bImageBufferValid = this.lastPercentDone == percentDone && cell.isValid() && this.bNoRed && hasGraphic;
                if (bImageBufferValid) {
                    return;
                }
                this.lastPercentDone = percentDone;
                Image piecesImage = null;
                if (graphic instanceof UISWTGraphic) {
                    piecesImage = ((UISWTGraphic)graphic).getImage();
                }
                if (piecesImage != null && !piecesImage.isDisposed()) {
                    piecesImage.dispose();
                }
                piecesImage = new Image((Device)Utils.getDisplay(), newWidth, newHeight);
                GC gcImage = new GC((Drawable)piecesImage);
                long now = SystemTime.getMonotonousTime();
                this.bNoRed = true;
                if (percentDone == 1000) {
                    gcImage.setForeground(Colors.blues[9]);
                    gcImage.setBackground(Colors.blues[9]);
                    gcImage.fillRectangle(1, 1, newWidth - 2, newHeight - 2);
                } else {
                    int nbPieces = file.getNbPieces();
                    if (nbPieces < 0) {
                        nbPieces = 0;
                    }
                    if (flags != null) {
                        PEPeerManager pm;
                        DiskManagerPiece[] dm_pieces = null;
                        PEPiece[] pe_pieces = null;
                        if (peer.isMyPeer() && (pm = peer.getManager()) != null) {
                            pe_pieces = pm.getPieces();
                            DiskManager dm = pm.getDiskManager();
                            if (dm != null) {
                                dm_pieces = dm.getPieces();
                            }
                        }
                        this.bNoRed = true;
                        int i = 0;
                        while (i < newWidth) {
                            int a1 = (i + 1) * nbPieces / newWidth;
                            int a0 = i * nbPieces / newWidth;
                            if (a1 == a0) {
                                ++a1;
                            }
                            if (a1 > nbPieces && nbPieces != 0) {
                                a1 = nbPieces;
                            }
                            int nbAvailable = 0;
                            boolean written = false;
                            boolean partially_written = false;
                            if (firstPiece >= 0) {
                                int j = a0;
                                while (j < a1) {
                                    DiskManagerPiece dm_piece;
                                    int this_index = j + firstPiece;
                                    if (dm_pieces != null && (dm_piece = dm_pieces[this_index]).isDone()) {
                                        ++nbAvailable;
                                    }
                                    if (!written) {
                                        boolean[] blocks;
                                        PEPiece pe_piece;
                                        if (pe_pieces != null && (pe_piece = pe_pieces[this_index]) != null) {
                                            boolean bl2 = written = pe_piece.getLastDownloadTime(now) + 500L > this.last_draw_time;
                                        }
                                        if (!written && !partially_written && dm_pieces != null && (blocks = dm_pieces[this_index].getWritten()) != null) {
                                            boolean[] blArray = blocks;
                                            int n = blocks.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                boolean block = blArray[n2];
                                                if (block) {
                                                    partially_written = true;
                                                    break;
                                                }
                                                ++n2;
                                            }
                                        }
                                    }
                                    ++j;
                                }
                            } else {
                                nbAvailable = 1;
                            }
                            gcImage.setBackground(written ? Colors.red : (partially_written ? Colors.grey : Colors.blues[nbAvailable * 9 / (a1 - a0)]));
                            gcImage.fillRectangle(i, 1, 1, newHeight - 2);
                            if (written) {
                                this.bNoRed = false;
                            }
                            ++i;
                        }
                    }
                }
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
                gcImage.dispose();
                this.last_draw_time = now;
                if (cell instanceof TableCellSWT) {
                    ((TableCellSWT)cell).setGraphic(piecesImage);
                } else {
                    cell.setGraphic(new UISWTGraphicImpl(piecesImage));
                }
            }
        }
    }
}

