/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.Core;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.skin.SBC_LibraryTableView;
import com.biglybt.ui.swt.views.skin.SB_Transfers;
import com.biglybt.ui.swt.views.table.TableViewSWT;

public class MyTorrentsView_Big
extends MyTorrentsView {
    private final int torrentFilterMode;

    public MyTorrentsView_Big(Core _core, int torrentFilterMode, Object dataSource, TableColumnCore[] basicItems, BubbleTextBox txtFilter) {
        super(true);
        Class forDataSourceType;
        this.torrentFilterMode = torrentFilterMode;
        this.filterBox = txtFilter;
        switch (torrentFilterMode) {
            case 1: 
            case 3: {
                forDataSourceType = DownloadTypeComplete.class;
                break;
            }
            case 2: {
                forDataSourceType = DownloadTypeIncomplete.class;
                break;
            }
            default: {
                forDataSourceType = Download.class;
            }
        }
        TableViewSWT<DownloadManager> tv = this.init(_core, SB_Transfers.getTableIdFromFilterMode(torrentFilterMode, true, dataSource), forDataSourceType, basicItems);
        tv.setRowDefaultHeightEM(2.0f);
    }

    @Override
    public boolean isOurDownloadManager(DownloadManager dm) {
        if (PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
            return false;
        }
        if (this.torrentFilterMode == 3) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                return false;
            }
        } else if (this.torrentFilterMode == 0) {
            if (!this.isInCurrentTag(dm)) {
                return false;
            }
            return this.isInCurrentTag(dm);
        }
        return super.isOurDownloadManager(dm);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask, int origin) {
        boolean neverPlay = DownloadTypeIncomplete.class.equals(this.getForDataSourceType());
        SBC_LibraryTableView.doDefaultClick(rows, stateMask, neverPlay, origin);
    }
}

