/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ActivityView
implements ParameterListener,
UISWTViewCoreEventListener,
IViewRequiresPeriodicUpdates {
    public static final String MSGID_PREFIX = "SpeedView";
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Composite panel;
    Canvas downSpeedCanvas;
    SpeedGraphic downSpeedGraphic = SpeedGraphic.getInstance();
    Canvas upSpeedCanvas;
    SpeedGraphic upSpeedGraphic = SpeedGraphic.getInstance();

    public ActivityView() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                ActivityView.this.manager = core.getGlobalManager();
                ActivityView.this.stats = ActivityView.this.manager.getStats();
            }
        });
    }

    public void periodicUpdate() {
        if (this.manager == null || this.stats == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        int kinb = DisplayFormatters.getKinB();
        this.downSpeedGraphic.addIntsValue(new int[]{this.stats.getDataReceiveRate() + this.stats.getProtocolReceiveRate(), this.stats.getProtocolReceiveRate(), COConfigurationManager.getIntParameter("Max Download Speed KBs") * kinb, swarms_peer_speed});
        this.upSpeedGraphic.addIntsValue(new int[]{this.stats.getDataSendRate() + this.stats.getProtocolSendRate(), this.stats.getProtocolSendRate(), COConfigurationManager.getIntParameter(TransferSpeedValidator.getActiveUploadParameter(this.manager)) * kinb, swarms_peer_speed});
    }

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout());
        Group gDownSpeed = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gDownSpeed, "SpeedView.downloadSpeed.title");
        GridData gridData = new GridData(1808);
        gDownSpeed.setLayoutData((Object)gridData);
        gDownSpeed.setLayout((Layout)new GridLayout());
        this.downSpeedCanvas = new Canvas((Composite)gDownSpeed, 262144);
        gridData = new GridData(1808);
        this.downSpeedCanvas.setLayoutData((Object)gridData);
        this.downSpeedGraphic.initialize(this.downSpeedCanvas);
        Color[] colors = this.downSpeedGraphic.colors;
        Group gUpSpeed = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gUpSpeed, "SpeedView.uploadSpeed.title");
        gridData = new GridData(1808);
        gUpSpeed.setLayoutData((Object)gridData);
        gUpSpeed.setLayout((Layout)new GridLayout());
        this.upSpeedCanvas = new Canvas((Composite)gUpSpeed, 262144);
        gridData = new GridData(1808);
        this.upSpeedCanvas.setLayoutData((Object)gridData);
        this.upSpeedGraphic.initialize(this.upSpeedCanvas);
        COConfigurationManager.addAndFireParameterListener("Stats Graph Dividers", this);
        this.upSpeedGraphic.setLineColors(colors);
        String[] colorConfigs = new String[]{"ActivityView.legend.peeraverage", "ActivityView.legend.achieved", "ActivityView.legend.overhead", "ActivityView.legend.limit", "ActivityView.legend.swarmaverage", "ActivityView.legend.trimmed"};
        Legend.createLegendComposite(this.panel, colors, colorConfigs);
        this.panel.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                ActivityView.this.refresh(true);
            }
        });
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        this.downSpeedGraphic.dispose();
        this.upSpeedGraphic.dispose();
        COConfigurationManager.removeParameterListener("Stats Graph Dividers", this);
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh(boolean force) {
        this.downSpeedGraphic.refresh(force);
        this.upSpeedGraphic.refresh(force);
    }

    @Override
    public void parameterChanged(String param_name) {
        boolean update_dividers = COConfigurationManager.getBooleanParameter("Stats Graph Dividers");
        int update_divider_width = update_dividers ? 60 : 0;
        this.downSpeedGraphic.setUpdateDividerWidth(update_divider_width);
        this.upSpeedGraphic.setUpdateDividerWidth(update_divider_width);
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                UISWTView swtView = event2.getView();
                swtView.setTitle(MessageText.getString("SpeedView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.refresh(true);
                break;
            }
            case 5: {
                this.refresh(false);
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

