/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.control.DHTControlActivity;
import com.biglybt.core.dht.control.DHTControlListener;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.views.stats.GeneralOpsPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;

public class DHTOpsPanel
implements DHTControlListener {
    private final GeneralOpsPanel gop;
    private DHT current_dht;
    private Map<DHTControlActivity, ActivityHolder> activity_map = new IdentityHashMap<DHTControlActivity, ActivityHolder>();
    private Map<ActivityHolder, DHTControlActivity> activity_reverse_map = new IdentityHashMap<ActivityHolder, DHTControlActivity>();

    public DHTOpsPanel(Composite parent) {
        this.gop = new GeneralOpsPanel(parent);
    }

    public void setLayoutData(Object data) {
        this.gop.setLayoutData(data);
    }

    public void setID(String id) {
        this.gop.setID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activityChanged(DHTControlActivity activity, int type) {
        ActivityHolder holder;
        boolean removed = type == 3;
        List expired = null;
        Map<DHTControlActivity, ActivityHolder> map = this.activity_map;
        synchronized (map) {
            if (removed) {
                holder = this.activity_map.remove(activity);
                if (holder != null) {
                    this.activity_reverse_map.remove(holder);
                }
            } else {
                holder = this.activity_map.get(activity);
                if (holder == null) {
                    holder = new ActivityHolder(activity);
                    this.activity_map.put(activity, holder);
                    this.activity_reverse_map.put(holder, activity);
                    if (this.activity_map.size() > 250) {
                        ArrayList<ActivityHolder> holders = new ArrayList<ActivityHolder>(this.activity_map.values());
                        Collections.sort(holders, new Comparator<ActivityHolder>(){

                            @Override
                            public int compare(ActivityHolder a1, ActivityHolder a2) {
                                long res = a1.getCreateTime() - a2.getCreateTime();
                                if (res < 0L) {
                                    return -1;
                                }
                                if (res > 0L) {
                                    return 1;
                                }
                                return 0;
                            }
                        });
                        expired = holders.subList(0, Math.min(holders.size(), 50));
                        for (ActivityHolder h : expired) {
                            this.activity_map.remove(h.getActivity());
                            this.activity_reverse_map.remove(h);
                        }
                    }
                }
            }
        }
        if (expired != null) {
            for (ActivityHolder h : expired) {
                this.gop.activityChanged(h, true);
            }
        }
        if (holder != null) {
            this.gop.activityChanged(holder, removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshView(DHT dht) {
        if (this.current_dht != dht) {
            if (this.current_dht != null) {
                this.current_dht.getControl().removeListener(this);
            }
            this.current_dht = dht;
            this.gop.reset();
            Map<DHTControlActivity, ActivityHolder> map = this.activity_map;
            synchronized (map) {
                this.activity_map.clear();
                this.activity_reverse_map.clear();
            }
            dht.getControl().addListener(this);
        }
        this.refresh();
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.gop.setAutoAlpha(autoAlpha);
    }

    public void setUnavailable() {
        this.gop.setUnavailable();
    }

    public void setFilter(final ActivityFilter f) {
        this.gop.setFilter(new GeneralOpsPanel.ActivityFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accept(GeneralOpsPanel.Activity activity) {
                DHTControlActivity target;
                Map map = DHTOpsPanel.this.activity_map;
                synchronized (map) {
                    target = (DHTControlActivity)DHTOpsPanel.this.activity_reverse_map.get(activity);
                }
                if (target != null) {
                    return f.accept(target);
                }
                return false;
            }
        });
    }

    public void setMinimumSlots(int min) {
        this.gop.setMinimumSlots(min);
    }

    public void setScaleAndRotation(float min_x, float max_x, float min_y, float max_y, double rot) {
        this.gop.setScaleAndRotation(min_x, max_x, min_y, max_y, rot);
    }

    public void refresh() {
        this.gop.refresh();
    }

    public void delete() {
        if (this.current_dht != null) {
            this.current_dht.getControl().removeListener(this);
            this.current_dht = null;
        }
        this.gop.delete();
    }

    public static interface ActivityFilter {
        public boolean accept(DHTControlActivity var1);
    }

    private class ActivityHolder
    implements GeneralOpsPanel.Activity {
        private final long create_time = SystemTime.getMonotonousTime();
        private final DHTControlActivity delegate;

        private ActivityHolder(DHTControlActivity _delegate) {
            this.delegate = _delegate;
        }

        public DHTControlActivity getActivity() {
            return this.delegate;
        }

        public long getCreateTime() {
            return this.create_time;
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public int getType() {
            int type = this.delegate.getType();
            switch (type) {
                case 2: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
            return 4;
        }

        @Override
        public boolean isQueued() {
            return this.delegate.isQueued();
        }

        @Override
        public GeneralOpsPanel.State getCurrentState() {
            DHTControlActivity.ActivityState state = this.delegate.getCurrentState();
            if (state == null) {
                return null;
            }
            return new StateHolder(state);
        }

        private GeneralOpsPanel.Node map(DHTControlActivity.ActivityNode node) {
            return new NodeHolder(node);
        }

        private class NodeHolder
        implements GeneralOpsPanel.Node {
            private final DHTControlActivity.ActivityNode delegate;

            private NodeHolder(DHTControlActivity.ActivityNode _delegate) {
                this.delegate = _delegate;
            }

            @Override
            public List<GeneralOpsPanel.Node> getChildren() {
                List<DHTControlActivity.ActivityNode> kids = this.delegate.getChildren();
                ArrayList<GeneralOpsPanel.Node> result = new ArrayList<GeneralOpsPanel.Node>();
                for (DHTControlActivity.ActivityNode n : kids) {
                    result.add(ActivityHolder.this.map(n));
                }
                return result;
            }
        }

        private class StateHolder
        implements GeneralOpsPanel.State {
            private final DHTControlActivity.ActivityState delegate;

            private StateHolder(DHTControlActivity.ActivityState _delegate) {
                this.delegate = _delegate;
            }

            @Override
            public GeneralOpsPanel.Node getRootNode() {
                return ActivityHolder.this.map(this.delegate.getRootNode());
            }

            @Override
            public int getDepth() {
                return this.delegate.getDepth();
            }

            @Override
            public String getResult() {
                return this.delegate.getResult();
            }
        }
    }
}

