/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.stats.BasePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class GeneralOpsPanel
extends BasePanel {
    private static final int ALPHA_FOCUS = 255;
    private static final int ALPHA_NOFOCUS = 150;
    private static final int FADE_OUT = 10000;
    private static Map<String, BasePanel.Scale> scale_map = new HashMap<String, BasePanel.Scale>();
    Display display;
    Composite parent;
    Canvas canvas;
    BasePanel.Scale scale;
    private int min_slots = 8;
    private boolean unavailable;
    private String id;
    private Image img;
    private int alpha = 255;
    private boolean autoAlpha = false;
    private ActivityFilter filter;
    private Map<Activity, ActivityDetail> activity_map = new IdentityHashMap<Activity, ActivityDetail>();
    private TimerEventPeriodic timeout_timer;
    private Map<Node, Rectangle> node_text_map = new HashMap<Node, Rectangle>();
    private boolean isRefreshQueued = false;

    public GeneralOpsPanel(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        this.canvas = new Canvas(parent, 262144);
        this.scale = new BasePanel.Scale();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (GeneralOpsPanel.this.img != null && !GeneralOpsPanel.this.img.isDisposed()) {
                    Rectangle bounds = GeneralOpsPanel.this.img.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        if (GeneralOpsPanel.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(GeneralOpsPanel.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(GeneralOpsPanel.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.setBackground(Colors.getSystemColor((Device)GeneralOpsPanel.this.display, 22));
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    e.gc.drawText(MessageText.getString(GeneralOpsPanel.this.unavailable ? "DHTOpsView.notAvailable" : "v3.MainWindow.view.wait"), 10, 10, true);
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                GeneralOpsPanel.this.scale.mouseDown(event2);
            }

            public void mouseUp(MouseEvent event2) {
                int y;
                int x;
                if (GeneralOpsPanel.this.scale.mouseLeftDown) {
                    x = event2.x;
                    y = event2.y;
                    for (Map.Entry entry : GeneralOpsPanel.this.node_text_map.entrySet()) {
                        if (!((Rectangle)entry.getValue()).contains(x, y)) continue;
                        ((Node)entry.getKey()).eventOccurred(new NodeEvent(){

                            @Override
                            public int getType() {
                                return 1;
                            }

                            @Override
                            public Object getData() {
                                return null;
                            }
                        });
                    }
                }
                if (GeneralOpsPanel.this.scale.mouseRightDown) {
                    x = event2.x;
                    y = event2.y;
                    for (Map.Entry entry : GeneralOpsPanel.this.node_text_map.entrySet()) {
                        if (!((Rectangle)entry.getValue()).contains(x, y)) continue;
                        Menu menu = GeneralOpsPanel.this.canvas.getMenu();
                        if (menu != null && !menu.isDisposed()) {
                            menu.dispose();
                        }
                        menu = new Menu((Control)GeneralOpsPanel.this.canvas);
                        Point cursorLocation = Display.getCurrent().getCursorLocation();
                        menu.setLocation(cursorLocation.x, cursorLocation.y);
                        menu.setVisible(true);
                        final Menu f_menu = menu;
                        ((Node)entry.getKey()).eventOccurred(new NodeEvent(){

                            @Override
                            public int getType() {
                                return 2;
                            }

                            @Override
                            public Object getData() {
                                return f_menu;
                            }
                        });
                        break;
                    }
                }
                GeneralOpsPanel.this.scale.mouseUp(event2);
                GeneralOpsPanel.this.refresh();
            }

            public void mouseDoubleClick(MouseEvent e) {
                GeneralOpsPanel.this.scale.reset();
                GeneralOpsPanel.this.refresh();
            }
        });
        this.canvas.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addListener(37, new Listener(){

            public void handleEvent(Event event2) {
                GeneralOpsPanel.this.scale.mouseWheel(event2);
                GeneralOpsPanel.this.refresh();
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event2) {
                if (GeneralOpsPanel.this.scale.mouseMove(event2)) {
                    GeneralOpsPanel.this.refresh();
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (GeneralOpsPanel.this.autoAlpha) {
                    GeneralOpsPanel.this.setAlpha(150);
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (GeneralOpsPanel.this.autoAlpha) {
                    GeneralOpsPanel.this.setAlpha(255);
                }
            }
        });
        this.timeout_timer = SimpleTimer.addPeriodicEvent("DHTOps:timer", 30000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                if (GeneralOpsPanel.this.canvas.isDisposed()) {
                    GeneralOpsPanel.this.timeout_timer.cancel();
                    return;
                }
                Map map = GeneralOpsPanel.this.activity_map;
                synchronized (map) {
                    Iterator it = GeneralOpsPanel.this.activity_map.values().iterator();
                    while (it.hasNext()) {
                        ActivityDetail act = (ActivityDetail)it.next();
                        if (!act.isComplete()) continue;
                        it.remove();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(String _id) {
        BasePanel.Scale existing;
        this.id = _id;
        Map<String, BasePanel.Scale> map = scale_map;
        synchronized (map) {
            existing = scale_map.get(this.id);
        }
        if (existing != null) {
            Utils.execSWTThread(() -> {
                this.scale = existing;
                this.refresh();
            });
        }
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityChanged(Activity activity, boolean removed) {
        if (this.filter != null && !this.filter.accept(activity)) {
            return;
        }
        if (activity.isQueued()) {
            return;
        }
        Map<Activity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            ActivityDetail details = this.activity_map.get(activity);
            if (details == null && !removed) {
                details = new ActivityDetail(activity);
                this.activity_map.put(activity, details);
                if (this.activity_map.size() > 250) {
                    ArrayList<ActivityDetail> entries = new ArrayList<ActivityDetail>(this.activity_map.values());
                    Collections.sort(entries, new Comparator<ActivityDetail>(){

                        @Override
                        public int compare(ActivityDetail a1, ActivityDetail a2) {
                            long res = a1.getCreateTime() - a2.getCreateTime();
                            if (res < 0L) {
                                return -1;
                            }
                            if (res > 0L) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    int i = 0;
                    while (i < Math.min(50, entries.size())) {
                        this.activity_map.remove(((ActivityDetail)entries.get(i)).getActivity());
                        ++i;
                    }
                }
            }
            if (details != null && removed) {
                details.setComplete();
            }
        }
    }

    protected void setUnavailable() {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                GeneralOpsPanel.this.unavailable = true;
                if (!GeneralOpsPanel.this.canvas.isDisposed()) {
                    GeneralOpsPanel.this.canvas.redraw();
                }
            }
        });
    }

    public void setFilter(ActivityFilter f) {
        this.filter = f;
    }

    public void setMinimumSlots(int min) {
        this.min_slots = min;
    }

    public void setScaleAndRotation(float min_x, float max_x, float min_y, float max_y, double rot) {
        this.scale.setScaleAndRotation(min_x, max_x, min_y, max_y, rot);
    }

    public void refresh() {
        if (this.isRefreshQueued) {
            return;
        }
        this.isRefreshQueued = true;
        Utils.execSWTThreadLater(20, () -> {
            this.isRefreshQueued = false;
            this._refresh();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refresh() {
        ArrayList<ActivityDetail> activities;
        boolean needNewImage;
        if (this.canvas.isDisposed()) {
            return;
        }
        Point canvasSize = this.canvas.getSize();
        Rectangle size = new Rectangle(0, 0, canvasSize.x, canvasSize.y);
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        this.scale.setSize(size);
        boolean bl = needNewImage = this.img == null || this.img.isDisposed();
        if (!needNewImage) {
            Rectangle bounds = this.img.getBounds();
            boolean bl2 = needNewImage = bounds.width != size.width || bounds.height != size.height;
        }
        if (needNewImage) {
            this.img = new Image((Device)this.display, size);
        }
        boolean dark = Utils.isDarkAppearanceNative();
        GC gc = new GC((Drawable)this.img);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        Color white = Colors.white;
        gc.setBackground(dark ? this.canvas.getBackground() : white);
        gc.fillRectangle(size);
        ArrayList<ActivityDetail> to_remove = new ArrayList<ActivityDetail>();
        Map<Activity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            activities = new ArrayList<ActivityDetail>(this.activity_map.values());
        }
        long now = SystemTime.getMonotonousTime();
        int max_slot = Math.max(activities.size(), this.min_slots);
        for (ActivityDetail details : activities) {
            max_slot = Math.max(max_slot, details.getSlot() + 1);
            long comp_at = details.getCompleteTime();
            if (comp_at < 0L || now - comp_at <= 10000L) continue;
            to_remove.add(details);
        }
        boolean[] slots_in_use = new boolean[max_slot];
        for (ActivityDetail details : activities) {
            int slot = details.getSlot();
            if (slot == -1) continue;
            slots_in_use[slot] = true;
        }
        int pos = 0;
        for (ActivityDetail details : activities) {
            int slot = details.getSlot();
            if (slot != -1) continue;
            while (slots_in_use[pos]) {
                ++pos;
            }
            details.setSlot(pos++);
        }
        int x_origin = this.scale.getX(0.0f, 0.0f);
        int y_origin = this.scale.getY(0.0f, 0.0f);
        double slice_angle = Math.PI * 2 / (double)max_slot;
        this.node_text_map.clear();
        for (ActivityDetail details : activities) {
            details.draw(gc, x_origin, y_origin, slice_angle);
        }
        gc.setForeground(dark ? Colors.light_grey : Colors.black);
        if (activities.size() == 0) {
            gc.drawText(MessageText.getString("DHTOpsView.idle"), x_origin, y_origin);
        } else {
            gc.drawLine(x_origin - 5, y_origin, x_origin + 5, y_origin);
            gc.drawLine(x_origin, y_origin - 5, x_origin, y_origin + 5);
        }
        gc.dispose();
        this.canvas.redraw();
        if (to_remove.size() > 0) {
            Map<Activity, ActivityDetail> map2 = this.activity_map;
            synchronized (map2) {
                for (ActivityDetail detail : to_remove) {
                    this.activity_map.remove(detail.getActivity());
                }
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.canvas.getDisplay().getCursorControl() == this.canvas ? 255 : 150);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Activity, ActivityDetail> map = this.activity_map;
        synchronized (map) {
            this.activity_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        Map<Object, Object> map = this.activity_map;
        synchronized (map) {
            this.activity_map.clear();
        }
        if (this.id != null) {
            map = scale_map;
            synchronized (map) {
                scale_map.put(this.id, this.scale.clone());
            }
        }
    }

    public static interface Activity {
        public static final int TYPE_1 = 1;
        public static final int TYPE_2 = 2;
        public static final int TYPE_3 = 3;
        public static final int TYPE_DEFAULT = 4;

        public String getDescription();

        public int getType();

        public boolean isQueued();

        public State getCurrentState();
    }

    private class ActivityDetail {
        private final long create_time = SystemTime.getMonotonousTime();
        private Activity activity;
        private long complete_time = -1L;
        private int slot = -1;
        private int draw_count = 0;
        private String result_str = "";

        private ActivityDetail(Activity _act) {
            this.activity = _act;
        }

        private long getCreateTime() {
            return this.create_time;
        }

        private Activity getActivity() {
            return this.activity;
        }

        private void setComplete() {
            this.complete_time = SystemTime.getMonotonousTime();
        }

        private long getCompleteTime() {
            return this.complete_time;
        }

        private boolean isComplete() {
            return this.complete_time != -1L && SystemTime.getMonotonousTime() - this.complete_time > 10000L;
        }

        private int getSlot() {
            return this.slot;
        }

        private void setSlot(int _s) {
            this.slot = _s;
        }

        private void draw(GC gc, int x_origin, int y_origin, double slice_angle) {
            boolean dark = Utils.isDarkAppearanceNative();
            ++this.draw_count;
            this.setColour(gc);
            double angle = slice_angle * (double)this.slot;
            State state_maybe_null = this.activity.getCurrentState();
            if (state_maybe_null != null) {
                int depth = state_maybe_null.getDepth();
                int level_depth = 750 / depth;
                Node root = state_maybe_null.getRootNode();
                ArrayList<Object[]> level_nodes = new ArrayList<Object[]>();
                float x_start = (float)(50.0 * Math.sin(angle));
                float y_start = (float)(50.0 * Math.cos(angle));
                level_nodes.add(new Object[]{root, Float.valueOf(x_start), Float.valueOf(y_start)});
                int node_distance = 50;
                while (true) {
                    int nodes_at_next_level = 0;
                    for (Object[] entry : level_nodes) {
                        nodes_at_next_level += ((Node)entry[0]).getChildren().size();
                    }
                    if (nodes_at_next_level == 0) break;
                    node_distance += level_depth;
                    double node_slice_angle = slice_angle / (double)nodes_at_next_level;
                    double current_angle = angle;
                    if (nodes_at_next_level > 1) {
                        current_angle -= slice_angle / 2.0;
                        current_angle += (slice_angle - node_slice_angle * (double)(nodes_at_next_level - 1)) / 2.0;
                    }
                    ArrayList<Object[]> next_level_nodes = new ArrayList<Object[]>();
                    for (Object[] entry : level_nodes) {
                        Node node = (Node)entry[0];
                        float node_x = ((Float)entry[1]).floatValue();
                        float node_y = ((Float)entry[2]).floatValue();
                        int seg_start_x = GeneralOpsPanel.this.scale.getX(node_x, node_y);
                        int seg_start_y = GeneralOpsPanel.this.scale.getY(node_x, node_y);
                        List<Node> kids = node.getChildren();
                        for (Node kid : kids) {
                            float kid_x = (float)((double)node_distance * Math.sin(current_angle));
                            float kid_y = (float)((double)node_distance * Math.cos(current_angle));
                            next_level_nodes.add(new Object[]{kid, Float.valueOf(kid_x), Float.valueOf(kid_y)});
                            current_angle += node_slice_angle;
                            int seg_end_x = GeneralOpsPanel.this.scale.getX(kid_x, kid_y);
                            int seg_end_y = GeneralOpsPanel.this.scale.getY(kid_x, kid_y);
                            gc.drawLine(seg_start_x, seg_start_y, seg_end_x, seg_end_y);
                            gc.drawOval(seg_end_x, seg_end_y, 1, 1);
                            String kid_name = kid.getName();
                            if (kid_name == null) continue;
                            Point extent = gc.textExtent(kid_name);
                            int y_pos = seg_end_y;
                            int x_pos = seg_end_x < x_origin ? seg_end_x - extent.x : seg_end_x;
                            int kid_type = kid.getType();
                            Color fg = null;
                            if (kid_type == 2) {
                                fg = dark ? Colors.grey : Colors.black;
                            } else if (kid_type == 3) {
                                fg = Colors.fadedGreen;
                            }
                            if (fg == null) {
                                gc.drawText(kid_name, x_pos, y_pos);
                            } else {
                                Color old = gc.getForeground();
                                gc.setForeground(fg);
                                gc.drawText(kid_name, x_pos, y_pos);
                                gc.setForeground(old);
                            }
                            Rectangle text_area = new Rectangle(x_pos, y_pos, extent.x, extent.y);
                            GeneralOpsPanel.this.node_text_map.put(kid, text_area);
                        }
                    }
                    level_nodes = next_level_nodes;
                }
            }
            float x_end = (float)(850.0 * Math.sin(angle));
            float y_end = (float)(850.0 * Math.cos(angle));
            int text_x = GeneralOpsPanel.this.scale.getX(x_end, y_end);
            int text_y = GeneralOpsPanel.this.scale.getY(x_end, y_end);
            String desc = this.activity.getDescription();
            if (this.complete_time >= 0L && this.result_str.length() == 0 && state_maybe_null != null) {
                this.result_str = String.valueOf(desc.length() == 0 ? "" : ": ") + state_maybe_null.getResult();
            }
            gc.drawText(String.valueOf(desc) + this.result_str, text_x, text_y);
            gc.setAlpha(255);
        }

        private void setColour(GC gc) {
            boolean dark = Utils.isDarkAppearanceNative();
            if (this.complete_time != -1L && this.draw_count > 1) {
                int age = (int)(SystemTime.getMonotonousTime() - this.complete_time);
                gc.setAlpha(Math.max(0, 200 - 255 * age / 10000));
                gc.setForeground(dark ? Colors.grey : Colors.black);
            } else {
                gc.setAlpha(255);
                int type = this.activity.getType();
                if (type == 1) {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 20, 200, 20));
                } else if (type == 2) {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 140, 160, 40));
                } else if (type == 3) {
                    gc.setForeground(dark ? ColorCache.getColor(gc.getDevice(), 100, 150, 220) : ColorCache.getColor(gc.getDevice(), 20, 20, 220));
                } else {
                    gc.setForeground(ColorCache.getColor(gc.getDevice(), 40, 140, 160));
                }
            }
        }
    }

    public static interface ActivityFilter {
        public boolean accept(Activity var1);
    }

    public static interface Node {
        public static final int TYPE_1 = 1;
        public static final int TYPE_2 = 2;
        public static final int TYPE_3 = 3;

        default public String getName() {
            return null;
        }

        default public int getType() {
            return 1;
        }

        default public Object eventOccurred(NodeEvent ev) {
            return null;
        }

        public List<Node> getChildren();
    }

    public static interface NodeEvent {
        public static final int ET_CLICKED = 1;
        public static final int ET_MENU = 2;

        public int getType();

        public Object getData();
    }

    public static interface State {
        public Node getRootNode();

        public int getDepth();

        public String getResult();
    }
}

