/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeAdapter;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.MultiPlotGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class TagStatsView
extends TagTypeAdapter
implements UISWTViewCoreEventListener,
TagManagerListener,
IViewRequiresPeriodicUpdates {
    public static final String MSGID_PREFIX = "TagStatsView";
    private Composite panel;
    private Group legend_panel;
    private ScrolledComposite legend_panel_sc;
    private Composite speed_panel;
    private UISWTView swtView;
    private MultiPlotGraphic mpg;

    public void periodicUpdate() {
    }

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout(2, false));
        this.legend_panel_sc = new ScrolledComposite(this.panel, 512);
        this.legend_panel_sc.setExpandHorizontal(true);
        this.legend_panel_sc.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.legend_panel_sc.setLayout((Layout)layout);
        GridData gridData = new GridData(1040);
        this.legend_panel_sc.setLayoutData((Object)gridData);
        this.legend_panel = Utils.createSkinnedGroup((Composite)this.legend_panel_sc, 0);
        this.legend_panel.setText(MessageText.getString("label.tags"));
        this.legend_panel.setLayout((Layout)new GridLayout());
        this.legend_panel_sc.setContent((Control)this.legend_panel);
        this.legend_panel_sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TagStatsView.this.legend_panel_sc.setMinSize(TagStatsView.this.legend_panel.computeSize(-1, -1));
            }
        });
        this.speed_panel = new Composite(this.panel, 0);
        this.speed_panel.setLayout((Layout)new GridLayout());
        gridData = new GridData(1808);
        this.speed_panel.setLayoutData((Object)gridData);
        this.build();
        TagManager tm = TagManagerFactory.getTagManager();
        tm.addTagManagerListener(this, false);
        for (TagType tt : tm.getTagTypes()) {
            int tag_type = tt.getTagType();
            if (tag_type == 5 || tag_type == 7) continue;
            tt.addTagTypeListener(this, false);
        }
        this.panel.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                TagStatsView.this.refresh(true);
            }
        });
    }

    private void build() {
        GridData gridData;
        Object history;
        if (this.legend_panel == null || this.legend_panel.isDisposed()) {
            return;
        }
        Control[] controlArray = this.legend_panel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        ArrayList<String> configs = new ArrayList<String>();
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<Color> colors = new ArrayList<Color>();
        TagManager tm = TagManagerFactory.getTagManager();
        List<TagType> tag_types = tm.getTagTypes();
        tag_types = TagUtils.sortTagTypes(tag_types);
        ArrayList<TagFeatureRateLimit> visible_tags = new ArrayList<TagFeatureRateLimit>();
        for (TagType tag_type : tag_types) {
            if (!tag_type.hasTagTypeFeature(1L)) continue;
            List<Tag> tags = tag_type.getTags();
            tags = TagUtils.sortTags(tags);
            for (Tag tag : tags) {
                TagFeatureRateLimit rl;
                if (!tag.isVisible() || !(rl = (TagFeatureRateLimit)((Object)tag)).supportsTagRates()) continue;
                String config_key = "TagStatsView.cc." + tag_type.getTagType() + "." + tag.getTagID();
                configs.add(config_key);
                texts.add(tag.getTagName(true));
                int[] rgb = tag.getColor();
                Color tt_colour = rgb == null ? Colors.blues[9] : ColorCache.getColor((Device)this.legend_panel.getDisplay(), rgb);
                colors.add(tt_colour);
                visible_tags.add(rl);
            }
        }
        Color[] color_array = colors.toArray(new Color[colors.size()]);
        String[] text_array = texts.toArray(new String[texts.size()]);
        final ArrayList<ValueSourceImpl> sources = new ArrayList<ValueSourceImpl>();
        ArrayList<int[]> history_records = new ArrayList<int[]>();
        int history_record_max = 0;
        int i = 0;
        while (i < visible_tags.size()) {
            TagFeatureRateLimit tag = (TagFeatureRateLimit)visible_tags.get(i);
            tag.setRecentHistoryRetention(true);
            history = tag.getRecentHistory();
            history_record_max = Math.max(history[0].length, history_record_max);
            history_records.add(history[0]);
            history_records.add(history[1]);
            sources.add(new ValueSourceImpl(tag, text_array[i], i, color_array, true));
            sources.add(new ValueSourceImpl(tag, text_array[i], i, color_array, false));
            ++i;
        }
        ValueFormater formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(value);
            }
        };
        if (this.mpg != null) {
            this.mpg.dispose();
        }
        final MultiPlotGraphic f_mpg = this.mpg = MultiPlotGraphic.getInstance(sources.toArray(new ValueSource[sources.size()]), formatter);
        history = new int[history_records.size()][];
        int i2 = 0;
        while (i2 < ((int[][])history).length) {
            int[] hist = (int[])history_records.get(i2);
            int hist_len = hist.length;
            if (hist_len == history_record_max) {
                history[i2] = hist;
            } else {
                int[] temp = new int[history_record_max];
                System.arraycopy(hist, 0, temp, history_record_max - hist_len, hist_len);
                history[i2] = temp;
            }
            ++i2;
        }
        this.mpg.reset((int[][])history);
        if (color_array.length > 0) {
            gridData = new GridData(1040);
            gridData.verticalAlignment = 0x1000000;
            Legend.createLegendComposite((Composite)this.legend_panel, color_array, configs.toArray(new String[configs.size()]), text_array, gridData, false, new Legend.LegendListener(){
                private int hover_index = -1;

                @Override
                public void hoverChange(boolean entry, int index) {
                    int i;
                    if (this.hover_index != -1) {
                        i = this.hover_index * 2;
                        while (i < this.hover_index * 2 + 2) {
                            ((ValueSourceImpl)sources.get(i)).setHover(false);
                            ++i;
                        }
                    }
                    if (entry) {
                        this.hover_index = index;
                        i = this.hover_index * 2;
                        while (i < this.hover_index * 2 + 2) {
                            ((ValueSourceImpl)sources.get(i)).setHover(true);
                            ++i;
                        }
                    }
                    f_mpg.refresh(true);
                }

                @Override
                public void visibilityChange(boolean visible, int index) {
                    int i = index * 2;
                    while (i < index * 2 + 2) {
                        ((ValueSourceImpl)sources.get(i)).setVisible(visible);
                        ++i;
                    }
                    f_mpg.refresh(true);
                }
            });
        } else {
            gridData = new GridData(768);
            gridData.verticalAlignment = 128;
            Label lab = new Label((Composite)this.legend_panel, 0);
            lab.setText(MessageText.getString("tag.stats.none.defined"));
            lab.setLayoutData((Object)gridData);
        }
        this.legend_panel_sc.setMinSize(this.legend_panel.computeSize(-1, -1));
        Control[] controlArray2 = this.speed_panel.getChildren();
        int n3 = controlArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Control c = controlArray2[n4];
            c.dispose();
            ++n4;
        }
        Canvas speed_canvas = new Canvas(this.speed_panel, 262144);
        gridData = new GridData(1808);
        speed_canvas.setLayoutData((Object)gridData);
        this.mpg.initialize(speed_canvas, true);
        this.panel.layout(true, true);
    }

    private void rebuild() {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                TagStatsView.this.build();
            }
        });
    }

    private void rebuild(TagType tag_type, boolean added) {
        if (this.panel == null || this.panel.isDisposed()) {
            tag_type.getTagManager().removeTagManagerListener(this);
            return;
        }
        if (added) {
            tag_type.addTagTypeListener(this, false);
        }
        this.rebuild();
    }

    @Override
    public void tagTypeAdded(TagManager manager, TagType tag_type) {
        this.rebuild(tag_type, true);
    }

    @Override
    public void tagTypeRemoved(TagManager manager, TagType tag_type) {
        this.rebuild(tag_type, false);
    }

    private void rebuild(Tag tag) {
        if (this.panel == null || this.panel.isDisposed()) {
            TagType tt = tag.getTagType();
            tt.removeTagTypeListener(this);
            tt.getTagManager().removeTagManagerListener(this);
            return;
        }
        this.rebuild();
    }

    @Override
    public void tagAdded(Tag tag) {
        this.rebuild(tag);
    }

    @Override
    public void tagRemoved(Tag tag) {
        this.rebuild(tag);
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        TagManager tm = TagManagerFactory.getTagManager();
        tm.removeTagManagerListener(this);
        for (TagType tt : tm.getTagTypes()) {
            tt.removeTagTypeListener(this);
        }
        if (this.mpg != null) {
            this.mpg.dispose();
        }
    }

    private void refresh(boolean force) {
        if (this.mpg != null) {
            this.mpg.refresh(force);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(MessageText.getString("TagStatsView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.panel);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.refresh(true);
                break;
            }
            case 5: {
                this.refresh(false);
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }

    private static class ValueSourceImpl
    implements ValueSource {
        TagFeatureRateLimit tag;
        String name;
        int index;
        Color[] colours;
        boolean is_up;
        private boolean is_hover;
        private boolean is_invisible;

        private ValueSourceImpl(TagFeatureRateLimit _tag, String _name, int _index, Color[] _colours, boolean _is_up) {
            this.tag = _tag;
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.is_up = _is_up;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getLineColor() {
            return this.colours[this.index];
        }

        @Override
        public boolean isTrimmable() {
            return false;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        @Override
        public int getAlpha() {
            return 255;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        @Override
        public int getStyle() {
            int style;
            if (this.is_invisible) {
                return 16;
            }
            int n = style = this.is_up ? 1 : 2;
            if (this.is_hover) {
                style |= 8;
            }
            return style;
        }

        @Override
        public int getValue() {
            int rate;
            int n = rate = this.is_up ? this.tag.getTagCurrentUploadRate() : this.tag.getTagCurrentDownloadRate();
            if (rate < 0) {
                rate = 0;
            }
            return rate;
        }
    }
}

