/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.impl.DownloadManagerRateController;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.TransportStartpoint;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.proxy.AEProxySelector;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.speedmanager.LimitToTextHelper;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.speedmanager.SpeedManagerPingMapper;
import com.biglybt.core.speedmanager.SpeedManagerPingSource;
import com.biglybt.core.speedmanager.SpeedManagerPingZone;
import com.biglybt.core.stats.transfer.LongTermStats;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.net.udp.uc.PRUDPPacketHandler;
import com.biglybt.net.udp.uc.PRUDPPacketHandlerFactory;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.MultiPlotGraphic;
import com.biglybt.ui.swt.components.graphics.PingGraphic;
import com.biglybt.ui.swt.components.graphics.Plot3D;
import com.biglybt.ui.swt.components.graphics.Scale;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Widget;

public class TransferStatsView
implements UISWTViewCoreEventListener,
IViewRequiresPeriodicUpdates {
    public static final String MSGID_PREFIX = "TransferStatsView";
    private static final int MAX_DISPLAYED_PING_MILLIS = 1199;
    private static final int MAX_DISPLAYED_PING_MILLIS_DISP = 1200;
    private GlobalManager global_manager;
    private GlobalManagerStats stats;
    private SpeedManager speedManager;
    private OverallStats totalStats;
    private CTabFolder mainPanel;
    private Composite currentPanel;
    private Composite historyPanel;
    private MultiPlotGraphic history_mpg;
    private Composite blahPanel;
    private BufferedLabel asn;
    private BufferedLabel estUpCap;
    private BufferedLabel estDownCap;
    private BufferedLabel uploadBiaser;
    private BufferedLabel currentIP;
    private Composite connectionPanel;
    private BufferedLabel upload_label;
    private BufferedLabel connection_label;
    private SpeedGraphic upload_graphic;
    private SpeedGraphic connection_graphic;
    private CTabFolder con_folder;
    private long last_route_update;
    private Composite route_comp;
    private BufferedLabel[][] route_labels = new BufferedLabel[0][0];
    private Map<String, Long> route_last_seen = new HashMap<String, Long>();
    private Composite generalPanel;
    private BufferedLabel totalLabel;
    private BufferedLabel nowUp;
    private BufferedLabel nowDown;
    private BufferedLabel sessionDown;
    private BufferedLabel sessionUp;
    private BufferedLabel session_ratio;
    private BufferedLabel sessionTime;
    private BufferedLabel totalDown;
    private BufferedLabel totalUp;
    private BufferedLabel total_ratio;
    private BufferedLabel totalTime;
    private Label socksState;
    private BufferedLabel socksCurrent;
    private BufferedLabel socksFails;
    private Label socksMore;
    private Group autoSpeedPanel;
    private StackLayout autoSpeedPanelLayout;
    private Composite autoSpeedInfoPanel;
    private Composite autoSpeedDisabledPanel;
    private PingGraphic pingGraph;
    private plotView[] plot_views;
    private zoneView[] zone_views;
    private LimitToTextHelper limit_to_text = new LimitToTextHelper();
    private final DecimalFormat formatter = new DecimalFormat("##.#");
    private boolean initialised;
    private UISWTView swtView;
    private volatile long history_scale_div = 1L;
    private volatile int history_selected_span_suffix = 4;
    private int SPAN_ALL_TIME;
    private int history_period_offset;
    private Label history_resolution;
    private Label history_span;
    private Label history_total_down;
    private Label history_total_up;
    private long history_last_span;
    private long history_last_period;
    private long history_last_width;
    private int history_last_offset;

    public TransferStatsView() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                TransferStatsView.this.global_manager = core.getGlobalManager();
                TransferStatsView.this.stats = TransferStatsView.this.global_manager.getStats();
                TransferStatsView.this.speedManager = core.getSpeedManager();
                TransferStatsView.this.totalStats = StatsFactory.getStats();
            }
        });
        this.pingGraph = PingGraphic.getInstance();
        this.connection_graphic = SpeedGraphic.getInstance(new Scale(false), new ValueFormater(){

            @Override
            public String format(int value) {
                return String.valueOf(value);
            }
        });
        this.upload_graphic = SpeedGraphic.getInstance(new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc(value);
            }
        });
    }

    private void initialize(Composite composite) {
        this.mainPanel = new CTabFolder(composite, 0x800000);
        GridLayout folderLayout = Utils.getSimpleGridLayout(1);
        this.mainPanel.setLayout((Layout)folderLayout);
        CTabItem currentItem = new CTabItem(this.mainPanel, 0);
        Messages.setLanguageText((Widget)currentItem, "label.current");
        this.currentPanel = new Composite((Composite)this.mainPanel, 0);
        GridLayout currentLayout = Utils.getSimpleGridLayout(1);
        this.currentPanel.setLayout((Layout)currentLayout);
        currentItem.setControl((Control)this.currentPanel);
        CTabItem historyItem = new CTabItem(this.mainPanel, 0);
        Messages.setLanguageText((Widget)historyItem, "label.history");
        this.historyPanel = new Composite((Composite)this.mainPanel, 0);
        GridLayout historyLayout = Utils.getSimpleGridLayout(1);
        this.historyPanel.setLayout((Layout)historyLayout);
        historyItem.setControl((Control)this.historyPanel);
        int selected = COConfigurationManager.getIntParameter("tsv:tabfolder.sel", 0);
        this.mainPanel.setSelection(selected);
        this.mainPanel.addListener(13, ev -> COConfigurationManager.setParameter("tsv:tabfolder.sel", this.mainPanel.getSelectionIndex()));
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (TransferStatsView.this.mainPanel == null || TransferStatsView.this.mainPanel.isDisposed()) {
                            return;
                        }
                        TransferStatsView.this.createGeneralPanel();
                        TransferStatsView.this.createConnectionPanel();
                        TransferStatsView.this.createCapacityPanel();
                        TransferStatsView.this.createAutoSpeedPanel();
                        TransferStatsView.this.createHistoryPanel();
                        TransferStatsView.this.initialised = true;
                    }
                });
            }
        });
    }

    private void createGeneralPanel() {
        this.generalPanel = new Composite(this.currentPanel, 0);
        GridLayout outerLayout = Utils.getSimpleGridLayout(2);
        this.generalPanel.setLayout((Layout)outerLayout);
        GridData gridData = new GridData(768);
        this.generalPanel.setLayoutData((Object)gridData);
        GridData generalStatsPanelGridData = new GridData(768);
        generalStatsPanelGridData.grabExcessHorizontalSpace = true;
        Composite generalStatsPanel = Utils.createSkinnedComposite(this.generalPanel, 2048, generalStatsPanelGridData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 5;
        panelLayout.makeColumnsEqualWidth = false;
        generalStatsPanel.setLayout((Layout)panelLayout);
        Label lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.ratio");
        lbl = new Label(generalStatsPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Label nowLabel = new Label(generalStatsPanel, 0);
        gridData = new GridData(768);
        nowLabel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)nowLabel, "SpeedView.stats.now");
        this.nowDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.nowDown.setLayoutData(gridData);
        this.nowUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.nowUp.setLayoutData(gridData);
        lbl = new Label(generalStatsPanel, 0);
        lbl = new Label(generalStatsPanel, 0);
        Label sessionLabel = new Label(generalStatsPanel, 0);
        gridData = new GridData(768);
        sessionLabel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)sessionLabel, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.session_ratio = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.session_ratio.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        this.totalLabel = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalLabel.setLayoutData(gridData);
        Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.total_ratio = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.total_ratio.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(generalStatsPanel, 0x20000000);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
        Object[] objectArray = new Object[]{nowLabel, sessionLabel, this.totalLabel};
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Object control = obj instanceof BufferedLabel ? ((BufferedLabel)obj).getControl() : (Label)obj;
            Menu menu = new Menu((Decorations)control.getShell(), 8);
            control.setMenu(menu);
            MenuItem item = new MenuItem(menu, 0);
            Messages.setLanguageText((Widget)item, "MainWindow.menu.view.configuration");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getMDI().showEntryByID("ConfigView", "Stats");
                    }
                }
            });
            ++n2;
        }
        GridData generalSocksPanelGridData = new GridData();
        generalSocksPanelGridData.horizontalIndent = 2;
        Composite[] generalSocksPanels = Utils.createSkinnedCompositeEx(this.generalPanel, 2048, generalSocksPanelGridData);
        Composite generalSocksPanel = generalSocksPanels[1];
        GridLayout socksLayout = new GridLayout();
        socksLayout.numColumns = 2;
        generalSocksPanel.setLayout((Layout)socksLayout);
        lbl = new Label(generalSocksPanel, 0);
        Messages.setLanguageText((Widget)lbl, "label.socks");
        lbl = new Label(generalSocksPanel, 0);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(String.valueOf(MessageText.getString("label.proxy")) + ":");
        this.socksState = new Label(generalSocksPanel, 0);
        gridData = new GridData(768);
        gridData.widthHint = 120;
        this.socksState.setLayoutData((Object)gridData);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(String.valueOf(MessageText.getString("PeersView.state")) + ":");
        this.socksCurrent = new BufferedLabel(generalSocksPanel, 0x20000000);
        gridData = new GridData(768);
        this.socksCurrent.setLayoutData(gridData);
        lbl = new Label(generalSocksPanel, 0);
        lbl.setText(String.valueOf(MessageText.getString("label.fails")) + ":");
        this.socksFails = new BufferedLabel(generalSocksPanel, 0x20000000);
        gridData = new GridData(768);
        this.socksFails.setLayoutData(gridData);
        lbl = new Label(generalSocksPanel, 0);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 3;
        this.socksMore = new Label(generalSocksPanel, 0);
        this.socksMore.setText(String.valueOf(MessageText.getString("label.more")) + "...");
        this.socksMore.setLayoutData((Object)gridData);
        this.socksMore.setCursor(this.socksMore.getDisplay().getSystemCursor(21));
        Utils.setLinkForeground((Control)this.socksMore);
        this.socksMore.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TransferStatsView.this.showSOCKSInfo();
            }

            public void mouseUp(MouseEvent arg0) {
                TransferStatsView.this.showSOCKSInfo();
            }
        });
        Point socks_size = generalSocksPanels[0].computeSize(-1, -1);
        Rectangle trim = generalSocksPanels[0].computeTrim(0, 0, socks_size.x, socks_size.y);
        generalStatsPanelGridData.heightHint = socks_size.y - (trim.height - socks_size.y);
    }

    private void showSOCKSInfo() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        String info = proxy_selector.getInfo();
        TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("proxy.info.title"), null, info, false);
    }

    private void createCapacityPanel() {
        this.blahPanel = new Composite(this.currentPanel, 0);
        GridData blahPanelData = new GridData(768);
        this.blahPanel.setLayoutData((Object)blahPanelData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 8;
        this.blahPanel.setLayout((Layout)panelLayout);
        Label label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.asn");
        this.asn = new BufferedLabel(this.blahPanel, 0x20000000);
        GridData gridData = new GridData(768);
        this.asn.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "label.current_ip");
        this.currentIP = new BufferedLabel(this.blahPanel, 0x20000000);
        gridData = new GridData(768);
        this.currentIP.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estupcap");
        this.estUpCap = new BufferedLabel(this.blahPanel, 0x20000000);
        gridData = new GridData(768);
        this.estUpCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estdowncap");
        this.estDownCap = new BufferedLabel(this.blahPanel, 0x20000000);
        gridData = new GridData(768);
        this.estDownCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.upbias");
        this.uploadBiaser = new BufferedLabel(this.blahPanel, 0x20000000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 7;
        this.uploadBiaser.setLayoutData(gridData);
    }

    private void createConnectionPanel() {
        boolean dark = Utils.isDarkAppearanceNative();
        Composite connectionHeader = new Composite(this.currentPanel, 0);
        GridData gridData = new GridData(768);
        connectionHeader.setLayoutData((Object)gridData);
        GridLayout chLayout = Utils.getSimpleGridLayout(4);
        chLayout.makeColumnsEqualWidth = true;
        connectionHeader.setLayout((Layout)chLayout);
        this.connectionPanel = new Composite(this.currentPanel, 0);
        gridData = new GridData(768);
        this.connectionPanel.setLayoutData((Object)gridData);
        GridLayout panelLayout = Utils.getSimpleGridLayout(2);
        panelLayout.makeColumnsEqualWidth = true;
        this.connectionPanel.setLayout((Layout)panelLayout);
        Composite conn_area = new Composite(connectionHeader, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        conn_area.setLayoutData((Object)gridData);
        panelLayout = Utils.getSimpleGridLayout(2);
        panelLayout.numColumns = 2;
        conn_area.setLayout((Layout)panelLayout);
        Label label = new Label(conn_area, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.con");
        this.connection_label = new BufferedLabel(conn_area, 0x20000000);
        gridData = new GridData(768);
        this.connection_label.setLayoutData(gridData);
        Composite upload_area = new Composite(connectionHeader, 0);
        gridData = new GridData(768);
        upload_area.setLayoutData((Object)gridData);
        panelLayout = Utils.getSimpleGridLayout(2);
        upload_area.setLayout((Layout)panelLayout);
        label = new Label(upload_area, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.upload");
        this.upload_label = new BufferedLabel(upload_area, 0x20000000);
        gridData = new GridData(768);
        this.upload_label.setLayoutData(gridData);
        this.con_folder = new CTabFolder(this.connectionPanel, 0x800000);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.con_folder.setLayoutData((Object)gridData);
        CTabItem conn_item = new CTabItem(this.con_folder, 0);
        conn_item.setText(MessageText.getString("label.connections"));
        Canvas connection_canvas = new Canvas((Composite)this.con_folder, 262144);
        conn_item.setControl((Control)connection_canvas);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        connection_canvas.setLayoutData((Object)gridData);
        this.connection_graphic.initialize(connection_canvas);
        Color[] colors = this.connection_graphic.colors;
        this.connection_graphic.setLineColors(colors);
        CTabItem route_info_tab = new CTabItem(this.con_folder, 0);
        route_info_tab.setText(MessageText.getString("label.routing"));
        Composite route_tab_comp = new Composite((Composite)this.con_folder, dark ? 2048 : 0);
        route_tab_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout routeTabLayout = Utils.getSimpleGridLayout(1);
        route_tab_comp.setLayout((Layout)routeTabLayout);
        route_info_tab.setControl((Control)route_tab_comp);
        ScrolledComposite sc = new ScrolledComposite(route_tab_comp, 512);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.con_folder.setSelection(0);
        this.route_comp = new Composite((Composite)sc, 0);
        if (!dark) {
            this.route_comp.setBackground(Colors.white);
            sc.setBackground(Colors.white);
        }
        this.route_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout routeLayout = Utils.getSimpleGridLayout(3);
        this.route_comp.setLayout((Layout)routeLayout);
        sc.setContent((Control)this.route_comp);
        this.buildRouteComponent(5);
        Canvas upload_canvas = new Canvas(this.connectionPanel, 262144);
        gridData = new GridData(1808);
        gridData.horizontalIndent = 4;
        gridData.heightHint = 200;
        upload_canvas.setLayoutData((Object)gridData);
        this.upload_graphic.initialize(upload_canvas);
    }

    private void buildRouteComponent(int rows) {
        int i;
        boolean force;
        boolean changed = false;
        boolean bl = force = this.route_labels.length > 0 && this.route_labels[0][0].isDisposed();
        if (rows <= this.route_labels.length && !force) {
            int i2 = rows;
            while (i2 < this.route_labels.length) {
                int j = 0;
                while (j < 3) {
                    this.route_labels[i2][j].setText("");
                    ++j;
                }
                ++i2;
            }
        } else {
            Control[] labels = this.route_comp.getChildren();
            i = 0;
            while (i < labels.length) {
                labels[i].dispose();
                ++i;
            }
            boolean dark = Utils.isDarkAppearanceNative();
            Label h1 = new Label(this.route_comp, 0);
            h1.setLayoutData((Object)new GridData(768));
            h1.setText(MessageText.getString("label.route"));
            if (!dark) {
                h1.setForeground(Colors.black);
                h1.setBackground(Colors.white);
            }
            Label h2 = new Label(this.route_comp, 0);
            h2.setLayoutData((Object)new GridData(768));
            h2.setText(MessageText.getString("tps.type.incoming"));
            if (!dark) {
                h2.setForeground(Colors.black);
                h2.setBackground(Colors.white);
            }
            Label h3 = new Label(this.route_comp, 0);
            h3.setLayoutData((Object)new GridData(768));
            h3.setText(MessageText.getString("label.outgoing"));
            if (!dark) {
                h3.setForeground(Colors.black);
                h3.setBackground(Colors.white);
            }
            new Label(this.route_comp, 0);
            new Label(this.route_comp, 0);
            new Label(this.route_comp, 0);
            this.route_labels = new BufferedLabel[rows][3];
            int i3 = 0;
            while (i3 < rows) {
                int j = 0;
                while (j < 3) {
                    BufferedLabel l = new BufferedLabel(this.route_comp, 0x20000000);
                    GridData gridData = new GridData(768);
                    l.setLayoutData(gridData);
                    if (!dark) {
                        l.getControl().setBackground(Colors.white);
                        l.getControl().setForeground(Colors.black);
                    }
                    this.route_labels[i3][j] = l;
                    ++j;
                }
                ++i3;
            }
            changed = true;
        }
        Point size = this.route_comp.computeSize(this.route_comp.getParent().getSize().x, -1);
        changed = changed || !this.route_comp.getSize().equals((Object)size);
        this.route_comp.setSize(size);
        if (!changed) {
            i = 0;
            while (i < this.route_labels.length) {
                int j = 0;
                while (j < 3) {
                    BufferedLabel lab = this.route_labels[i][j];
                    if (!lab.isDisposed() && lab.getControl().getSize().y == 0 && lab.getText().length() > 0) {
                        changed = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (changed) {
            this.route_comp.getParent().layout(true, true);
        }
        this.route_comp.update();
    }

    private void createAutoSpeedPanel() {
        this.autoSpeedPanel = Utils.createSkinnedGroup(this.currentPanel, 0);
        GridData generalPanelData = new GridData(1808);
        this.autoSpeedPanel.setLayoutData((Object)generalPanelData);
        Messages.setLanguageText((Widget)this.autoSpeedPanel, "SpeedView.stats.autospeed", String.valueOf(1200));
        this.autoSpeedPanelLayout = new StackLayout();
        this.autoSpeedPanelLayout.marginWidth = 0;
        this.autoSpeedPanelLayout.marginHeight = 0;
        this.autoSpeedPanel.setLayout((Layout)this.autoSpeedPanelLayout);
        this.autoSpeedInfoPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedInfoPanel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = Utils.getSimpleGridLayout(8);
        layout.makeColumnsEqualWidth = true;
        this.autoSpeedInfoPanel.setLayout((Layout)layout);
        Canvas pingCanvas = new Canvas(this.autoSpeedInfoPanel, 262144);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        pingCanvas.setLayoutData((Object)gridData);
        this.pingGraph.initialize(pingCanvas);
        CTabFolder folder = new CTabFolder(this.autoSpeedInfoPanel, 0x800000);
        gridData = new GridData(1808);
        gridData.horizontalIndent = 4;
        gridData.horizontalSpan = 4;
        folder.setLayoutData((Object)gridData);
        ValueFormater speed_formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc(value);
            }
        };
        ValueFormater time_formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return String.valueOf(value) + TimeFormatter.MS_SUFFIX;
            }
        };
        ValueFormater[] formatters = new ValueFormater[]{speed_formatter, speed_formatter, time_formatter};
        String[] labels = new String[]{"up", "down", "ping"};
        SpeedManagerPingMapper[] mappers = this.speedManager.getMappers();
        this.plot_views = new plotView[mappers.length];
        this.zone_views = new zoneView[mappers.length];
        int i = 0;
        while (i < mappers.length) {
            SpeedManagerPingMapper mapper = mappers[i];
            CTabItem plot_item = new CTabItem(folder, 0);
            plot_item.setText("Plot " + mapper.getName());
            Canvas plotCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            plotCanvas.setLayoutData((Object)gridData);
            this.plot_views[i] = new plotView(mapper, plotCanvas, labels, formatters);
            plot_item.setControl((Control)plotCanvas);
            CTabItem zones_item = new CTabItem(folder, 0);
            zones_item.setText("Zones " + mapper.getName());
            Canvas zoneCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            zoneCanvas.setLayoutData((Object)gridData);
            this.zone_views[i] = new zoneView(mapper, zoneCanvas, labels, formatters);
            zones_item.setControl((Control)zoneCanvas);
            ++i;
        }
        folder.setSelection(0);
        this.autoSpeedDisabledPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedDisabledPanel.setLayout((Layout)new GridLayout());
        Label disabled = new Label(this.autoSpeedDisabledPanel, 0);
        disabled.setEnabled(false);
        Messages.setLanguageText((Widget)disabled, "SpeedView.stats.autospeed.disabled");
        disabled.setLayoutData((Object)new GridData(832));
        this.autoSpeedPanelLayout.topControl = this.speedManager.isAvailable() ? this.autoSpeedInfoPanel : this.autoSpeedDisabledPanel;
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        Legend.createLegendComposite(this.autoSpeedInfoPanel, PingGraphic.defaultColors, new String[]{"TransferStatsView.legend.pingaverage", "TransferStatsView.legend.ping1", "TransferStatsView.legend.ping2", "TransferStatsView.legend.ping3"}, gridData);
    }

    private void delete() {
        int i;
        Utils.disposeComposite(this.generalPanel);
        Utils.disposeComposite(this.blahPanel);
        if (this.upload_graphic != null) {
            this.upload_graphic.dispose();
        }
        if (this.connection_graphic != null) {
            this.connection_graphic.dispose();
        }
        if (this.pingGraph != null) {
            this.pingGraph.dispose();
        }
        if (this.plot_views != null) {
            i = 0;
            while (i < this.plot_views.length) {
                this.plot_views[i].dispose();
                ++i;
            }
        }
        if (this.zone_views != null) {
            i = 0;
            while (i < this.zone_views.length) {
                this.zone_views[i].dispose();
                ++i;
            }
        }
    }

    private Composite getComposite() {
        return this.mainPanel;
    }

    private void refresh() {
        if (!this.initialised || this.mainPanel == null || this.mainPanel.isDisposed()) {
            return;
        }
        this.refreshGeneral();
        this.refreshCapacityPanel();
        this.refreshConnectionPanel();
        this.refreshPingPanel();
        this.refreshHistory();
    }

    private void refreshGeneral() {
        AEProxySelector proxy_selector;
        Proxy proxy;
        if (this.stats == null) {
            return;
        }
        int now_prot_down_rate = this.stats.getProtocolReceiveRate();
        int now_prot_up_rate = this.stats.getProtocolSendRate();
        int now_total_down_rate = this.stats.getDataReceiveRate() + now_prot_down_rate;
        int now_total_up_rate = this.stats.getDataSendRate() + now_prot_up_rate;
        float now_perc_down = (float)(now_prot_down_rate * 100) / (float)(now_total_down_rate == 0 ? 1 : now_total_down_rate);
        float now_perc_up = (float)(now_prot_up_rate * 100) / (float)(now_total_up_rate == 0 ? 1 : now_total_up_rate);
        this.nowDown.setText(String.valueOf(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_down_rate)) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_down_rate) + ", " + this.formatter.format(now_perc_down) + "%)");
        this.nowUp.setText(String.valueOf(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_up_rate)) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_up_rate) + ", " + this.formatter.format(now_perc_up) + "%)");
        long session_prot_received = this.stats.getTotalProtocolBytesReceived();
        long session_prot_sent = this.stats.getTotalProtocolBytesSent();
        long session_total_received = this.stats.getTotalDataBytesReceived() + session_prot_received;
        long session_total_sent = this.stats.getTotalDataBytesSent() + session_prot_sent;
        float session_perc_received = (float)(session_prot_received * 100L) / (float)(session_total_received == 0L ? 1L : session_total_received);
        float session_perc_sent = (float)(session_prot_sent * 100L) / (float)(session_total_sent == 0L ? 1L : session_total_sent);
        this.sessionDown.setText(String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(session_total_received)) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_received) + ", " + this.formatter.format(session_perc_received) + "%)");
        this.sessionUp.setText(String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(session_total_sent)) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_sent) + ", " + this.formatter.format(session_perc_sent) + "%)");
        if (this.totalStats != null) {
            long mark = this.totalStats.getMarkTime();
            if (mark > 0L) {
                Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total.since", new SimpleDateFormat().format(new Date(mark)));
            } else {
                Messages.setLanguageText(this.totalLabel.getWidget(), "SpeedView.stats.total");
            }
            long dl_bytes = this.totalStats.getDownloadedBytes(true);
            long ul_bytes = this.totalStats.getUploadedBytes(true);
            this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(dl_bytes));
            this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(ul_bytes));
            long session_up_time = this.totalStats.getSessionUpTime();
            long total_up_time = this.totalStats.getTotalUpTime(true);
            this.sessionTime.setText(session_up_time == 0L ? "" : DisplayFormatters.formatETA(session_up_time));
            this.totalTime.setText(total_up_time == 0L ? "" : DisplayFormatters.formatETA(total_up_time));
            long t_ratio_raw = 1000L * ul_bytes / (dl_bytes == 0L ? 1L : dl_bytes);
            long s_ratio_raw = 1000L * session_total_sent / (session_total_received == 0L ? 1L : session_total_received);
            String t_ratio = "";
            String s_ratio = "";
            String partial = String.valueOf(t_ratio_raw % 1000L);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            t_ratio = String.valueOf(t_ratio_raw / 1000L) + "." + partial;
            partial = String.valueOf(s_ratio_raw % 1000L);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            s_ratio = String.valueOf(s_ratio_raw / 1000L) + "." + partial;
            this.total_ratio.setText(t_ratio);
            this.session_ratio.setText(s_ratio);
        }
        this.socksMore.setEnabled((proxy = (proxy_selector = AEProxySelectorFactory.getSelector()).getActiveProxy()) != null);
        if (Constants.isOSX) {
            this.socksMore.setForeground(proxy == null ? Colors.light_grey : Colors.blue);
        }
        this.socksState.setText(proxy == null ? MessageText.getString("label.inactive") : ((InetSocketAddress)proxy.address()).getHostName());
        if (proxy == null) {
            this.socksCurrent.setText("");
            this.socksFails.setText("");
        } else {
            long last_con = proxy_selector.getLastConnectionTime();
            long last_fail = proxy_selector.getLastFailTime();
            int total_cons = proxy_selector.getConnectionCount();
            int total_fails = proxy_selector.getFailCount();
            long now = SystemTime.getMonotonousTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            String state_str = last_fail < 0L ? "PeerManager.status.ok" : (fail_ago > 60000L ? (con_ago < fail_ago ? "PeerManager.status.ok" : "SpeedView.stats.unknown") : "ManagerItem.error");
            this.socksCurrent.setText(String.valueOf(MessageText.getString(state_str)) + ", con=" + total_cons);
            long fail_ago_secs = fail_ago / 1000L;
            if (fail_ago_secs == 0L) {
                fail_ago_secs = 1L;
            }
            this.socksFails.setText(last_fail < 0L ? "" : String.valueOf(DisplayFormatters.formatETA(fail_ago_secs, false)) + " " + MessageText.getString("label.ago") + ", tot=" + total_fails);
        }
    }

    private void refreshCapacityPanel() {
        if (this.speedManager == null) {
            return;
        }
        this.asn.setTextAndTooltip(this.speedManager.getASN());
        this.estUpCap.setTextAndTooltip(this.limit_to_text.getLimitText(this.speedManager.getEstimatedUploadCapacityBytesPerSec()));
        this.estDownCap.setTextAndTooltip(this.limit_to_text.getLimitText(this.speedManager.getEstimatedDownloadCapacityBytesPerSec()));
        this.uploadBiaser.setTextAndTooltip(DownloadManagerRateController.getString());
        NetworkAdmin na = NetworkAdmin.getSingleton();
        InetAddress current_ip = na.getDefaultPublicAddress(true);
        InetAddress current_ip6 = na.getDefaultPublicAddressV6();
        String str = "";
        if (current_ip != null) {
            str = String.valueOf(str) + current_ip.getHostAddress();
        }
        if (!(current_ip6 == null || current_ip != null && current_ip6.equals(current_ip))) {
            str = String.valueOf(str) + (str.isEmpty() ? "" : "/") + current_ip6.getHostAddress();
        }
        this.currentIP.setTextAndTooltip(str);
    }

    private void refreshConnectionPanel() {
        long now;
        if (this.global_manager == null) {
            return;
        }
        int total_connections = 0;
        int total_con_queued = 0;
        int total_con_blocked = 0;
        int total_con_unchoked = 0;
        int total_data_queued = 0;
        int total_in = 0;
        List<DownloadManager> dms = this.global_manager.getDownloadManagers();
        for (DownloadManager dm : dms) {
            PEPeerManager pm = dm.getPeerManager();
            if (pm == null) continue;
            total_data_queued += pm.getBytesQueuedForUpload();
            total_connections += pm.getNbPeers() + pm.getNbSeeds();
            total_con_queued += pm.getNbPeersWithUploadQueued();
            total_con_blocked += pm.getNbPeersWithUploadBlocked();
            total_con_unchoked += pm.getNbPeersUnchoked();
            total_in += pm.getNbRemoteTCPConnections() + pm.getNbRemoteUDPConnections() + pm.getNbRemoteUTPConnections();
        }
        this.connection_label.setText(MessageText.getString("SpeedView.stats.con_details", new String[]{String.valueOf(String.valueOf(total_connections)) + "[" + MessageText.getString("label.in").toLowerCase() + ":" + total_in + "]", String.valueOf(total_con_unchoked), String.valueOf(total_con_queued), String.valueOf(total_con_blocked)}));
        this.upload_label.setText(MessageText.getString("SpeedView.stats.upload_details", new String[]{DisplayFormatters.formatByteCountToKiBEtc(total_data_queued)}));
        this.upload_graphic.refresh(false);
        this.connection_graphic.refresh(false);
        if (this.con_folder.getSelectionIndex() == 1 && (now = SystemTime.getMonotonousTime()) - this.last_route_update >= 2000L) {
            this.last_route_update = now;
            NetworkAdmin na = NetworkAdmin.getSingleton();
            HashMap<InetAddress, String> ip_to_name_map = new HashMap<InetAddress, String>();
            HashMap<String, RouteInfo> name_to_route_map = new HashMap<String, RouteInfo>();
            RouteInfo udp_info = null;
            RouteInfo unknown_info = null;
            List<PRUDPPacketHandler> udp_handlers = PRUDPPacketHandlerFactory.getHandlers();
            InetAddress udp_bind_ip = null;
            for (PRUDPPacketHandler handler : udp_handlers) {
                if (!handler.hasPrimordialHandler() || (udp_bind_ip = handler.getBindIP()) == null || !udp_bind_ip.isAnyLocalAddress()) continue;
                udp_bind_ip = null;
            }
            for (DownloadManager dm : dms) {
                PEPeerManager pm = dm.getPeerManager();
                if (pm == null) continue;
                List<PEPeer> peers = pm.getPeers();
                for (PEPeer p : peers) {
                    Transport transport;
                    NetworkConnection nc = PluginCoreUtils.unwrap(p.getPluginConnection());
                    boolean done = false;
                    if (nc != null && (transport = nc.getTransport()) != null) {
                        RouteInfo info;
                        InetSocketAddress notional_address = nc.getEndpoint().getNotionalAddress();
                        String ip = AddressUtils.getHostAddress(notional_address);
                        String network = AENetworkClassifier.categoriseAddress(ip);
                        if (network == "Public") {
                            if (transport.isTCP()) {
                                InetSocketAddress socket_address;
                                TransportStartpoint start = transport.getTransportStartpoint();
                                if (start != null && (socket_address = start.getProtocolStartpoint().getAddress()) != null) {
                                    RouteInfo info2;
                                    InetAddress address = socket_address.getAddress();
                                    String name = address.isAnyLocalAddress() ? "* (TCP)" : (String)ip_to_name_map.get(address);
                                    if (name == null) {
                                        name = na.classifyRoute(address);
                                        ip_to_name_map.put(address, name);
                                    }
                                    if (transport.isSOCKS()) {
                                        name = String.valueOf(name) + " (SOCKS)";
                                    }
                                    if ((info2 = (RouteInfo)name_to_route_map.get(name)) == null) {
                                        info2 = new RouteInfo(name);
                                        name_to_route_map.put(name, info2);
                                        this.route_last_seen.put(name, now);
                                    }
                                    info2.update(p);
                                    done = true;
                                }
                            } else if (udp_bind_ip != null) {
                                String name = (String)ip_to_name_map.get(udp_bind_ip);
                                if (name == null) {
                                    name = na.classifyRoute(udp_bind_ip);
                                    ip_to_name_map.put(udp_bind_ip, name);
                                    info = (RouteInfo)name_to_route_map.get(name);
                                    this.route_last_seen.put(name, now);
                                    if (info == null) {
                                        info = new RouteInfo(name);
                                        name_to_route_map.put(name, info);
                                    }
                                } else {
                                    info = (RouteInfo)name_to_route_map.get(name);
                                }
                                info.update(p);
                                done = true;
                            } else {
                                if (udp_info == null) {
                                    udp_info = new RouteInfo("* (UDP)");
                                    name_to_route_map.put(udp_info.getName(), udp_info);
                                    this.route_last_seen.put(udp_info.getName(), now);
                                }
                                udp_info.update(p);
                                done = true;
                            }
                        } else {
                            info = (RouteInfo)name_to_route_map.get(network);
                            if (info == null) {
                                info = new RouteInfo(network);
                                name_to_route_map.put(network, info);
                                this.route_last_seen.put(network, now);
                            }
                            info.update(p);
                            done = true;
                        }
                    }
                    if (done) continue;
                    if (unknown_info == null) {
                        unknown_info = new RouteInfo("Pending");
                        name_to_route_map.put(unknown_info.getName(), unknown_info);
                        this.route_last_seen.put(unknown_info.getName(), now);
                    }
                    unknown_info.update(p);
                }
            }
            ArrayList<RouteInfo> rows = new ArrayList<RouteInfo>();
            Iterator<Map.Entry<String, Long>> it = this.route_last_seen.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                long when = entry.getValue();
                if (now - when > 60000L) {
                    it.remove();
                    continue;
                }
                if (when == now) continue;
                rows.add(new RouteInfo(entry.getKey()));
            }
            rows.addAll(name_to_route_map.values());
            Collections.sort(rows, new Comparator<RouteInfo>(){

                @Override
                public int compare(RouteInfo o1, RouteInfo o2) {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    if (n1.startsWith("*") || n1.equals("Pending")) {
                        n1 = "zzzz" + n1;
                    }
                    if (n2.startsWith("*") || n2.equals("Pending")) {
                        n2 = "zzzz" + n2;
                    }
                    return n1.compareTo(n2);
                }
            });
            this.buildRouteComponent(rows.size());
            int i = 0;
            while (i < rows.size()) {
                RouteInfo info = (RouteInfo)rows.get(i);
                this.route_labels[i][0].setText(info.getName());
                this.route_labels[i][1].setText(info.getIncomingString());
                this.route_labels[i][2].setText(info.getOutgoingString());
                ++i;
            }
            this.buildRouteComponent(rows.size());
        }
    }

    private void refreshPingPanel() {
        if (this.speedManager == null) {
            return;
        }
        if (this.speedManager.isAvailable()) {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedInfoPanel;
            this.autoSpeedPanel.layout();
            this.pingGraph.refresh();
            int i = 0;
            while (i < this.plot_views.length) {
                this.plot_views[i].refresh();
                ++i;
            }
            i = 0;
            while (i < this.zone_views.length) {
                this.zone_views[i].refresh(false);
                ++i;
            }
        } else {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedDisabledPanel;
            this.autoSpeedPanel.layout();
        }
    }

    public void periodicUpdate() {
        SpeedManagerPingSource[] sources;
        if (this.speedManager == null) {
            return;
        }
        if (this.speedManager.isAvailable() && (sources = this.speedManager.getPingSources()).length > 0) {
            Object[] objectArray;
            int ping;
            int[] pings = new int[sources.length];
            int i = 0;
            while (i < sources.length) {
                SpeedManagerPingSource source = sources[i];
                if (source != null) {
                    ping = source.getPingTime();
                    pings[i] = ping = Math.min(ping, 1199);
                }
                ++i;
            }
            this.pingGraph.addIntsValue(pings);
            if (this.plot_views != null) {
                objectArray = this.plot_views;
                ping = this.plot_views.length;
                int source = 0;
                while (source < ping) {
                    Object view = objectArray[source];
                    if (view != null) {
                        ((plotView)view).update();
                    }
                    ++source;
                }
            }
            if (this.zone_views != null) {
                objectArray = this.zone_views;
                ping = this.zone_views.length;
                int source = 0;
                while (source < ping) {
                    Object view = objectArray[source];
                    if (view != null) {
                        ((zoneView)view).update();
                    }
                    ++source;
                }
            }
        }
        if (this.upload_graphic != null && this.connection_graphic != null) {
            int total_data_queued = 0;
            int total_connections = 0;
            int total_con_queued = 0;
            int total_con_blocked = 0;
            int total_con_unchoked = 0;
            List<DownloadManager> dms = this.global_manager.getDownloadManagers();
            for (DownloadManager dm : dms) {
                PEPeerManager pm = dm.getPeerManager();
                if (pm == null) continue;
                total_data_queued += pm.getBytesQueuedForUpload();
                total_connections += pm.getNbPeers() + pm.getNbSeeds();
                total_con_queued += pm.getNbPeersWithUploadQueued();
                total_con_blocked += pm.getNbPeersWithUploadBlocked();
                total_con_unchoked += pm.getNbPeersUnchoked();
            }
            this.upload_graphic.addIntValue(total_data_queued);
            this.connection_graphic.addIntsValue(new int[]{total_connections, total_con_unchoked, total_con_queued, total_con_blocked});
        }
    }

    protected String getMapperTitle(SpeedManagerPingMapper mapper) {
        if (mapper.isActive()) {
            SpeedManagerLimitEstimate up_1 = mapper.getEstimatedUploadLimit(false);
            SpeedManagerLimitEstimate up_2 = mapper.getEstimatedUploadLimit(true);
            SpeedManagerLimitEstimate down_1 = mapper.getEstimatedDownloadLimit(false);
            SpeedManagerLimitEstimate down_2 = mapper.getEstimatedDownloadLimit(true);
            return "ul=" + DisplayFormatters.formatByteCountToKiBEtc(up_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(up_2.getBytesPerSec()) + ",dl=" + DisplayFormatters.formatByteCountToKiBEtc(down_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(down_2.getBytesPerSec()) + ",mr=" + DisplayFormatters.formatDecimal(mapper.getCurrentMetricRating(), 2);
        }
        return "";
    }

    private void createHistoryPanel() {
        Composite controlPanel = new Composite(this.historyPanel, 0);
        GridData gd = new GridData(768);
        controlPanel.setLayoutData((Object)gd);
        controlPanel.setLayout((Layout)new GridLayout(12, false));
        Combo combo = new Combo(controlPanel, 12);
        int i = 2;
        while (i <= 6) {
            String str = TimeFormatter.TIME_SUFFIXES_2_LONG[i];
            if (str.length() > 1) {
                str = String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
            }
            combo.add(str);
            ++i;
        }
        combo.add(MessageText.getString("Categories.all"));
        this.SPAN_ALL_TIME = 7;
        combo.select(this.history_selected_span_suffix - 2);
        ImageLoader loader = ImageLoader.getInstance();
        Button prev = new Button(controlPanel, 8);
        prev.setImage(loader.getImage("back"));
        Button next = new Button(controlPanel, 8);
        next.setImage(loader.getImage("forward"));
        next.setEnabled(false);
        prev.addListener(13, ev -> {
            --this.history_period_offset;
            next.setEnabled(true);
            this.refreshHistory();
        });
        next.addListener(13, ev -> {
            ++this.history_period_offset;
            if (this.history_period_offset == 0) {
                next.setEnabled(false);
            }
            this.refreshHistory();
        });
        combo.addListener(13, ev -> {
            int index = combo.getSelectionIndex();
            this.history_selected_span_suffix = 2 + index;
            this.history_period_offset = 0;
            prev.setEnabled(this.history_selected_span_suffix != this.SPAN_ALL_TIME);
            next.setEnabled(false);
            this.refreshHistory();
        });
        Label lbl_res = new Label(controlPanel, 0);
        lbl_res.setText(String.valueOf(MessageText.getString("label.time.resolution")) + ":");
        this.history_resolution = new Label(controlPanel, 0);
        this.history_span = new Label(controlPanel, 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.history_span.setLayoutData((Object)gd);
        Label lbl_spacer1 = new Label(controlPanel, 0);
        lbl_spacer1.setLayoutData((Object)new GridData(768));
        Label lbl_spacer2 = new Label(controlPanel, 0);
        lbl_spacer2.setLayoutData((Object)new GridData(768));
        Label lbl_down = new Label(controlPanel, 0);
        lbl_down.setText(String.valueOf(MessageText.getString("TableColumn.header.tag.downtotal")) + ":");
        this.history_total_down = new Label(controlPanel, 0);
        Label lbl_up = new Label(controlPanel, 0);
        lbl_up.setText(String.valueOf(MessageText.getString("TableColumn.header.tag.uptotal")) + ":");
        this.history_total_up = new Label(controlPanel, 0);
        Color[] colors = new Color[]{Colors.blues[9], Colors.fadedGreen};
        ValueFormater formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc((long)value * TransferStatsView.this.history_scale_div);
            }

            @Override
            public String formatTime(long time) {
                if (TransferStatsView.this.history_selected_span_suffix == TransferStatsView.this.SPAN_ALL_TIME) {
                    return new SimpleDateFormat("yyyy/MM").format(new Date(time));
                }
                if (TransferStatsView.this.history_selected_span_suffix < 4) {
                    return new SimpleDateFormat("HH:mm").format(new Date(time));
                }
                if (TransferStatsView.this.history_selected_span_suffix == 4) {
                    return new SimpleDateFormat("dd HH:mm").format(new Date(time));
                }
                return new SimpleDateFormat("MM/dd").format(new Date(time));
            }
        };
        ValueSource[] sources = new ValueSourceImpl[]{new ValueSourceImpl("Down", 0, colors, false, false, false){

            @Override
            public int getValue() {
                Debug.out("eh?");
                return 0;
            }
        }, new ValueSourceImpl("Up", 1, colors, true, false, false){

            @Override
            public int getValue() {
                Debug.out("eh?");
                return 0;
            }
        }};
        Monitor[] monitors = this.historyPanel.getDisplay().getMonitors();
        int total_width = 0;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor m = monitorArray[n2];
            total_width += m.getClientArea().width;
            ++n2;
        }
        this.history_mpg = MultiPlotGraphic.getInstance(total_width, sources, formatter);
        String[] color_configs = new String[]{"TransferStats.history.legend.down", "TransferStats.history.legend.up"};
        Legend.LegendListener legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources){
            private int hover_index = -1;
            private final /* synthetic */ ValueSourceImpl[] val$sources;
            {
                this.val$sources = valueSourceImplArray;
            }

            @Override
            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                TransferStatsView.this.history_mpg.refresh(true);
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                TransferStatsView.this.history_mpg.refresh(true);
            }
        };
        Composite graphPanel = new Composite(this.historyPanel, 0);
        gd = new GridData(1808);
        graphPanel.setLayoutData((Object)gd);
        graphPanel.setLayout((Layout)Utils.getSimpleGridLayout(1));
        gd = new GridData(768);
        Legend.createLegendComposite(this.historyPanel, colors, color_configs, null, gd, true, legend_listener);
        Canvas speedCanvas = new Canvas(graphPanel, 262144);
        gd = new GridData(1808);
        speedCanvas.setLayoutData((Object)gd);
        this.history_mpg.initialize(speedCanvas, false);
    }

    private void refreshHistory() {
        long span;
        long start_time;
        int period_suffix;
        if (!this.historyPanel.isVisible()) {
            return;
        }
        int current_width = this.history_mpg.getVisibleEntryCount();
        if (current_width <= 0) {
            return;
        }
        LongTermStats lt_stats = StatsFactory.getLongTermStats();
        int span_suffix = this.history_selected_span_suffix;
        boolean all_time = false;
        if (span_suffix == 2) {
            period_suffix = 1;
        } else if (span_suffix == 3) {
            period_suffix = 1;
        } else if (span_suffix == 4) {
            period_suffix = 2;
        } else if (span_suffix == 5) {
            period_suffix = 2;
        } else if (span_suffix == 6) {
            period_suffix = 3;
        } else {
            period_suffix = 4;
            all_time = true;
        }
        long period = TimeFormatter.TIME_SUFFIXES_2_MULT[period_suffix] * 1000L;
        long end_time = SystemTime.getCurrentTime();
        if (all_time) {
            start_time = lt_stats.getOverallStartTime();
            start_time = start_time / period * period;
            end_time = (end_time + (period - 1L)) / period * period;
            span = end_time - start_time;
        } else {
            span = TimeFormatter.TIME_SUFFIXES_2_MULT[span_suffix] * 1000L;
            end_time += (long)this.history_period_offset * span;
            end_time = (end_time + (period - 1L)) / period * period;
            start_time = end_time - span;
        }
        if (this.history_last_span == span && this.history_last_period == period && this.history_last_width == (long)current_width && this.history_last_offset == this.history_period_offset) {
            return;
        }
        int entries = (int)(span / period);
        SimpleDateFormat sdf = new SimpleDateFormat();
        this.history_span.setText(String.valueOf(sdf.format(new Date(start_time))) + " - " + sdf.format(new Date(end_time - 1L)));
        long[] overall_stats = this.getTotalUsageInPeriod(lt_stats, start_time, end_time);
        double chunk = (double)current_width / (double)entries;
        long[][] data = new long[2][current_width];
        long[] times = new long[current_width];
        int pos = 0;
        int last_time = -1;
        long max_data = 0L;
        long pending_down = 0L;
        long pending_up = 0L;
        int i = 0;
        while (i < entries) {
            int this_chunk = i == entries - 1 ? current_width - pos : (int)((double)i * chunk) - pos;
            if (last_time == -1 || pos - last_time > 50) {
                times[pos + this_chunk / 2] = start_time;
                last_time = pos;
            }
            Date start_date = new Date(start_time);
            Date end_date = new Date(start_time + period - 1L);
            long[] stats2 = lt_stats.getTotalUsageInPeriod(start_date, end_date);
            long downloaded = stats2[3];
            long uploaded = stats2[1];
            if (this_chunk == 0) {
                pending_down += downloaded;
                pending_up += uploaded;
            } else {
                pending_down = 0L;
                pending_up = 0L;
                max_data = Math.max(max_data, downloaded += pending_down);
                max_data = Math.max(max_data, uploaded += pending_up);
                int j = 0;
                while (j < this_chunk) {
                    data[0][pos] = downloaded;
                    data[1][pos] = uploaded;
                    ++pos;
                    ++j;
                }
            }
            start_time += period;
            ++i;
        }
        long total_down = overall_stats[3];
        long total_up = overall_stats[1];
        String str = TimeFormatter.TIME_SUFFIXES_2_LONG[period_suffix];
        if (str.length() > 1) {
            str = String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
        }
        this.history_resolution.setText(str);
        this.history_total_down.setText(DisplayFormatters.formatByteCountToKiBEtc(total_down));
        this.history_total_up.setText(DisplayFormatters.formatByteCountToKiBEtc(total_up));
        this.history_resolution.getParent().layout(true);
        int div = 1;
        while (max_data > 0x3FFFFFFFL) {
            div *= 2;
            max_data /= 2L;
        }
        this.history_scale_div = div;
        int[][] idata = new int[2][current_width];
        int i2 = 0;
        while (i2 < 2) {
            long[] d = data[i2];
            int[] id = idata[i2];
            int j = 0;
            while (j < current_width) {
                id[j] = (int)(d[j] / (long)div);
                ++j;
            }
            ++i2;
        }
        this.reverse(times);
        this.history_mpg.reset(idata, times);
        this.history_last_span = span;
        this.history_last_period = period;
        this.history_last_width = current_width;
        this.history_last_offset = this.history_period_offset;
    }

    private long[] getTotalUsageInPeriod(LongTermStats lt_stats, long start, long end) {
        long[] r1 = lt_stats.getTotalUsageInPeriod(new Date(start), new Date(end));
        return r1;
    }

    private void reverse(long[] a) {
        int len = a.length;
        int i = 0;
        while (i < len / 2) {
            long t = a[i];
            a[i] = a[len - i - 1];
            a[len - i - 1] = t;
            ++i;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString("TransferStatsView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                if (this.generalPanel == null) break;
                this.generalPanel.layout(true, true);
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }

    private static class RouteInfo {
        private String name;
        private RouteInfoRecord incoming = new RouteInfoRecord();
        private RouteInfoRecord outgoing = new RouteInfoRecord();

        private RouteInfo(String _name) {
            this.name = _name;
        }

        private String getName() {
            return this.name;
        }

        private String getIncomingString() {
            return this.incoming.getString();
        }

        private String getOutgoingString() {
            return this.outgoing.getString();
        }

        private void update(PEPeer peer) {
            RouteInfoRecord record = peer.isIncoming() ? this.incoming : this.outgoing;
            record.update(peer);
        }
    }

    private static class RouteInfoRecord {
        private int peer_count;
        private int up_rate;
        private int down_rate;

        private RouteInfoRecord() {
        }

        private void update(PEPeer peer) {
            ++this.peer_count;
            PEPeerStats stats2 = peer.getStats();
            this.up_rate = (int)((long)this.up_rate + (stats2.getDataSendRate() + stats2.getProtocolSendRate()));
            this.down_rate = (int)((long)this.down_rate + (stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()));
        }

        private String getString() {
            if (this.peer_count == 0) {
                return "0";
            }
            return String.valueOf(this.peer_count) + ": up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.up_rate) + ", down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.down_rate);
        }
    }

    private static abstract class ValueSourceImpl
    implements ValueSource {
        private String name;
        private int index;
        private Color[] colours;
        private boolean is_up;
        private boolean trimmable;
        private boolean is_hover;
        private boolean is_invisible;
        private boolean is_dotted;

        private ValueSourceImpl(String _name, int _index, Color[] _colours, boolean _is_up, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.is_up = _is_up;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getLineColor() {
            return this.colours[this.index];
        }

        @Override
        public boolean isTrimmable() {
            return this.trimmable;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        @Override
        public int getStyle() {
            if (this.is_invisible) {
                return 16;
            }
            int style = 0;
            if (this.is_hover) {
                style |= 8;
            }
            return style |= 0x40;
        }

        @Override
        public int getAlpha() {
            return this.is_dotted ? 128 : 255;
        }
    }

    class plotView {
        private SpeedManagerPingMapper mapper;
        private Plot3D plotGraph;

        protected plotView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.plotGraph = new Plot3D(_labels, _formatters);
            this.plotGraph.setMaxZ(1199);
            this.plotGraph.initialize(_canvas);
        }

        protected void update() {
            int[][] history = this.mapper.getHistory();
            this.plotGraph.update(history);
            this.plotGraph.setTitle(TransferStatsView.this.getMapperTitle(this.mapper));
        }

        protected void refresh() {
            this.plotGraph.refresh(false);
        }

        protected void dispose() {
            this.plotGraph.dispose();
        }
    }

    class zoneView
    implements ParameterListener {
        private SpeedManagerPingMapper mapper;
        private SpeedManagerPingZone[] zones = new SpeedManagerPingZone[0];
        private Canvas canvas;
        private ValueFormater[] formatters;
        private String[] labels;
        private String title = "";
        private int refresh_count;
        private int graphicsUpdate;
        private Point old_size;
        protected Image buffer_image;

        protected zoneView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.canvas = _canvas;
            this.labels = _labels;
            this.formatters = _formatters;
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (zoneView.this.buffer_image != null && !zoneView.this.buffer_image.isDisposed()) {
                        Rectangle bounds = zoneView.this.buffer_image.getBounds();
                        if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                            e.gc.drawImage(zoneView.this.buffer_image, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                        }
                    }
                }
            });
            this.canvas.addListener(11, new Listener(){

                public void handleEvent(Event event2) {
                    zoneView.this.refresh(true);
                }
            });
            COConfigurationManager.addAndFireParameterListener("Graphics Update", this);
        }

        @Override
        public void parameterChanged(String name) {
            this.graphicsUpdate = COConfigurationManager.getIntParameter(name);
        }

        protected void update() {
            this.zones = this.mapper.getZones();
            this.title = TransferStatsView.this.getMapperTitle(this.mapper);
        }

        private void refresh(boolean force) {
            if (this.canvas.isDisposed() || !this.canvas.isVisible()) {
                return;
            }
            Rectangle bounds = this.canvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
                return;
            }
            boolean size_changed = this.old_size == null || this.old_size.x != bounds.width || this.old_size.y != bounds.height;
            this.old_size = new Point(bounds.width, bounds.height);
            ++this.refresh_count;
            if (this.refresh_count > this.graphicsUpdate || force) {
                this.refresh_count = 0;
            }
            if (this.refresh_count == 0 || size_changed) {
                if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                    this.buffer_image.dispose();
                }
                this.buffer_image = this.draw(bounds);
            }
            if (this.buffer_image != null) {
                GC gc = new GC((Drawable)this.canvas);
                gc.drawImage(this.buffer_image, bounds.x, bounds.y);
                gc.dispose();
            }
        }

        private Image draw(Rectangle bounds) {
            SpeedManagerLimitEstimate[] bad_down;
            SpeedManagerLimitEstimate[] bad_up;
            int i;
            int i2;
            int PAD_TOP = 10;
            int PAD_BOTTOM = 10;
            int PAD_RIGHT = 10;
            int PAD_LEFT = 10;
            int usable_width = bounds.width - 10 - 10;
            int usable_height = bounds.height - 10 - 10;
            Image image = new Image((Device)this.canvas.getDisplay(), bounds);
            GC gc = new GC((Drawable)image);
            boolean dark = Utils.isDarkAppearanceNative();
            if (dark) {
                gc.setBackground(this.canvas.getBackground());
                gc.fillRectangle(bounds);
            }
            gc.setForeground(dark ? Colors.grey : Colors.black);
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            try {
                gc.setAntialias(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int font_height = gc.getFontMetrics().getHeight();
            int char_width = gc.getFontMetrics().getAverageCharWidth();
            Color[] colours = TransferStatsView.this.plot_views[0].plotGraph.getColours();
            int max_x = 0;
            int max_y = 0;
            if (this.zones.length > 0) {
                int max_metric = 0;
                int i3 = 0;
                while (i3 < this.zones.length) {
                    SpeedManagerPingZone zone = this.zones[i3];
                    int metric = zone.getMetric();
                    if (metric > 0) {
                        max_metric = Math.max(max_metric, metric);
                        max_x = Math.max(max_x, zone.getUploadEndBytesPerSec());
                        max_y = Math.max(max_y, zone.getDownloadEndBytesPerSec());
                    }
                    ++i3;
                }
                if (max_x > 0 && max_y > 0) {
                    double x_ratio = (double)usable_width / (double)max_x;
                    double y_ratio = (double)usable_height / (double)max_y;
                    ArrayList<Object[]> texts = new ArrayList<Object[]>();
                    i2 = 0;
                    while (i2 < this.zones.length) {
                        SpeedManagerPingZone zone = this.zones[i2];
                        int metric = zone.getMetric();
                        int x1 = zone.getUploadStartBytesPerSec();
                        int y1 = zone.getDownloadStartBytesPerSec();
                        int x2 = zone.getUploadEndBytesPerSec();
                        int y2 = zone.getDownloadEndBytesPerSec();
                        if (metric > 0) {
                            int colour_index = (int)((float)metric * (float)colours.length / (float)max_metric);
                            if (colour_index >= colours.length) {
                                colour_index = colours.length - 1;
                            }
                            gc.setBackground(colours[colour_index]);
                            int x = 10 + (int)((double)x1 * x_ratio);
                            int y = 10 + (int)((double)y1 * y_ratio);
                            int width = (int)Math.ceil((double)(x2 - x1 + 1) * x_ratio);
                            int height = (int)Math.ceil((double)(y2 - y1 + 1) * y_ratio);
                            int y_draw = usable_height + 10 + 10 - y - height;
                            gc.fillRectangle(x, y_draw, width, height);
                            int text_metric = zone.getMetric();
                            String text = String.valueOf(metric);
                            int text_width = text.length() * char_width + 4;
                            if (width >= text_width && height >= font_height) {
                                Rectangle text_rect = new Rectangle(x + (width - text_width) / 2, y_draw + (height - font_height) / 2, text_width, font_height);
                                Iterator it = texts.iterator();
                                while (it.hasNext()) {
                                    Object[] old = (Object[])it.next();
                                    Rectangle old_coords = (Rectangle)old[1];
                                    if (!old_coords.intersects(text_rect)) continue;
                                    it.remove();
                                }
                                texts.add(new Object[]{new Integer(text_metric), text_rect});
                            }
                        }
                        ++i2;
                    }
                    int text_num = texts.size();
                    gc.setForeground(dark ? Colors.white : Colors.black);
                    int i4 = text_num > 100 ? text_num - 100 : 0;
                    while (i4 < text_num) {
                        Object[] entry = (Object[])texts.get(i4);
                        String str = String.valueOf(entry[0]);
                        Rectangle rect = (Rectangle)entry[1];
                        gc.drawText(str, rect.x, rect.y, 1);
                        ++i4;
                    }
                }
            }
            int x_axis_left_x = 10;
            int x_axis_left_y = usable_height + 10;
            int x_axis_right_x = 10 + usable_width;
            int x_axis_right_y = x_axis_left_y;
            gc.drawLine(x_axis_left_x, x_axis_left_y, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y - 4, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y + 4, x_axis_right_x, x_axis_right_y);
            int i5 = 1;
            while (i5 < 10) {
                int x = x_axis_left_x + (x_axis_right_x - x_axis_left_x) * i5 / 10;
                gc.drawLine(x, x_axis_left_y, x, x_axis_left_y + 4);
                ++i5;
            }
            SpeedManagerLimitEstimate le = this.mapper.getEstimatedUploadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    int i6 = 0;
                    while (i6 < segs.length) {
                        int[] seg = segs[i6];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                        ++i6;
                    }
                    double metric_ratio = max_metric == 0 ? 1.0f : 50.0f / (float)max_metric;
                    double pos_ratio = max_pos == 0 ? 1.0f : (float)usable_width / (float)max_pos;
                    int prev_x = 1;
                    int prev_y = 1;
                    i = 0;
                    while (i < segs.length) {
                        int[] seg = segs[i];
                        int next_x = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        int next_y = (int)((double)seg[0] * metric_ratio) + 1;
                        gc.drawLine(x_axis_left_x + prev_x, x_axis_left_y - prev_y, x_axis_left_x + next_x, x_axis_left_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                        ++i;
                    }
                }
                gc.setForeground(dark ? Colors.grey : Colors.black);
            }
            if ((bad_up = this.mapper.getBadUploadHistory()).length > 0) {
                gc.setLineWidth(3);
                gc.setForeground(Colors.red);
                i2 = 0;
                while (i2 < bad_up.length) {
                    int speed = bad_up[i2].getBytesPerSec();
                    int x = max_x == 0 ? 0 : speed * usable_width / max_x;
                    gc.drawLine(x_axis_left_x + x, x_axis_left_y - 0, x_axis_left_x + x, x_axis_left_y - 10);
                    ++i2;
                }
                gc.setForeground(dark ? Colors.grey : Colors.black);
                gc.setLineWidth(1);
            }
            gc.setForeground(dark ? Colors.white : Colors.black);
            String x_text = String.valueOf(this.labels[0]) + " - " + this.formatters[0].format(max_x + 1);
            gc.drawText(x_text, x_axis_right_x - 20 - x_text.length() * char_width, x_axis_right_y - font_height - 2, 1);
            int y_axis_bottom_x = 10;
            int y_axis_bottom_y = usable_height + 10;
            int y_axis_top_x = 10;
            int y_axis_top_y = 10;
            gc.drawLine(y_axis_bottom_x, y_axis_bottom_y, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x - 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x + 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            int i7 = 1;
            while (i7 < 10) {
                int y = y_axis_bottom_y + (y_axis_top_y - y_axis_bottom_y) * i7 / 10;
                gc.drawLine(y_axis_bottom_x, y, y_axis_bottom_x - 4, y);
                ++i7;
            }
            le = this.mapper.getEstimatedDownloadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    i = 0;
                    while (i < segs.length) {
                        int[] seg = segs[i];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                        ++i;
                    }
                    double metric_ratio = max_metric == 0 ? 1.0f : 50.0f / (float)max_metric;
                    double pos_ratio = max_pos == 0 ? 1.0f : (float)usable_height / (float)max_pos;
                    int prev_x = 1;
                    int prev_y = 1;
                    int i8 = 0;
                    while (i8 < segs.length) {
                        int[] seg = segs[i8];
                        int next_x = (int)((double)seg[0] * metric_ratio) + 1;
                        int next_y = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        gc.drawLine(y_axis_bottom_x + prev_x, y_axis_bottom_y - prev_y, y_axis_bottom_x + next_x, y_axis_bottom_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                        ++i8;
                    }
                }
                gc.setForeground(dark ? Colors.grey : Colors.black);
            }
            if ((bad_down = this.mapper.getBadDownloadHistory()).length > 0) {
                gc.setForeground(Colors.red);
                gc.setLineWidth(3);
                int i9 = 0;
                while (i9 < bad_down.length) {
                    int speed = bad_down[i9].getBytesPerSec();
                    int y = max_y == 0 ? 0 : speed * usable_height / max_y;
                    gc.drawLine(y_axis_bottom_x + 0, y_axis_bottom_y - y, y_axis_bottom_x + 10, y_axis_bottom_y - y);
                    ++i9;
                }
                gc.setForeground(dark ? Colors.grey : Colors.black);
                gc.setLineWidth(1);
            }
            String y_text = String.valueOf(this.labels[1]) + " - " + this.formatters[1].format(max_y + 1);
            gc.setForeground(dark ? Colors.white : Colors.black);
            gc.drawText(y_text, y_axis_top_x + 4, y_axis_top_y + 2, 1);
            gc.drawText(this.title, (bounds.width - this.title.length() * char_width) / 2, 1, 1);
            gc.dispose();
            return image;
        }

        protected void dispose() {
            if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                this.buffer_image.dispose();
            }
            COConfigurationManager.removeParameterListener("Graphics Update", this);
        }
    }
}

