/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.dht.control.DHTControlContact;
import com.biglybt.core.dht.netcoords.DHTNetworkPosition;
import com.biglybt.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.biglybt.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.stats.BasePanel;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class VivaldiPanel
extends BasePanel {
    private static final int ALPHA_FOCUS = 255;
    private static final int ALPHA_NOFOCUS = 150;
    private static Map<String, BasePanel.Scale> scale_map = new HashMap<String, BasePanel.Scale>();
    Display display;
    Composite parent;
    Canvas canvas;
    BasePanel.Scale scale;
    private boolean antiAliasingAvailable = true;
    private List<DHTControlContact> lastContacts;
    private DHTTransportContact lastSelf;
    private String id;
    private Image img;
    private int alpha = 255;
    private boolean autoAlpha = false;
    private List<Object[]> currentPositions = new ArrayList<Object[]>();
    private boolean isRefreshQueued = false;

    public VivaldiPanel(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        this.canvas = new Canvas(parent, 262144);
        this.scale = new BasePanel.Scale();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (VivaldiPanel.this.img != null && !VivaldiPanel.this.img.isDisposed()) {
                    Rectangle bounds = VivaldiPanel.this.img.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        if (VivaldiPanel.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(VivaldiPanel.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(VivaldiPanel.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.setBackground(Utils.isDarkAppearanceNative() ? VivaldiPanel.this.canvas.getBackground() : Colors.white);
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    e.gc.drawText(MessageText.getString("VivaldiView.notAvailable"), 10, 10, true);
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                VivaldiPanel.this.scale.mouseDown(event2);
            }

            public void mouseUp(MouseEvent event2) {
                VivaldiPanel.this.scale.mouseUp(event2);
                VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
            }

            public void mouseDoubleClick(MouseEvent e) {
                VivaldiPanel.this.scale.reset();
                VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
            }
        });
        this.canvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                int x = e.x;
                int y = e.y;
                DHTControlContact closest = null;
                int closest_distance = Integer.MAX_VALUE;
                int x_coord = 0;
                int y_coord = 0;
                float height = -1.0f;
                for (Object[] entry : VivaldiPanel.this.currentPositions) {
                    int e_y;
                    long y_diff;
                    int e_x = (Integer)entry[0];
                    long x_diff = x - e_x;
                    int distance = (int)Math.sqrt(x_diff * x_diff + (y_diff = (long)(y - (e_y = ((Integer)entry[1]).intValue()))) * y_diff);
                    if (distance >= closest_distance) continue;
                    closest_distance = distance;
                    x_coord = e_x;
                    y_coord = e_y;
                    height = ((Float)entry[2]).floatValue();
                    closest = (DHTControlContact)entry[3];
                }
                if (closest_distance <= 25) {
                    InetAddress address = closest.getTransportContact().getTransportAddress().getAddress();
                    String[] details = PeerUtils.getCountryDetails(address);
                    String tt = address.getHostAddress();
                    if (details != null) {
                        tt = String.valueOf(tt) + ": " + details[0] + "/" + details[1];
                    }
                    tt = String.valueOf(tt) + " (x=" + (float)(x_coord * 10000) / 10000.0f + ",y=" + (float)(y_coord * 10000) / 10000.0f + ",h=" + (float)((int)(height * 10000.0f)) / 10000.0f + ")";
                    Utils.setTT((Control)VivaldiPanel.this.canvas, tt);
                } else {
                    Utils.setTT((Control)VivaldiPanel.this.canvas, MessageText.getString("vivaldi.tt"));
                }
            }
        });
        this.canvas.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addListener(37, new Listener(){

            public void handleEvent(Event event2) {
                VivaldiPanel.this.scale.mouseWheel(event2);
                VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event2) {
                if (VivaldiPanel.this.scale.mouseMove(event2)) {
                    VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (VivaldiPanel.this.autoAlpha) {
                    VivaldiPanel.this.setAlpha(150);
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (VivaldiPanel.this.autoAlpha) {
                    VivaldiPanel.this.setAlpha(255);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(String _id) {
        BasePanel.Scale existing;
        this.id = _id;
        Map<String, BasePanel.Scale> map = scale_map;
        synchronized (map) {
            existing = scale_map.get(this.id);
        }
        if (existing != null) {
            Utils.execSWTThread(() -> {
                this.scale = existing;
                this.refreshContacts(this.lastContacts, this.lastSelf);
            });
        }
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void refreshContacts(List<DHTControlContact> contacts, DHTTransportContact self) {
        if (contacts == null || self == null) {
            return;
        }
        this.lastContacts = contacts;
        this.lastSelf = self;
        if (this.isRefreshQueued) {
            return;
        }
        this.isRefreshQueued = true;
        Utils.execSWTThreadLater(20, () -> {
            this.isRefreshQueued = false;
            this._refreshContacts();
        });
    }

    public void _refreshContacts() {
        long now;
        int num_pos;
        boolean needNewImage;
        if (this.lastContacts == null || this.lastSelf == null) {
            return;
        }
        if (this.canvas.isDisposed()) {
            return;
        }
        Point canvasSize = this.canvas.getSize();
        Rectangle size = new Rectangle(0, 0, canvasSize.x, canvasSize.y);
        if (size.isEmpty()) {
            return;
        }
        this.scale.setSize(size);
        Color blue = ColorCache.getColor((Device)this.display, 66, 87, 104);
        boolean bl = needNewImage = this.img == null || this.img.isDisposed();
        if (!needNewImage) {
            Rectangle bounds = this.img.getBounds();
            boolean bl2 = needNewImage = bounds.width != size.width || bounds.height != size.height;
        }
        if (needNewImage) {
            this.img = new Image((Device)this.display, size);
        }
        GC gc = new GC((Drawable)this.img);
        gc.setBackground(Utils.isDarkAppearanceNative() ? this.canvas.getBackground() : Colors.white);
        gc.fillRectangle(size);
        if (SWT.getVersion() < 3138 || this.antiAliasingAvailable) {
            // empty if block
        }
        gc.setForeground(blue);
        DHTNetworkPosition _ownPosition = this.lastSelf.getNetworkPosition((byte)1);
        if (_ownPosition == null) {
            gc.dispose();
            return;
        }
        this.currentPositions.clear();
        VivaldiPosition ownPosition = (VivaldiPosition)_ownPosition;
        float ownErrorEstimate = ownPosition.getErrorEstimate();
        HeightCoordinatesImpl ownCoords = (HeightCoordinatesImpl)ownPosition.getCoordinates();
        gc.drawText(MessageText.getString("vivaldi.our.error", new String[]{String.valueOf(ownErrorEstimate)}), 10, 10, 1);
        Color black = ColorCache.getColor((Device)this.display, 0, 0, 0);
        gc.setBackground(black);
        long total_distance = 0L;
        for (DHTControlContact contact : this.lastContacts) {
            VivaldiPosition position;
            HeightCoordinatesImpl coord;
            DHTNetworkPosition _position = contact.getTransportContact().getNetworkPosition((byte)1);
            if (_position == null || !(coord = (HeightCoordinatesImpl)(position = (VivaldiPosition)_position).getCoordinates()).isValid()) continue;
            int distance = (int)ownCoords.distance(coord);
            total_distance += (long)distance;
            this.draw(gc, coord.getX(), coord.getY(), coord.getH(), contact, distance, position.getErrorEstimate());
        }
        Color red = ColorCache.getColor((Device)this.display, 255, 0, 0);
        gc.setForeground(red);
        this.drawSelf(gc, ownCoords.getX(), ownCoords.getY(), ownCoords.getH(), ownErrorEstimate);
        gc.dispose();
        boolean skip_redraw = false;
        if (!this.scale.disableAutoScale && (num_pos = this.currentPositions.size()) > 0 && (now = SystemTime.getMonotonousTime()) - this.scale.lastAutoScale >= 5000L) {
            this.scale.lastAutoScale = now;
            float min_x = Float.MAX_VALUE;
            float min_y = Float.MAX_VALUE;
            float max_x = Float.MIN_VALUE;
            float max_y = Float.MIN_VALUE;
            int average_distance = (int)(total_distance / (long)num_pos);
            for (Object[] entry : this.currentPositions) {
                int distance;
                if (num_pos > 25 && (distance = ((Integer)entry[6]).intValue()) >= average_distance * 4) continue;
                float x = ((Float)entry[4]).floatValue();
                float y = ((Float)entry[5]).floatValue();
                min_x = Math.min(min_x, x);
                min_y = Math.min(min_y, y);
                max_x = Math.max(max_x, x);
                max_y = Math.max(max_y, y);
            }
            float new_min_x = min_x - 50.0f;
            float new_max_x = max_x + 50.0f;
            float new_min_y = min_y - 50.0f;
            float new_max_y = max_y + 50.0f;
            this.scale.setScale(new_min_x, new_max_x, new_min_y, new_max_y);
            this._refreshContacts();
            skip_redraw = true;
        }
        if (!skip_redraw) {
            this.canvas.redraw();
        }
    }

    private void draw(GC gc, float x, float y, float h, DHTControlContact contact, int distance, float error) {
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        if (error > 1.0f) {
            error = 1.0f;
        }
        int errDisplay = (int)(100.0f * error);
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        Image img = ImageRepository.getCountryFlag(contact.getTransportContact().getTransportAddress().getAddress(), true);
        if (img != null) {
            Rectangle bounds = img.getBounds();
            int old = gc.getAlpha();
            gc.setAlpha(150);
            gc.drawImage(img, x0 - bounds.width / 2, y0 - bounds.height);
            gc.setAlpha(old);
        }
        gc.fillRectangle(x0 - 1, y0 - 1, 3, 3);
        String text = String.valueOf(distance) + " ms " + errDisplay + "%";
        int lineReturn = text.indexOf("\n");
        int xOffset = gc.getFontMetrics().getAverageCharWidth() * (lineReturn != -1 ? lineReturn : text.length()) / 2;
        gc.drawText(text, x0 - xOffset, y0, true);
        this.currentPositions.add(new Object[]{x0, y0, Float.valueOf(h), contact, Float.valueOf(x), Float.valueOf(y), distance});
    }

    private void drawSelf(GC gc, float x, float y, float h, float errorEstimate) {
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.drawLine(x0 - 15, y0, x0 + 15, y0);
        gc.drawLine(x0, y0 - 15, x0, y0 + 15);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.canvas.getDisplay().getCursorControl() == this.canvas ? 255 : 150);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        if (this.id != null) {
            Map<String, BasePanel.Scale> map = scale_map;
            synchronized (map) {
                scale_map.put(this.id, this.scale.clone());
            }
        }
    }
}

