/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.control.DHTControlContact;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.stats.VivaldiPanel;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class VivaldiView
implements UISWTViewCoreEventListener {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    public static final int DHT_TYPE_BIGLYBT = 4;
    public static final String MSGID_PREFIX = "VivaldiView";
    DHT dht;
    Composite panel;
    VivaldiPanel drawPanel;
    private final boolean autoAlpha;
    private int dht_type;
    private Core core;
    private UISWTView swtView;

    public VivaldiView(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
    }

    public VivaldiView() {
        this(false);
    }

    private void init(Core core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            int i = 0;
            while (i < dhts.length) {
                if (dhts[i].getTransport().getNetwork() == this.dht_type) {
                    this.dht = dhts[i];
                    break;
                }
                ++i;
            }
            if (this.dht == null) {
                return;
            }
            if (this.drawPanel != null) {
                this.drawPanel.setID(String.valueOf(this.dht.getTransport().getNetwork()));
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void initialize(Composite composite) {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                VivaldiView.this.core = core;
                VivaldiView.this.init(core);
            }
        });
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new FillLayout());
        this.drawPanel = new VivaldiPanel(this.panel);
        this.drawPanel.setAutoAlpha(this.autoAlpha);
        if (this.dht != null) {
            this.drawPanel.setID(String.valueOf(this.dht.getTransport().getNetwork()));
        }
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            } else {
                return;
            }
        }
        if (this.dht != null) {
            List<DHTControlContact> l = this.dht.getControl().getContacts();
            this.drawPanel.refreshContacts(l, this.dht.getControl().getTransport().getLocalContact());
        }
    }

    private String getTitleID() {
        if (this.dht_type == 0) {
            return "VivaldiView.title.full";
        }
        if (this.dht_type == 1) {
            return "VivaldiView.title.fullcvs";
        }
        if (this.dht_type == 4) {
            return "VivaldiView.title.biglybt";
        }
        return "VivaldiView.title.full_v6";
    }

    private void delete() {
        if (this.drawPanel != null) {
            this.drawPanel.delete();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                if (this.swtView.getInitialDataSource() instanceof Number) {
                    this.dht_type = ((Number)this.swtView.getInitialDataSource()).intValue();
                }
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                if (!(event2.getData() instanceof Number)) break;
                this.dht_type = ((Number)event2.getData()).intValue();
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

