/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.stats.XferStatsPanel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class XferStatsView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "XferStatsView";
    Composite composite;
    XferStatsPanel local_stats;
    XferStatsPanel global_stats;
    private final boolean autoAlpha;
    private UISWTView swtView;

    public XferStatsView() {
        this(false);
    }

    public XferStatsView(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
    }

    public void initialize(Composite _composite) {
        this.composite = _composite;
        CTabFolder tab_folder = new CTabFolder(this.composite, 16384);
        CTabItem global_item = new CTabItem(tab_folder, 0);
        global_item.setText(MessageText.getString("label.global"));
        Composite global_composite = new Composite((Composite)tab_folder, 0);
        global_item.setControl((Control)global_composite);
        global_composite.setLayout((Layout)new FillLayout());
        global_composite.setLayoutData((Object)Utils.getFilledFormData());
        Composite global_panel = new Composite(global_composite, 0);
        global_panel.setLayout((Layout)new FillLayout());
        this.global_stats = new XferStatsPanel(global_panel, true);
        this.global_stats.setAutoAlpha(this.autoAlpha);
        CTabItem local_item = new CTabItem(tab_folder, 0);
        local_item.setText(MessageText.getString("DHTView.db.local"));
        Composite local_composite = new Composite((Composite)tab_folder, 0);
        local_composite.setLayout((Layout)new FillLayout());
        local_composite.setLayoutData((Object)Utils.getFilledFormData());
        local_item.setControl((Control)local_composite);
        Composite local_panel = new Composite(local_composite, 0);
        local_panel.setLayout((Layout)new FillLayout());
        this.local_stats = new XferStatsPanel(local_panel, false);
        this.local_stats.setAutoAlpha(this.autoAlpha);
        tab_folder.setSelection(global_item);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        GlobalManagerStats stats2 = core.getGlobalManager().getStats();
                        (this).XferStatsView.this.global_stats.init(stats2.getAggregateRemoteStats());
                        (this).XferStatsView.this.local_stats.init(stats2.getAggregateLocalStats());
                    }
                });
            }
        });
    }

    private String getTitleID() {
        return "XferStatsView.title.full";
    }

    public void delete() {
        if (this.global_stats != null) {
            this.global_stats.delete();
            this.local_stats.delete();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.composite);
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                if (this.global_stats == null) break;
                this.global_stats.requestRefresh();
                this.local_stats.requestRefresh();
                break;
            }
            case 5: {
                if (this.global_stats == null) break;
                this.global_stats.refreshView();
                this.local_stats.refreshView();
            }
        }
        return true;
    }
}

