/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellClipboardListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellMenuEvent;
import com.biglybt.pif.ui.tables.TableCellMenuListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.ui.tables.TableRowMouseListener;
import com.biglybt.pifimpl.local.disk.DiskManagerFileInfoImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.peers.PeerManagerImpl;
import com.biglybt.pifimpl.local.tracker.TrackerTorrentImpl;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FakeTableCell
implements TableCellSWT,
PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private AEMonitor this_mon = new AEMonitor("FakeTableCell");
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private ArrayList cellMouseListeners;
    private ArrayList cellMouseMoveListeners;
    private ArrayList cellVisibilityListeners;
    private ArrayList<TableCellClipboardListener> cellClipboardListeners;
    private Image image;
    private Rectangle imageBounds;
    private int marginHeight;
    private int orientation;
    private int marginWidth;
    private Comparable sortValue;
    private Object coreDataSource;
    private Composite composite;
    private final TableColumnCore tableColumn;
    private Graphic graphic;
    private String text;
    private String textEquiv;
    private double numericValue = Double.NaN;
    private Object pluginDataSource;
    private Object tooltip;
    private Object default_tooltip;
    private Rectangle cellArea;
    private boolean hadMore;
    private boolean wrapText = true;
    private ArrayList cellSWTPaintListeners;
    private boolean valid = false;
    private TableRow fakeRow = null;
    private Map<Object, Object> userData;

    public FakeTableCell(TableColumn column, Object ds) {
        this.coreDataSource = ds;
        this.tableColumn = (TableColumnCore)column;
        this.setOrientationViaColumn();
        this.tableColumn.invokeCellAddedListeners(this);
    }

    public FakeTableCell(TableColumnCore column, Object ds) {
        this.coreDataSource = ds;
        this.tableColumn = column;
        this.setOrientationViaColumn();
        this.tableColumn.invokeCellAddedListeners(this);
    }

    @Override
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addMenuListener(TableCellMenuListener listener) {
    }

    @Override
    public void removeMenuListener(TableCellMenuListener listener) {
    }

    public void addMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void addSWTPaintListener(TableCellSWTPaintListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellSWTPaintListeners == null) {
                this.cellSWTPaintListeners = new ArrayList(1);
            }
            this.cellSWTPaintListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void invokeSWTPaintListeners(GC gc) {
        Object[] swtPaintListeners;
        if (this.getBounds().isEmpty()) {
            return;
        }
        if (this.tableColumn != null && (swtPaintListeners = this.tableColumn.getCellOtherListeners("SWTPaint")) != null) {
            int i = 0;
            while (i < swtPaintListeners.length) {
                try {
                    TableCellSWTPaintListener l = (TableCellSWTPaintListener)swtPaintListeners[i];
                    l.cellPaint(gc, this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        if (this.cellSWTPaintListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellSWTPaintListeners.size()) {
            try {
                TableCellSWTPaintListener l = (TableCellSWTPaintListener)this.cellSWTPaintListeners.get(i);
                l.cellPaint(gc, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    private void addCellClipboardListener(TableCellClipboardListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellClipboardListeners == null) {
                this.cellClipboardListeners = new ArrayList(1);
            }
            this.cellClipboardListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public String getClipboardText() {
        String text;
        block7: {
            text = null;
            try {
                this.this_mon.enter();
                if (this.cellClipboardListeners == null) break block7;
                for (TableCellClipboardListener l : this.cellClipboardListeners) {
                    try {
                        text = l.getClipboardText(this);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    if (text == null) continue;
                    break;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (text == null) {
            text = this.getText();
        }
        return text;
    }

    @Override
    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMenuListener) {
            this.addMenuListener((TableCellMenuListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableCellSWTPaintListener) {
            this.addSWTPaintListener((TableCellSWTPaintListener)listenerObject);
        }
        if (listenerObject instanceof TableCellClipboardListener) {
            this.addCellClipboardListener((TableCellClipboardListener)listenerObject);
        }
    }

    @Override
    public void invokeMouseListeners(TableCellMouseEvent event2) {
        ArrayList listeners;
        if (event2.cell != null && event2.row == null) {
            event2.row = event2.cell.getTableRow();
        }
        try {
            this.tableColumn.invokeCellMouseListeners(event2);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ArrayList arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.size()) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)listeners.get(i);
                l.cellMouseTrigger(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void invokeMenuListeners(TableCellMenuEvent event2) {
    }

    @Override
    public Object getDataSource() {
        TRHostTorrent item;
        DiskManagerFileInfo fileInfo2;
        PEPiece piece;
        PEPeer peer;
        DownloadManager dm;
        boolean bCoreObject;
        boolean bl = bCoreObject = this.tableColumn != null && this.tableColumn.getUseCoreDataSource();
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        if (this.coreDataSource instanceof DownloadManager && (dm = (DownloadManager)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = DownloadManagerImpl.getDownloadStatic(dm);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof PEPeer && (peer = (PEPeer)this.coreDataSource) != null) {
            this.pluginDataSource = PeerManagerImpl.getPeerForPEPeer(peer);
        }
        if (this.coreDataSource instanceof PEPiece && (piece = (PEPiece)this.coreDataSource) != null) {
            this.pluginDataSource = null;
        }
        if (this.coreDataSource instanceof DiskManagerFileInfo && (fileInfo2 = (DiskManagerFileInfo)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof TRHostTorrent && (item = (TRHostTorrent)this.coreDataSource) != null) {
            this.pluginDataSource = new TrackerTorrentImpl(item);
        }
        if (this.pluginDataSource == null) {
            this.pluginDataSource = this.coreDataSource;
        }
        return this.pluginDataSource;
    }

    @Override
    public int[] getForeground() {
        if (this.composite == null || this.composite.isDisposed()) {
            return null;
        }
        Color fg = this.composite.getForeground();
        return new int[]{fg.getRed(), fg.getGreen(), fg.getBlue()};
    }

    @Override
    public int[] getBackground() {
        return new int[3];
    }

    @Override
    public Graphic getBackgroundGraphic() {
        Rectangle bounds;
        block10: {
            if (this.composite == null || this.composite.isDisposed()) {
                return null;
            }
            try {
                bounds = this.composite.getBounds();
                if (!bounds.isEmpty()) break block10;
                return null;
            }
            catch (Exception e) {
                Debug.out(e);
                return null;
            }
        }
        Image imgCap = new Image((Device)this.composite.getDisplay(), bounds.width, bounds.height);
        Control bgControl = Utils.findBackgroundImageControl((Control)this.composite);
        Image imgBG = this.composite.getBackgroundImage();
        GC gc = new GC((Drawable)imgCap);
        try {
            if (imgBG == null) {
                gc.setBackground(this.composite.getBackground());
                gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (imgBG != null) {
                Point controlPos = new Point(0, 0);
                if (bgControl instanceof Composite) {
                    Rectangle compArea = ((Composite)bgControl).getClientArea();
                    controlPos.x = compArea.x;
                    controlPos.y = compArea.y;
                }
                Point absControlLoc = bgControl.toDisplay(controlPos.x, controlPos.y);
                Rectangle shellClientArea = this.composite.getShell().getClientArea();
                Point absShellLoc = this.composite.getParent().toDisplay(shellClientArea.x, shellClientArea.y);
                Point ofs = new Point(absControlLoc.x - absShellLoc.x, absControlLoc.y - absShellLoc.y);
                Rectangle imgBGBounds = imgBG.getBounds();
                ofs.x %= imgBGBounds.width;
                ofs.y %= imgBGBounds.height;
                gc.drawImage(imgBG, ofs.x, ofs.y);
            }
        }
        finally {
            gc.dispose();
        }
        return new UISWTGraphicImpl(imgCap);
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public int getHeight() {
        if (this.composite != null && !this.composite.isDisposed()) {
            if (this.cellArea != null) {
                return this.cellArea.height;
            }
            return this.composite.getSize().y;
        }
        return 0;
    }

    @Override
    public int getMaxLines() {
        return -1;
    }

    @Override
    public Comparable getSortValue() {
        if (this.sortValue == null) {
            return "";
        }
        return this.sortValue;
    }

    @Override
    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Override
    public String getTableID() {
        return this.tableColumn == null ? null : this.tableColumn.getTableID();
    }

    @Override
    public TableRow getTableRow() {
        if (this.fakeRow == null) {
            this.fakeRow = new TableRow(){
                Map<String, Object> data = new LightHashMap<String, Object>(1);

                @Override
                public void removeMouseListener(TableRowMouseListener listener) {
                }

                @Override
                public int getIndex() {
                    return 1;
                }

                @Override
                public boolean isValid() {
                    return FakeTableCell.this.isValid();
                }

                @Override
                public boolean isSelected() {
                    return false;
                }

                @Override
                public String getTableID() {
                    return FakeTableCell.this.getTableID();
                }

                @Override
                public TableView<?> getView() {
                    return null;
                }

                @Override
                public TableCell getTableCell(String columnName) {
                    return null;
                }

                @Override
                public TableCell getTableCell(TableColumn column) {
                    return null;
                }

                @Override
                public Object getDataSource() {
                    return FakeTableCell.this.getDataSource();
                }

                @Override
                public void addMouseListener(TableRowMouseListener listener) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object getData(String id) {
                    Map<String, Object> map = this.data;
                    synchronized (map) {
                        return this.data.get(id);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void setData(String id, Object val) {
                    Map<String, Object> map = this.data;
                    synchronized (map) {
                        this.data.put(id, val);
                    }
                }
            };
        }
        return this.fakeRow;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Object getToolTip() {
        if (this.tooltip == null && this.hadMore) {
            return this.text;
        }
        return this.tooltip;
    }

    @Override
    public int getWidth() {
        if (!this.isDisposed()) {
            if (this.cellArea != null) {
                return this.cellArea.width - 2;
            }
            return this.composite.getSize().x;
        }
        return 0;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isDisposed() {
        return this.composite == null || this.composite.isDisposed();
    }

    @Override
    public boolean isShown() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setFillCell(boolean fillCell) {
    }

    public void setWrapText(boolean wrap) {
        this.wrapText = wrap;
    }

    @Override
    public boolean setForeground(int red, int green, int blue) {
        if (this.isDisposed()) {
            return false;
        }
        if (red < 0 || green < 0 || blue < 0) {
            this.composite.setForeground(null);
        } else {
            this.composite.setForeground(ColorCache.getColor((Device)this.composite.getDisplay(), red, green, blue));
        }
        return true;
    }

    @Override
    public boolean setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground(-1, -1, -1);
        }
        return this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public boolean setForegroundToErrorColor() {
        if (this.isDisposed()) {
            return false;
        }
        this.composite.setForeground(Colors.colorError);
        return true;
    }

    @Override
    public boolean setGraphic(Graphic img) {
        Image imgSWT = null;
        if (img instanceof UISWTGraphic) {
            imgSWT = ((UISWTGraphic)img).getImage();
        }
        if (imgSWT != null && imgSWT.isDisposed()) {
            return false;
        }
        if (this.image == imgSWT) {
            return false;
        }
        this.image = imgSWT;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.redraw();
        }
        this.graphic = img;
        return true;
    }

    @Override
    public void setMarginHeight(int height) {
    }

    @Override
    public void setMarginWidth(int width) {
    }

    @Override
    public boolean setSortValue(Comparable valueToSort) {
        return this._setSortValue(valueToSort);
    }

    @Override
    public boolean setSortValue(float valueToSort) {
        return this._setSortValue(Float.valueOf(valueToSort));
    }

    @Override
    public boolean setText(String text) {
        if (text != null && text.equals(this.text)) {
            return false;
        }
        this.text = text;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!FakeTableCell.this.isDisposed()) {
                    FakeTableCell.this.composite.redraw();
                }
            }
        });
        return true;
    }

    @Override
    public String getTextEquivalent() {
        return this.textEquiv;
    }

    @Override
    public void setTextEquivalent(String str) {
        this.textEquiv = str;
    }

    @Override
    public double getNumeric() {
        return this.numericValue;
    }

    @Override
    public void setNumeric(double d) {
        this.numericValue = d;
    }

    @Override
    public void setToolTip(Object tooltip) {
        this.tooltip = tooltip;
        this.updateTooltip();
    }

    @Override
    public void setDefaultToolTip(Object o) {
        this.default_tooltip = o;
    }

    @Override
    public Object getDefaultToolTip() {
        return this.default_tooltip;
    }

    private void updateTooltip() {
        if (this.cellArea != null) {
            return;
        }
        if (!this.isDisposed()) {
            Object target = this.tooltip == null ? this.default_tooltip : this.tooltip;
            Utils.setTT((Control)this.composite, target == null ? null : target.toString());
        }
    }

    private boolean _setSortValue(Comparable valueToSort) {
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (valueToSort instanceof Number && this.sortValue instanceof Number && this.sortValue.equals(valueToSort)) {
            return false;
        }
        this.sortValue = valueToSort;
        return true;
    }

    @Override
    public boolean setSortValue(long valueToSort) {
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(new Long(valueToSort));
    }

    public void doPaint(GC gc, Rectangle bounds) {
        if (this.isDisposed()) {
            return;
        }
        if (bounds == null) {
            return;
        }
        if (!bounds.intersects(gc.getClipping())) {
            return;
        }
        if (this.image != null && !this.image.isDisposed()) {
            int x;
            Point size = new Point(bounds.width, bounds.height);
            int y = this.marginHeight;
            y += (size.y - this.imageBounds.height) / 2;
            if (this.orientation == 0x1000000) {
                x = this.marginWidth;
                x += (size.x - this.marginWidth * 2 - this.imageBounds.width) / 2;
            } else {
                x = this.orientation == 131072 ? bounds.width - this.marginWidth - this.imageBounds.width : this.marginWidth;
            }
            int width = Math.min(bounds.width - x - this.marginWidth, this.imageBounds.width);
            int height = Math.min(bounds.height - y - this.marginHeight, this.imageBounds.height);
            if (width >= 0 && height >= 0) {
                gc.drawImage(this.image, 0, 0, width, height, bounds.x + x, bounds.y + y, width, height);
            }
        }
        if (this.text != null && this.text.length() > 0) {
            GCStringPrinter sp = new GCStringPrinter(gc, this.text, bounds, true, false, this.wrapText ? this.orientation | 0x40 : this.orientation);
            sp.printString();
            this.hadMore = sp.isCutoff();
        }
        this.invokeSWTPaintListeners(gc);
    }

    @Override
    public boolean refresh() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                boolean wasValid = FakeTableCell.this.valid;
                try {
                    FakeTableCell.this.tableColumn.invokeCellRefreshListeners(FakeTableCell.this, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (FakeTableCell.this.refreshListeners != null) {
                    int i = 0;
                    while (i < FakeTableCell.this.refreshListeners.size()) {
                        ((TableCellRefreshListener)FakeTableCell.this.refreshListeners.get(i)).refresh(FakeTableCell.this);
                        ++i;
                    }
                }
                if (!wasValid) {
                    FakeTableCell.this.valid = true;
                }
            }
        });
        return true;
    }

    public void setDataSource(Object _coreDataSource) {
        this.coreDataSource = _coreDataSource;
        if (_coreDataSource != null && !this.isDisposed()) {
            this.invokeVisibilityListeners(0, true);
        }
    }

    public void setControl(Composite composite) {
        this.setControl(composite, null, true);
    }

    public void setControl(Composite composite, Rectangle cellArea, boolean addListeners) {
        if (composite == null) {
            this.dispose();
            this.composite = null;
            return;
        }
        this.composite = composite;
        this.cellArea = cellArea;
        if (addListeners) {
            composite.addPaintListener((PaintListener)this);
            composite.addMouseListener((MouseListener)this);
            composite.addMouseMoveListener((MouseMoveListener)this);
            composite.addMouseTrackListener((MouseTrackListener)this);
        }
        this.setForeground(-1, -1, -1);
        this.setText(null);
        this.setToolTip(null);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FakeTableCell.this.dispose();
            }
        });
        if (this.coreDataSource != null && !this.isDisposed()) {
            this.invokeVisibilityListeners(0, true);
        }
    }

    public void paintControl(PaintEvent e) {
        this.doPaint(e.gc, this.cellArea == null ? this.composite.getClientArea() : this.cellArea);
    }

    public void mouseUp(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 1));
    }

    public void mouseDown(MouseEvent e) {
        try {
            if (this.composite == null || this.composite.getMenu() != null || this.cellMouseListeners != null && this.cellMouseListeners.size() > 0 || this.text == null || this.text.length() == 0) {
                return;
            }
            if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                return;
            }
            Menu menu = new Menu((Decorations)this.composite.getShell(), 8);
            MenuItem item = new MenuItem(menu, 0);
            item.setText(MessageText.getString("ConfigView.copy.to.clipboard.tooltip"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (!FakeTableCell.this.composite.isDisposed() && FakeTableCell.this.text != null && FakeTableCell.this.text.length() > 0) {
                        new Clipboard(FakeTableCell.this.composite.getDisplay()).setContents(new Object[]{FakeTableCell.this.text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
            });
            this.composite.setMenu(menu);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent arg0) {
                    if (!FakeTableCell.this.composite.isDisposed()) {
                        FakeTableCell.this.composite.setMenu(null);
                    }
                }
            });
            menu.setVisible(true);
        }
        finally {
            this.invokeMouseListeners(this.buildMouseEvent(e, 0));
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 2));
    }

    public void mouseMove(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 3));
    }

    public void mouseHover(MouseEvent e) {
        this.invokeToolTipListeners(0);
    }

    public void mouseExit(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 5));
    }

    public void mouseEnter(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 4));
    }

    protected TableCellMouseEvent buildMouseEvent(MouseEvent e, int eventType) {
        if (this.isDisposed()) {
            return null;
        }
        TableCellMouseEvent event2 = new TableCellMouseEvent(e);
        event2.cell = this;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.eventType = eventType;
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        event2.x = e.x - r.x;
        event2.y = e.y - r.y;
        return event2;
    }

    private void setOrientationViaColumn() {
        this.orientation = TableColumnSWTUtils.convertColumnAlignmentToSWT(this.tableColumn.getAlignment());
    }

    @Override
    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.removePaintListener((PaintListener)this);
            this.composite.removeMouseListener((MouseListener)this);
            this.composite.removeMouseMoveListener((MouseMoveListener)this);
            this.composite.removeMouseTrackListener((MouseTrackListener)this);
        }
        if (this.disposeListeners != null) {
            for (TableCellDisposeListener listener : this.disposeListeners) {
                try {
                    listener.dispose(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.disposeListeners = null;
        }
        this.tableColumn.invokeCellDisposeListeners(this);
        this.tableColumn.invalidateCells();
    }

    @Override
    public int getCursorID() {
        return 0;
    }

    @Override
    public String getObfuscatedText() {
        return this.text;
    }

    @Override
    public TableRowCore getTableRowCore() {
        return null;
    }

    @Override
    public boolean getVisuallyChangedSinceRefresh() {
        return true;
    }

    @Override
    public void invalidate(boolean mustRefresh) {
        this.valid = false;
    }

    @Override
    public void invokeToolTipListeners(int type) {
        if (this.tableColumn == null) {
            return;
        }
        this.tableColumn.invokeCellToolTipListeners(this, type);
        if (this.tooltipListeners == null) {
            return;
        }
        try {
            if (type == 0) {
                int i = 0;
                while (i < this.tooltipListeners.size()) {
                    ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.tooltipListeners.size()) {
                    ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void invokeVisibilityListeners(int visibility, boolean invokeColumnListeners) {
        if (invokeColumnListeners) {
            this.tableColumn.invokeCellVisibilityListeners(this, visibility);
        }
        if (this.cellVisibilityListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellVisibilityListeners.size()) {
            try {
                TableCellVisibilityListener l = (TableCellVisibilityListener)this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public boolean isMouseOver() {
        if (this.isDisposed()) {
            return false;
        }
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        Point ptStart = this.composite.toDisplay(r.x, r.y);
        r.x = ptStart.x;
        r.y = ptStart.y;
        Point ptCursor = this.composite.getDisplay().getCursorLocation();
        return r.contains(ptCursor);
    }

    @Override
    public void setMouseOver(boolean b) {
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    @Override
    public void locationChanged() {
    }

    @Override
    public boolean needsPainting() {
        return true;
    }

    @Override
    public boolean refresh(boolean doGraphics) {
        return this.refresh();
    }

    @Override
    public boolean refresh(boolean doGraphics, boolean rowVisible, boolean cellVisible) {
        return this.refresh();
    }

    @Override
    public boolean refresh(boolean doGraphics, boolean rowVisible) {
        return this.refresh();
    }

    @Override
    public boolean setCursorID(int cursorID) {
        return false;
    }

    @Override
    public void setUpToDate(boolean upToDate) {
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public void setOrentation(int o) {
        this.orientation = o;
    }

    public Rectangle getCellArea() {
        return this.cellArea;
    }

    public void setCellArea(Rectangle cellArea) {
        this.cellArea = cellArea;
    }

    @Override
    public int[] getMouseOffset() {
        if (this.isDisposed()) {
            return null;
        }
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        Point ptStart = this.composite.toDisplay(r.x, r.y);
        r.x = ptStart.x;
        r.y = ptStart.y;
        Point ptCursor = this.composite.getDisplay().getCursorLocation();
        if (!r.contains(ptCursor)) {
            return null;
        }
        return new int[]{ptCursor.x - r.x, ptCursor.y - r.y};
    }

    @Override
    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public int getMarginWidth() {
        return this.marginWidth;
    }

    @Override
    public void refreshAsync() {
        this.refresh();
    }

    @Override
    public void redraw() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!FakeTableCell.this.isDisposed()) {
                    FakeTableCell.this.composite.redraw();
                }
            }
        });
    }

    @Override
    public void doPaint(GC gc) {
        this.doPaint(gc, this.cellArea == null ? this.composite.getClientArea() : this.cellArea);
    }

    @Override
    public Image getBackgroundImage() {
        return null;
    }

    @Override
    public Color getBackgroundSWT() {
        return this.composite.getBackground();
    }

    @Override
    public Rectangle getBounds() {
        return this.cellArea == null ? this.composite.getClientArea() : new Rectangle(this.cellArea.x, this.cellArea.y, this.cellArea.width, this.cellArea.height);
    }

    @Override
    public Color getForegroundSWT() {
        return this.composite.getForeground();
    }

    @Override
    public Image getGraphicSWT() {
        return null;
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Point getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return new Point(bounds.width, bounds.height);
    }

    @Override
    public TableRowSWT getTableRowSWT() {
        return null;
    }

    @Override
    public int getTextAlpha() {
        return 0;
    }

    @Override
    public boolean setForeground(Color color) {
        return false;
    }

    @Override
    public boolean setGraphic(Image img) {
        this.graphic = null;
        this.image = img;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    @Override
    public boolean setIcon(Image img) {
        return false;
    }

    @Override
    public void setTextAlpha(int textOpacity) {
    }

    @Override
    public Rectangle getBoundsOnDisplay() {
        Rectangle bounds = this.getBounds();
        Point pt = this.composite.toDisplay(bounds.x, bounds.y);
        bounds.x = pt.x;
        bounds.y = pt.y;
        return bounds;
    }

    @Override
    public TableColumnCore getTableColumnCore() {
        return this.tableColumn;
    }

    @Override
    public boolean useSimpleSortValue() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(Object key) {
        FakeTableCell fakeTableCell = this;
        synchronized (fakeTableCell) {
            block4: {
                if (this.userData != null) break block4;
                return null;
            }
            return this.userData.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(Object key, Object data) {
        FakeTableCell fakeTableCell = this;
        synchronized (fakeTableCell) {
            if (this.userData == null) {
                if (data == null) {
                    return;
                }
                this.userData = new HashMap<Object, Object>();
            }
            if (data == null) {
                this.userData.remove(key);
                if (this.userData.isEmpty()) {
                    this.userData = null;
                }
            } else {
                this.userData.put(key, data);
            }
        }
    }
}

