/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuBuilder;
import com.biglybt.pif.ui.tables.TableCellMenuEvent;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableRowMouseEvent;
import com.biglybt.pif.ui.tables.TableRowMouseListener;
import com.biglybt.pifimpl.local.ui.menus.MenuItemImpl;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableGroupRowRunner;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.table.impl.TableContextMenuManager;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.SpeedScaleShell;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableRowSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableSelectedRowsListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTFilter;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableTooltips;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TableViewSWT_Common
implements MouseListener,
MouseMoveListener,
SelectionListener,
KeyListener,
MenuDetectListener {
    TableViewSWT<?> tv;
    private long lCancelSelectionTriggeredOn = -1L;
    private long lastSelectionTriggeredOn = -1L;
    private static final int ASYOUTYPE_UPDATEDELAY = 300;
    private List<TableViewSWTMenuFillListener> listenersMenuFill = new ArrayList<TableViewSWTMenuFillListener>(1);
    private List<KeyListener> listenersKey = new ArrayList<KeyListener>(1);
    private ArrayList<TableRowMouseListener> rowMouseListeners;
    private static AEMonitor mon_RowMouseListener = new AEMonitor("rml");
    private static AEMonitor mon_RowPaintListener = new AEMonitor("rpl");
    public int xAdj = 0;
    public int yAdj = 0;
    private ArrayList<TableRowSWTPaintListener> rowPaintListeners;
    long lastMouseDblClkEventTime = 0L;
    long lastMouseUpEventTime = 0L;
    Point lastMouseUpPos = new Point(0, 0);
    boolean mouseDown = false;
    TableRowSWT mouseDownOnRow = null;
    TableRowCore lastClickRow;
    TableCellCore lastCell = null;
    int lastCursorID = 0;

    public TableViewSWT_Common(TableViewSWT<?> tv) {
        this.tv = tv;
    }

    public void mouseDoubleClick(MouseEvent e) {
        TableCellMouseEvent event2;
        long time = (long)e.time & 0xFFFFFFFFL;
        long diff = time - this.lastMouseDblClkEventTime;
        if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L) {
            return;
        }
        this.lastMouseDblClkEventTime = time;
        TableColumnCore tc = this.tv.getTableColumnByOffset(e.x);
        TableCellCore cell = this.tv.getTableCell(e.x, e.y);
        if (cell != null && tc != null && (event2 = this.createMouseEvent(cell, e, 2, false)) != null) {
            tc.invokeCellMouseListeners(event2);
            cell.invokeMouseListeners(event2);
            if (event2.skipCoreFunctionality) {
                this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
            }
        }
    }

    public void menuDetected(MenuDetectEvent e) {
        Composite comp2 = this.tv.getTableComposite();
        Point mapped = comp2.getDisplay().map(null, (Control)comp2, new Point(e.x, e.y));
        TableColumnCore tc = this.tv.getTableColumnByOffset(mapped.x);
        TableCellCore cell = this.tv.getTableCell(mapped.x, mapped.y);
        if (tc != null && cell instanceof TableCellSWT) {
            TableCellMenuEvent event2 = new TableCellMenuEvent(cell, e);
            Rectangle clientArea = this.tv.getClientArea();
            event2.x = clientArea.x + mapped.x;
            event2.y = mapped.y;
            tc.invokeCellMenuListeners(event2);
            if (!event2.skipCoreFunctionality) {
                cell.invokeMenuListeners(event2);
            }
            if (event2.skipCoreFunctionality) {
                e.doit = false;
            }
        }
    }

    private boolean isInExpando(TableRowSWT row, TableCellCore cell, TableColumnCore tc, MouseEvent e) {
        String expando_column;
        Rectangle expando_rect;
        if (row != null && cell instanceof TableCellSWT && (expando_rect = (Rectangle)row.getData("expandoHitArea")) != null && (expando_column = (String)row.getData("expandoHitColumn")) != null && tc != null && expando_column.equals(tc.getName())) {
            Rectangle cell_bounds = ((TableCellSWT)cell).getBounds();
            expando_rect = new Rectangle(expando_rect.x + cell_bounds.x, expando_rect.y + cell_bounds.y, expando_rect.width, expando_rect.height);
            return expando_rect.contains(e.x, e.y);
        }
        return false;
    }

    public void mouseUp(MouseEvent e) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        TableColumnCore tc = this.tv.getTableColumnByOffset(e.x);
        TableCellCore cell = this.tv.getTableCell(e.x, e.y);
        boolean in_expando = this.isInExpando(this.mouseDownOnRow, cell, tc, e);
        if (in_expando) {
            TableCellMouseEvent event2 = this.createMouseEvent(cell, e, 1, false);
            if (event2 != null) {
                tc.invokeCellMouseListeners(event2);
                cell.invokeMouseListeners(event2);
            }
        } else {
            TableCellMouseEvent event3;
            this.mouseUp(this.mouseDownOnRow, cell, e.button, e.stateMask);
            if (e.button == 1) {
                long time = (long)e.time & 0xFFFFFFFFL;
                long diff = time - this.lastMouseUpEventTime;
                if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L && this.lastMouseUpPos.x == e.x && this.lastMouseUpPos.y == e.y) {
                    long now = System.currentTimeMillis();
                    if (time - this.lastMouseDblClkEventTime < 1000L && now - this.lCancelSelectionTriggeredOn < 1000L) {
                        this.lCancelSelectionTriggeredOn = now;
                    }
                    this.runDefaultAction(e.stateMask, 0);
                    return;
                }
                this.lastMouseUpEventTime = time;
                this.lastMouseUpPos = new Point(e.x, e.y);
            }
            if (cell != null && tc != null && (event3 = this.createMouseEvent(cell, e, 1, false)) != null) {
                tc.invokeCellMouseListeners(event3);
                cell.invokeMouseListeners(event3);
                if (event3.skipCoreFunctionality) {
                    this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        TableColumnCore tc;
        TableCellCore cell;
        this.mouseDown = true;
        this.mouseDownOnRow = this.tv.getTableRow(e.x, e.y, false);
        TableRowSWT row = this.mouseDownOnRow;
        boolean in_expando = this.isInExpando(row, cell, tc = (cell = this.tv.getTableCell(e.x, e.y)) == null ? null : cell.getTableColumnCore(), e);
        if (in_expando) {
            TableCellMouseEvent event2 = this.createMouseEvent(cell, e, 0, false);
            if (event2 != null) {
                tc.invokeCellMouseListeners(event2);
                cell.invokeMouseListeners(event2);
            }
        } else {
            TableRowMouseEvent event3;
            this.mouseDown(row, cell, e.button, e.stateMask);
            if (row == null) {
                this.tv.setSelectedRows(new TableRowCore[0]);
            }
            this.tv.editCell(null, -1);
            if (cell != null && tc != null) {
                TableCellMouseEvent event4 = this.createMouseEvent(cell, e, 0, false);
                if (event4 != null) {
                    tc.invokeCellMouseListeners(event4);
                    cell.invokeMouseListeners(event4);
                    this.tv.invokeRowMouseListener(event4);
                    if (event4.skipCoreFunctionality) {
                        this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
                if (tc.hasInplaceEditorListener() && e.button == 1 && this.lastClickRow == cell.getTableRowCore()) {
                    this.tv.editCell(this.tv.getTableColumnByOffset(e.x), cell.getTableRowCore().getIndex());
                }
                if (e.button == 1) {
                    this.lastClickRow = cell.getTableRowCore();
                }
            } else if (row != null && (event3 = this.createMouseEvent(row, e, 0, false)) != null) {
                this.tv.invokeRowMouseListener(event3);
            }
        }
    }

    public void mouseDown(TableRowSWT row, TableCellCore cell, int button, int stateMask) {
    }

    public void mouseUp(TableRowCore row, TableCellCore cell, int button, int stateMask) {
    }

    private TableCellMouseEvent createMouseEvent(TableCellCore cell, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent(e);
        event2.cell = cell;
        if (cell != null) {
            event2.row = cell.getTableRow();
        }
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (cell instanceof TableCellSWT) {
            Rectangle r = ((TableCellSWT)cell).getBounds();
            if (r == null) {
                return event2;
            }
            event2.x = e.x - r.x - this.xAdj;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y - this.yAdj;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    private TableRowMouseEvent createMouseEvent(TableRowSWT row, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent(e);
        event2.row = row;
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (row != null) {
            Rectangle r = row.getBounds();
            event2.x = e.x - r.x - this.xAdj;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y - this.yAdj;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    public void mouseMove(MouseEvent e) {
        this.lCancelSelectionTriggeredOn = -1L;
        if (this.tv.isDragging()) {
            return;
        }
        try {
            TableCellMouseEvent event2;
            TableCellCore cell = this.tv.getTableCell(e.x, e.y);
            if (cell != this.lastCell) {
                TableColumnCore tc;
                TableCellMouseEvent event3;
                if (this.lastCell != null && !this.lastCell.isDisposed() && (event3 = this.createMouseEvent(this.lastCell, e, 5, true)) != null) {
                    ((TableCellSWT)this.lastCell).setMouseOver(false);
                    tc = (TableColumnCore)this.lastCell.getTableColumn();
                    if (tc != null) {
                        tc.invokeCellMouseListeners(event3);
                    }
                    this.lastCell.invokeMouseListeners(event3);
                }
                if (cell != null && !cell.isDisposed() && (event3 = this.createMouseEvent(cell, e, 4, false)) != null) {
                    ((TableCellSWT)cell).setMouseOver(true);
                    tc = (TableColumnCore)cell.getTableColumn();
                    if (tc != null) {
                        tc.invokeCellMouseListeners(event3);
                    }
                    cell.invokeMouseListeners(event3);
                }
            }
            int iCursorID = 0;
            if (cell == null) {
                this.lastCell = null;
            } else if (cell == this.lastCell) {
                iCursorID = this.lastCursorID;
            } else {
                iCursorID = cell.getCursorID();
                this.lastCell = cell;
            }
            if (iCursorID < 0) {
                iCursorID = 0;
            }
            if (iCursorID != this.lastCursorID) {
                this.lastCursorID = iCursorID;
                if (iCursorID >= 0) {
                    this.tv.getComposite().setCursor(this.tv.getComposite().getDisplay().getSystemCursor(iCursorID));
                } else {
                    this.tv.getComposite().setCursor(null);
                }
            }
            if (cell != null && (event2 = this.createMouseEvent(cell, e, 3, false)) != null) {
                TableColumnCore tc = (TableColumnCore)cell.getTableColumn();
                if (tc != null && tc.hasCellMouseMoveListener()) {
                    ((TableColumnCore)cell.getTableColumn()).invokeCellMouseListeners(event2);
                }
                cell.invokeMouseListeners(event2);
                iCursorID = cell.getCursorID();
                if (iCursorID != this.lastCursorID) {
                    this.lastCursorID = iCursorID;
                    if (iCursorID >= 0) {
                        this.tv.getComposite().setCursor(this.tv.getComposite().getDisplay().getSystemCursor(iCursorID));
                    } else {
                        this.tv.getComposite().setCursor(null);
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.out(ex);
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lCancelSelectionTriggeredOn < 200L) {
            e.doit = false;
        } else {
            this.runDefaultAction(e.stateMask, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyPressed(KeyEvent event2) {
        block29: {
            block30: {
                KeyListener[] listeners;
                boolean inFilterBox;
                TableViewSWTFilter filter2 = this.tv.getSWTFilter();
                boolean bl = inFilterBox = filter2 != null && filter2.filterBox != null && filter2.filterBox.isOurWidget(event2.widget);
                if (inFilterBox && (event2.character == '\u007f' || event2.character == '\b')) {
                    this.handleSearchKeyPress(event2);
                    return;
                }
                KeyListener[] keyListenerArray = listeners = this.tv.getKeyListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyListener l = keyListenerArray[n2];
                    l.keyPressed(event2);
                    if (!event2.doit) {
                        this.lCancelSelectionTriggeredOn = SystemTime.getCurrentTime();
                        return;
                    }
                    ++n2;
                }
                if (event2.keyCode == 0x100000E) {
                    if ((event2.stateMask & 0x20000) != 0) {
                        this.tv.runForSelectedRows(new TableGroupRowRunner(){

                            @Override
                            public void run(TableRowCore row) {
                                row.invalidate();
                                row.refresh(true);
                            }
                        });
                    } else if ((event2.stateMask & 0x40000) != 0) {
                        this.tv.runForAllRows(new TableGroupRowRunner(){

                            @Override
                            public void run(TableRowCore row) {
                                row.invalidate();
                                row.refresh(true);
                            }
                        });
                    } else {
                        this.tv.sortRows(true, false);
                    }
                    event2.doit = false;
                    return;
                }
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (event2.stateMask == SWT.MOD1) {
                    switch (key) {
                        case 97: {
                            if (filter2 != null && inFilterBox || this.tv.isSingleSelection()) break;
                            this.tv.selectAll();
                            event2.doit = false;
                            break;
                        }
                        case 99: {
                            this.tv.clipboardSelected();
                            event2.doit = false;
                            break;
                        }
                        case 43: {
                            if (!Constants.isUnix) break;
                            this.tv.expandColumns();
                            event2.doit = false;
                            break;
                        }
                        case 102: {
                            this.tv.openFilterDialog();
                            event2.doit = false;
                            break;
                        }
                        case 103: {
                            System.out.println("force sort");
                            this.tv.resetLastSortedOn();
                            this.tv.sortRows(true, false);
                            break;
                        }
                        case 118: {
                            if (filter2 != null && inFilterBox) break;
                            Clipboard clipboard = new Clipboard(Display.getDefault());
                            try {
                                String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                                if (text == null) {
                                }
                                if (text.length() <= 2048) {
                                    TorrentOpener.openTorrentsFromClipboard(text);
                                }
                            }
                            finally {
                                clipboard.dispose();
                            }
                        }
                    }
                }
                if (event2.stateMask != 0) break block29;
                if (filter2 == null || !inFilterBox) break block30;
                if (event2.keyCode == 0x1000002) {
                    this.tv.requestFocus(2);
                    int rows = this.tv.getRowCount();
                    if (rows > 0) {
                        event2.doit = false;
                    }
                    break block29;
                } else if (event2.character == '\r') {
                    this.tv.refilter();
                }
                break block29;
            }
            if (event2.keyCode == 13 || event2.keyCode == 0x1000050) {
                this.runDefaultAction(0, 1);
                return;
            }
        }
        if (!event2.doit) {
            return;
        }
        this.handleSearchKeyPress(event2);
    }

    private void handleSearchKeyPress(KeyEvent e) {
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (filter2 == null || filter2.filterBox != null && filter2.filterBox.isOurWidget(e.widget)) {
            return;
        }
        String newText = null;
        if (e.keyCode == 8) {
            if (e.stateMask == 262144) {
                newText = "";
            } else if (filter2.nextText.length() > 0) {
                newText = filter2.nextText.substring(0, filter2.nextText.length() - 1);
            }
        } else if ((e.stateMask & 0xFFFDFFFF) == 0 && e.character > ' ' && e.character != '\u007f') {
            newText = String.valueOf(filter2.nextText) + String.valueOf(e.character);
        }
        if (newText == null) {
            return;
        }
        if (filter2.filterBox != null && !filter2.filterBox.isDisposed()) {
            filter2.filterBox.setFocus();
        }
        this.tv.setFilterText(newText, false);
        e.doit = false;
    }

    public void setFilterText(String s, final boolean force) {
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (filter2 == null) {
            return;
        }
        filter2.nextText = s;
        if (filter2.filterBox != null && !filter2.filterBox.isDisposed() && !filter2.nextText.equals(filter2.filterBox.getText())) {
            filter2.filterBox.setText(filter2.nextText);
            filter2.filterBox.setSelection(filter2.nextText.length());
        }
        if (filter2.eventUpdate != null) {
            filter2.eventUpdate.cancel();
        }
        filter2.eventUpdate = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(300L), new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                TableViewSWTFilter filter2 = TableViewSWT_Common.this.tv.getSWTFilter();
                if (filter2 == null) {
                    return;
                }
                if (filter2.eventUpdate == null || filter2.eventUpdate.isCancelled()) {
                    filter2.eventUpdate = null;
                    return;
                }
                filter2.eventUpdate = null;
                if (filter2.nextText != null && (force || !filter2.nextText.equals(filter2.text))) {
                    filter2.text = filter2.nextText;
                    filter2.checker.filterSet(filter2.text);
                    TableViewSWT_Common.this.tv.refilter();
                }
            }
        });
    }

    public void runDefaultAction(int stateMask, int origin) {
        if (this.lastSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lastSelectionTriggeredOn < 200L) {
            return;
        }
        if (System.currentTimeMillis() - this.lCancelSelectionTriggeredOn > 200L) {
            this.lastSelectionTriggeredOn = System.currentTimeMillis();
            TableRowCore[] selectedRows = this.tv.getSelectedRows();
            this.tv.triggerDefaultSelectedListeners(selectedRows, stateMask, origin);
        }
    }

    public void keyReleased(KeyEvent event2) {
        KeyListener[] listeners;
        KeyListener[] keyListenerArray = listeners = this.tv.getKeyListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener l = keyListenerArray[n2];
            l.keyReleased(event2);
            if (!event2.doit) {
                return;
            }
            ++n2;
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (this.listenersKey.contains(listener)) {
            return;
        }
        this.listenersKey.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.listenersKey.remove(listener);
    }

    public KeyListener[] getKeyListeners() {
        return this.listenersKey.toArray(new KeyListener[0]);
    }

    public void addRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                this.rowMouseListeners = new ArrayList(1);
            }
            this.rowMouseListeners.add(listener);
        }
        finally {
            mon_RowMouseListener.exit();
        }
    }

    public void removeRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                return;
            }
            this.rowMouseListeners.remove(listener);
        }
        finally {
            mon_RowMouseListener.exit();
        }
    }

    public void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.rowMouseListeners == null) {
            return;
        }
        ArrayList<TableRowMouseListener> listeners = new ArrayList<TableRowMouseListener>(this.rowMouseListeners);
        int i = 0;
        while (i < listeners.size()) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                this.rowPaintListeners = new ArrayList(1);
            }
            this.rowPaintListeners.add(listener);
        }
        finally {
            mon_RowPaintListener.exit();
        }
    }

    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                return;
            }
            this.rowPaintListeners.remove(listener);
        }
        finally {
            mon_RowPaintListener.exit();
        }
    }

    public void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.rowPaintListeners == null) {
            return;
        }
        ArrayList<TableRowSWTPaintListener> listeners = new ArrayList<TableRowSWTPaintListener>(this.rowPaintListeners);
        int i = 0;
        while (i < listeners.size()) {
            try {
                TableRowSWTPaintListener l = listeners.get(i);
                l.rowPaint(gc, row, column, cellArea);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void fillMenu(Menu menu, final TableColumnCore column) {
        boolean isDownloadContext;
        TableRowCore[] selectedRows;
        String columnName = column == null ? null : column.getName();
        Object[] listeners = this.listenersMenuFill.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
            l.fillMenu(columnName, menu);
            ++i;
        }
        boolean hasLevel1 = false;
        boolean hasLevel2 = false;
        TableRowCore[] tableRowCoreArray = selectedRows = this.tv.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (row.getParentRowCore() != null) {
                hasLevel2 = true;
            } else {
                hasLevel1 = true;
            }
            ++n2;
        }
        String tableID = this.tv.getTableID();
        String sMenuID = hasLevel1 ? tableID : "Files";
        com.biglybt.pif.ui.menus.MenuItem[] menu_items = null;
        if (Download.class.isAssignableFrom(this.tv.getDataSourceType()) && !hasLevel2) {
            menu_items = MenuItemManager.getInstance().getAllAsArray("download_context");
            isDownloadContext = true;
        } else {
            menu_items = MenuItemManager.getInstance().getAllAsArray((String)null);
            isDownloadContext = false;
        }
        if (columnName == null) {
            MenuItem itemChangeTable = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
            Utils.setMenuItemImage(itemChangeTable, "columns");
            itemChangeTable.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWT_Common.this.showColumnEditor(column);
                }
            });
        } else {
            MenuItem item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.toClipboard");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableRowCore[] rows;
                    String sToClipboard = "";
                    if (column == null) {
                        return;
                    }
                    String columnName = column.getName();
                    if (columnName == null) {
                        return;
                    }
                    TableRowCore[] tableRowCoreArray = rows = TableViewSWT_Common.this.tv.getSelectedRows();
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableCellCore cell;
                        TableRowCore row = tableRowCoreArray[n2];
                        if (row != rows[0]) {
                            sToClipboard = String.valueOf(sToClipboard) + "\n";
                        }
                        if ((cell = row.getTableCellCore(columnName)) != null) {
                            sToClipboard = String.valueOf(sToClipboard) + cell.getClipboardText();
                        }
                        ++n2;
                    }
                    if (sToClipboard.length() == 0) {
                        return;
                    }
                    new Clipboard(Display.getDefault()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
                }
            });
        }
        boolean enable_items = selectedRows.length > 0;
        com.biglybt.pif.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(Utils.getBaseViewID(sMenuID));
        if (items.length > 0 || menu_items.length > 0) {
            new MenuItem(menu, 2);
            if (menu_items != null) {
                Object[] target;
                if (isDownloadContext) {
                    Object[] dataSources = this.tv.getSelectedDataSources(false);
                    target = new Download[dataSources.length];
                    System.arraycopy(dataSources, 0, target, 0, target.length);
                } else {
                    target = selectedRows;
                }
                MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(target));
            }
            if (items.length > 0) {
                MenuBuildUtils.addPluginMenuItems(items, menu, true, enable_items, new MenuBuildUtils.PluginMenuController(){

                    @Override
                    public Listener makeSelectionListener(final com.biglybt.pif.ui.menus.MenuItem plugin_menu_item) {
                        return new TableSelectedRowsListener(TableViewSWT_Common.this.tv, false){

                            @Override
                            public boolean run(TableRowCore[] rows) {
                                if (rows.length != 0) {
                                    ((MenuItemImpl)plugin_menu_item).invokeListenersMulti(rows);
                                }
                                return true;
                            }
                        };
                    }

                    @Override
                    public void notifyFillListeners(com.biglybt.pif.ui.menus.MenuItem menu_item) {
                        ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TableViewSWT_Common.this.tv.getSelectedRows());
                    }

                    @Override
                    public void buildSubmenu(com.biglybt.pif.ui.menus.MenuItem parent) {
                        MenuBuilder submenuBuilder = ((MenuItemImpl)parent).getSubmenuBuilder();
                        if (submenuBuilder != null) {
                            try {
                                parent.removeAllChildItems();
                                submenuBuilder.buildSubmenu(parent, TableViewSWT_Common.this.tv.getSelectedRows());
                            }
                            catch (Throwable t) {
                                Debug.out(t);
                            }
                        }
                    }

                    @Override
                    public void buildStarts(Menu menu) {
                    }

                    @Override
                    public void buildComplete(Menu menu) {
                    }
                });
            }
        }
        if (hasLevel1) {
            com.biglybt.pif.ui.menus.MenuItem[] columnItems;
            if (column != null && (columnItems = column.getContextMenuItems(2)).length > 0) {
                new MenuItem(menu, 2);
                MenuBuildUtils.addPluginMenuItems(columnItems, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.tv.getSelectedDataSources(true)));
            }
            MenuItem itemSelectAll = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemSelectAll, "Button.selectAll");
            itemSelectAll.addListener(13, ev -> this.tv.selectAll());
            if (this.tv.getSWTFilter() != null) {
                MenuItem itemFilter = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemFilter, "MyTorrentsView.menu.filter");
                itemFilter.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TableViewSWT_Common.this.tv.openFilterDialog();
                    }
                });
            }
            MenuItem itemChangeTable = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
            Utils.setMenuItemImage(itemChangeTable, "columns");
            itemChangeTable.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWT_Common.this.showColumnEditor(column);
                }
            });
        }
    }

    public void showColumnEditor(TableColumnCore column) {
        TableRowCore focusedRow = this.tv.getFocusedRow();
        if (focusedRow == null || focusedRow.isRowDisposed()) {
            focusedRow = this.tv.getRow(0);
        }
        String tableID = this.tv.getTableID();
        new TableColumnSetupWindow(this.tv.getDataSourceType(), tableID, column, focusedRow, TableStructureEventDispatcher.getInstance(tableID)).open();
    }

    public void fillColumnMenu(Menu menu, final TableColumnCore column, boolean isBlankArea) {
        if (column != null) {
            com.biglybt.pif.ui.menus.MenuItem[] items;
            String sColumnName = column.getName();
            if (sColumnName != null) {
                Object[] listeners = this.listenersMenuFill.toArray();
                int i = 0;
                while (i < listeners.length) {
                    TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
                    l.addThisColumnSubMenu(sColumnName, menu);
                    ++i;
                }
            }
            if ((items = column.getContextMenuItems(1)).length > 0) {
                MenuBuildUtils.addSeparator(menu);
                MenuBuildUtils.addPluginMenuItems(items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.tv.getSelectedDataSources(true)));
            }
            MenuBuildUtils.addSeparator(menu);
            TableColumnCore[] sortColumns = this.tv.getSortColumns();
            boolean columnIsSort = false;
            TableColumnCore[] tableColumnCoreArray = sortColumns;
            int n = sortColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnCore sortColumn = tableColumnCoreArray[n2];
                if (sortColumn == column) {
                    columnIsSort = true;
                    break;
                }
                ++n2;
            }
            MenuItem menuSortByColumn = new MenuItem(menu, 8);
            if (columnIsSort) {
                Messages.setLanguageText((Widget)menuSortByColumn, "TableColumn.sort.reverse");
                menuSortByColumn.addListener(13, e -> {
                    TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                    this.tv.addSortColumn(tcc);
                });
                if (sortColumns.length > 1) {
                    MenuItem menuRemoveSort = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)menuRemoveSort, "TableColumn.sort.remove");
                    menuRemoveSort.addListener(13, e -> {
                        TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                        ArrayList<TableColumnCore> list = new ArrayList<TableColumnCore>(Arrays.asList(this.tv.getSortColumns()));
                        list.remove(tcc);
                        this.tv.setSortColumns(list.toArray(new TableColumnCore[0]), false);
                    });
                }
            } else {
                Messages.setLanguageText((Widget)menuSortByColumn, "TableColumn.sort.bythiscolumn");
                menuSortByColumn.addListener(13, e -> {
                    TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                    this.tv.setSortColumns(new TableColumnCore[]{tcc}, true);
                });
                MenuItem menuSortAddColumn = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)menuSortAddColumn, "TableColumn.sort.addcolumn");
                menuSortAddColumn.addListener(13, e -> {
                    TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                    this.tv.addSortColumn(tcc);
                });
            }
            new MenuItem(menu, 2);
            if (TableTooltips.tooltips_disabled) {
                MenuItem at_item = new MenuItem(menu, 32);
                Messages.setLanguageText((Widget)at_item, "MyTorrentsView.menu.thisColumn.autoTooltip");
                at_item.addListener(13, e -> {
                    TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                    tcc.setAutoTooltip(at_item.getSelection());
                    tcc.invalidateCells();
                });
                at_item.setSelection(column.doesAutoTooltip());
            }
            MenuItem renameColumn = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)renameColumn, "MyTorrentsView.menu.renameColumn");
            renameColumn.addListener(13, e -> {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("ColumnRenameWindow.title", "ColumnRenameWindow.message");
                String existing_name = column.getNameOverride();
                if (existing_name == null) {
                    existing_name = "";
                }
                entryWindow.setPreenteredText(existing_name, false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt(ew -> {
                    if (!ew.hasSubmittedInput()) {
                        return;
                    }
                    String name = ew.getSubmittedInput().trim();
                    if (name.length() == 0) {
                        name = null;
                    }
                    column.setNameOverride(name);
                    TableColumnManager tcm = TableColumnManager.getInstance();
                    String tableID = this.tv.getTableID();
                    tcm.saveTableColumns(this.tv.getDataSourceType(), tableID);
                    TableStructureEventDispatcher.getInstance(tableID).tableStructureChanged(true, null);
                });
            });
            MenuItem itemPrefSize = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPrefSize, "table.columns.pref.size");
            itemPrefSize.addListener(13, e -> {
                boolean bl = Utils.execSWTThread(() -> {
                    column.setPreferredWidth(-1);
                    this.tv.runForAllRows(new TableGroupRowRunner(){

                        @Override
                        public void run(TableRowCore row) {
                            row.fakeRedraw(column.getName());
                        }
                    });
                    int pref = column.getPreferredWidth();
                    if (pref != -1) {
                        column.setWidth(pref);
                    }
                });
            });
            new MenuItem(menu, 2);
            MenuItem menuHideColumn = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)menuHideColumn, "TableColumn.hide");
            menuHideColumn.addListener(13, e -> TableColumnSWTUtils.changeColumnVisiblity(this.tv, column, false));
        }
        MenuItem itemResetColumns = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemResetColumns, "table.columns.reset");
        itemResetColumns.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MessageBoxShell mb = new MessageBoxShell(MessageText.getString("table.columns.reset.dialog.title"), MessageText.getString("table.columns.reset.dialog.text"), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (result == 0) {
                            String tableID = (this).TableViewSWT_Common.this.tv.getTableID();
                            TableColumnManager tcm = TableColumnManager.getInstance();
                            tcm.resetColumns((this).TableViewSWT_Common.this.tv.getDataSourceType(), tableID);
                        }
                    }
                });
            }
        });
        MenuItem itemChangeTable = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        Utils.setMenuItemImage(itemChangeTable, "columns");
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWT_Common.this.showColumnEditor(column);
            }
        });
        menu.setData("column", (Object)column);
        new MenuItem(menu, 2);
        MenuItem itemSetRowHeight = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemSetRowHeight, "Table.menu.set.height");
        itemSetRowHeight.addListener(13, event2 -> this.showRowHeightDialog());
    }

    private void showRowHeightDialog() {
        int originalHeight = this.tv.getRowDefaultHeight();
        SpeedScaleShell optionShell = new SpeedScaleShell(){

            @Override
            public void setValue(int value) {
                super.setValue(value);
                Utils.execSWTThreadLater(100, () -> TableViewSWT_Common.this.tv.setRowHeight(this.getValue()));
            }

            @Override
            public String getStringValue(int value, String sValue) {
                if (sValue != null) {
                    return sValue;
                }
                return value + " px";
            }
        };
        optionShell.setMinValue(this.tv.getRowMinHeight());
        int lineHeight = this.tv.getLineHeight();
        optionShell.setMaxValue(lineHeight * 8 + 2);
        int i = 1;
        while (i < 5) {
            optionShell.addOption(i == 1 ? MessageText.getString("Table.line.one") : MessageText.getString("Table.line.many", new String[]{String.valueOf(i)}), i * lineHeight + 2);
            ++i;
        }
        if (optionShell.open(null, this.tv.getRowDefaultHeight(), false)) {
            this.tv.setRowHeight(optionShell.getValue());
        } else {
            this.tv.setRowHeight(originalHeight);
        }
    }

    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.listenersMenuFill.add(l);
    }
}

