/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.painted;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class TablePaintedUtils {
    private static boolean is_dark = false;

    static {
        COConfigurationManager.addAndFireParameterListener("Dark Table Colors", new ParameterListener(){
            boolean first = true;

            @Override
            public void parameterChanged(String parameterName) {
                is_dark = Utils.isDarkAppearanceNativeWindows() || COConfigurationManager.getBooleanParameter("Dark Table Colors");
                if (this.first) {
                    this.first = false;
                } else {
                    Colors.getInstance().allocateColorAltRow();
                }
            }
        });
    }

    public static boolean isDark() {
        return is_dark;
    }

    protected static Color getColour(GC gc, int type) {
        return TablePaintedUtils.getColour(gc.getDevice(), type);
    }

    public static Color getColour(Device device, int type) {
        if (Utils.isDarkAppearanceNativeWindows()) {
            return Colors.getSystemColor(device, type);
        }
        if (is_dark) {
            switch (type) {
                case 25: {
                    return Colors.black;
                }
                case 24: {
                    return Colors.white;
                }
                case 26: {
                    return Colors.dark_grey;
                }
                case 27: {
                    return Colors.white;
                }
                case 18: {
                    return Colors.grey;
                }
                case 19: {
                    return Colors.black;
                }
                case 22: {
                    return Colors.dark_grey;
                }
            }
            Debug.out("Unhandled colour: " + type);
        }
        return device.getSystemColor(type);
    }
}

