/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.painted;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.tables.TableRowMouseEvent;
import com.biglybt.pif.ui.tables.TableRowMouseListener;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableGroupRowVisibilityRunner;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewCreator;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.table.impl.TableViewImpl;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextWithHistory;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableRowSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTFilter;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.TableViewSWTPanelCreator;
import com.biglybt.ui.swt.views.table.impl.TableTooltips;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_Common;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.ui.swt.views.table.painted.TableCellPainted;
import com.biglybt.ui.swt.views.table.painted.TableColumnPainted;
import com.biglybt.ui.swt.views.table.painted.TableHeaderPainted;
import com.biglybt.ui.swt.views.table.painted.TablePaintedUtils;
import com.biglybt.ui.swt.views.table.painted.TableRowPainted;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableViewPainted
extends TableViewImpl<Object>
implements ParameterListener,
TableViewSWT<Object>,
ObfuscateImage,
MessageText.MessageTextListener,
BubbleTextBox.BubbleTextBoxChangeListener {
    private static final boolean hasGetScrollBarMode = SWT.getVersion() >= 3821;
    private static final boolean DEBUG_ROWCHANGE = false;
    private static final boolean DEBUG_WITH_SHELL = false;
    public static final boolean DIRECT_DRAW = (Constants.isOSX || Constants.isUnix) && Utils.getDeviceZoom() != 100;
    private static final boolean DEBUG_REDRAW_CLIP = false;
    private static final boolean expand_enabled_default = COConfigurationManager.getBooleanParameter("Table.useTree");
    public static final String MENUKEY_IN_BLANK_AREA = "inBlankArea";
    public static final String MENUKEY_IS_HEADER = "isHeader";
    public static final String MENUKEY_COLUMN = "column";
    private Composite cTable;
    private int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    protected boolean extendedErase = configMan.getBooleanParameter("Table.extendedErase");
    private int defaultRowHeight = 17;
    private int lineHeight;
    protected float iHeightEM = -1.0f;
    LinkedHashSet<TableRowPainted> visibleRows = new LinkedHashSet();
    private final Object visibleRows_sync;
    protected Rectangle clientArea;
    private boolean isVisible;
    private Shell shell;
    private Color colorLine;
    private Image canvasImage;
    private final String sDefaultSortOn;
    private TableViewSWT_Common tvSWTCommon;
    private TableViewSWT_TabsCommon tvTabsCommon;
    private TableViewSWTPanelCreator mainPanelCreator;
    private boolean isMultiSelect;
    private int columnsWidth;
    private Menu menu;
    private TableRowPainted focusedRow;
    private boolean enableTabViews = true;
    private boolean tabViewsExpandedByDefault = true;
    protected boolean isDragging;
    private Composite mainComposite;
    private Object heightChangeSync = new Object();
    private int totalHeight = 0;
    private boolean redrawTableScheduled;
    private int redrawTableDisabled;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private Canvas sCanvasImage;
    private boolean filterSubRows;
    private boolean expandEnabled = expand_enabled_default;
    private AtomicInteger mutationCount = new AtomicInteger(0);
    private volatile int lastMC = -1;
    private TableHeaderPainted header;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private boolean destroying;
    private int rowMinHeight;
    private RefreshTableRunnable refreshTableRunnable = new RefreshTableRunnable();
    private FrequencyLimitedDispatcher refresh_dispatcher = new FrequencyLimitedDispatcher(this.refreshTableRunnable, 250);
    private FrequencyLimitedDispatcher redraw_dispatcher;
    protected boolean isFocused;
    FrequencyLimitedDispatcher vbarDispatcher;
    private Map<TableColumnCore, TableColumnPainted> paintedColumns;
    private boolean in_swt_updateCanvasImage;
    boolean qdRowHeightChanged;
    private List<TableRowPainted> pending_rows;

    public TableViewPainted(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        super(pluginDataSourceType, _sTableID, _sPropertiesPrefix, new Object(), _basicItems);
        this.refresh_dispatcher.setSingleThreaded();
        this.redraw_dispatcher = new FrequencyLimitedDispatcher(new RedrawTableRunnable(), 250);
        this.redraw_dispatcher.setSingleThreaded();
        this.vbarDispatcher = new FrequencyLimitedDispatcher(AERunnable.create(() -> Utils.execSWTThread(() -> {
            if (this.cTable == null || this.cTable.isDisposed()) {
                return;
            }
            this.swt_calculateClientArea();
            this.cTable.update();
        })), 100);
        this.paintedColumns = new HashMap<TableColumnCore, TableColumnPainted>();
        this.in_swt_updateCanvasImage = false;
        this.qdRowHeightChanged = false;
        this.pending_rows = new ArrayList<TableRowPainted>();
        this.visibleRows_sync = this.getRowsSync();
        this.sDefaultSortOn = _sDefaultSortOn;
        this.isMultiSelect = (_iTableStyle & 2) != 0;
        this.tvSWTCommon = new TableViewSWT_Common(this){

            @Override
            public void widgetSelected(SelectionEvent event2) {
            }

            @Override
            public void mouseUp(TableRowCore clickedRow, TableCellCore cell, int button, int stateMask) {
                super.mouseUp(clickedRow, cell, button, stateMask);
                if (clickedRow == null) {
                    return;
                }
                if (button == 1) {
                    int keyboardModifier = stateMask & SWT.MODIFIER_MASK;
                    if ((keyboardModifier & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(clickedRow);
                        return;
                    }
                    if (keyboardModifier == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                        return;
                    }
                }
            }

            @Override
            public void mouseDown(TableRowSWT clickedRow, TableCellCore cell, int button, int stateMask) {
                if (clickedRow == null) {
                    return;
                }
                int keyboardModifier = stateMask & SWT.MODIFIER_MASK;
                if (button == 1) {
                    if ((keyboardModifier & SWT.MOD1) != 0) {
                        TableViewPainted.this.setRowSelected(clickedRow, !clickedRow.isSelected(), true);
                        return;
                    }
                } else if (button == 3 && !TableViewPainted.this.isSelected(clickedRow) && keyboardModifier == 0) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                }
                if (TableViewPainted.this.getSelectedRowsSize() == 0) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{clickedRow});
                }
            }

            @Override
            public void keyPressed(KeyEvent event2) {
                TableViewSWTFilter<?> filter2;
                if (event2.keyCode == 27 && (filter2 = TableViewPainted.this.getSWTFilter()) != null && filter2.filterBox != null) {
                    filter2.filterBox.setText("");
                }
                if (TableViewPainted.this.getComposite().isDisposed()) {
                    return;
                }
                if (TableViewPainted.this.getComposite() != event2.widget) {
                    if (TableViewPainted.this.getComposite().isVisible()) {
                        super.keyPressed(event2);
                    }
                    return;
                }
                boolean updateTable = false;
                if (event2.keyCode == 0x1000001) {
                    TableRowCore rowToSelect = TableViewPainted.this.getPreviousRow(TableViewPainted.this.focusedRow);
                    if ((event2.stateMask & 0x20000) != 0) {
                        if (rowToSelect != null && TableViewPainted.this.focusedRow != null) {
                            boolean select;
                            TableRowCore[] selectedRows = TableViewPainted.this.getSelectedRows();
                            TableViewPainted.this.sortRowsByVisibilityIndex(selectedRows);
                            boolean bl = select = selectedRows.length == 0 || selectedRows[0] == TableViewPainted.this.focusedRow;
                            if (select) {
                                rowToSelect.setSelected(select);
                            } else {
                                TableRowPainted rowToUnSelect = TableViewPainted.this.focusedRow;
                                TableViewPainted.this.setFocusedRow(rowToSelect);
                                rowToUnSelect.setSelected(false);
                            }
                            updateTable = true;
                        }
                    } else if ((event2.stateMask & 0x40000) != 0) {
                        TableRowPainted firstRow = (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                        if (firstRow != null) {
                            int hChange = 0;
                            if (TableViewPainted.this.isRowPartiallyVisible(firstRow)) {
                                hChange = firstRow.getDrawOffset().y - TableViewPainted.this.clientArea.y;
                            } else {
                                TableRowCore prevRow = TableViewPainted.this.getPreviousRow(firstRow);
                                if (prevRow != firstRow && prevRow != null) {
                                    hChange = -prevRow.getHeight();
                                }
                            }
                            TableViewPainted.this.vBar.setSelection(TableViewPainted.this.vBar.getSelection() + hChange);
                            TableViewPainted.this.swt_vBarChanged();
                        }
                    } else {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{rowToSelect});
                        updateTable = true;
                    }
                } else if (event2.keyCode == 0x1000005) {
                    TableRowCore row = TableViewPainted.this.focusedRow;
                    TableRowPainted lastRow = TableViewPainted.this.getLastVisibleRow();
                    int y = lastRow == null ? 0 : TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height - lastRow.getDrawOffset().y;
                    while (row != null && y < TableViewPainted.this.clientArea.height) {
                        y += row.getHeight();
                        row = TableViewPainted.this.getPreviousRow(row);
                    }
                    if (row == null) {
                        row = TableViewPainted.this.getRow(0);
                    }
                    if ((event2.stateMask & 0x20000) != 0) {
                        if (row != null) {
                            TableViewPainted.this.selectRowsTo(row);
                        }
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000007) {
                    if ((event2.stateMask & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(TableViewPainted.this.getRow(0));
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{TableViewPainted.this.getRow(0)});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000002) {
                    if ((event2.stateMask & 0x40000) != 0) {
                        TableRowPainted firstRow = (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                        if (firstRow != null) {
                            int hChange = 0;
                            hChange = TableViewPainted.this.isRowPartiallyVisible(firstRow) ? firstRow.getHeight() + (firstRow.getDrawOffset().y - TableViewPainted.this.clientArea.y) : firstRow.getHeight();
                            TableViewPainted.this.vBar.setSelection(TableViewPainted.this.vBar.getSelection() + hChange);
                            TableViewPainted.this.swt_vBarChanged();
                        }
                    } else {
                        TableRowCore rowToSelect = TableViewPainted.this.getNextRow(TableViewPainted.this.focusedRow);
                        if (rowToSelect != null) {
                            if ((event2.stateMask & 0x20000) != 0) {
                                boolean select;
                                TableRowCore[] selectedRows = TableViewPainted.this.getSelectedRows();
                                TableViewPainted.this.sortRowsByVisibilityIndex(selectedRows);
                                boolean bl = select = selectedRows.length == 0 || selectedRows[selectedRows.length - 1] == TableViewPainted.this.focusedRow;
                                if (select) {
                                    rowToSelect.setSelected(select);
                                } else {
                                    TableRowPainted rowToUnSelect = TableViewPainted.this.focusedRow;
                                    TableViewPainted.this.setFocusedRow(rowToSelect);
                                    rowToUnSelect.setSelected(false);
                                }
                            } else {
                                TableViewPainted.this.setSelectedRows(new TableRowCore[]{rowToSelect});
                            }
                            updateTable = true;
                        }
                    }
                } else if (event2.keyCode == 0x1000006) {
                    TableRowCore row = TableViewPainted.this.focusedRow;
                    TableRowPainted firstRow = TableViewPainted.this.visibleRows.size() == 0 ? null : (TableRowPainted)TableViewPainted.this.visibleRows.iterator().next();
                    int y = firstRow == null ? 0 : firstRow.getHeight() - (TableViewPainted.this.clientArea.y - firstRow.getDrawOffset().y);
                    while (row != null && y < TableViewPainted.this.clientArea.height) {
                        y += row.getHeight();
                        TableRowCore nextRow = TableViewPainted.this.getNextRow(row);
                        if (nextRow == null) break;
                        row = nextRow;
                    }
                    if ((event2.stateMask & 0x20000) != 0) {
                        TableViewPainted.this.selectRowsTo(row);
                    } else if (event2.stateMask == 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                    }
                    updateTable = true;
                } else if (event2.keyCode == 0x1000008) {
                    TableRowCore[] rows = TableViewPainted.this.getRowsAndSubRows(false);
                    if (rows.length > 0) {
                        TableRowCore lastRow = rows[rows.length - 1];
                        if ((event2.stateMask & 0x20000) != 0) {
                            TableViewPainted.this.selectRowsTo(lastRow);
                        } else if (event2.stateMask == 0) {
                            TableViewPainted.this.setSelectedRows(new TableRowCore[]{lastRow});
                        }
                        updateTable = true;
                    }
                } else if (event2.keyCode == 0x1000004 && event2.stateMask == 0) {
                    if (event2.stateMask == 0 && TableViewPainted.this.focusedRow != null && !TableViewPainted.this.focusedRow.isExpanded() && TableViewPainted.this.canHaveSubItems()) {
                        TableViewPainted.this.focusedRow.setExpanded(true);
                    } else if (TableViewPainted.this.hBar.isEnabled()) {
                        TableViewPainted.this.hBar.setSelection(TableViewPainted.this.hBar.getSelection() + 50);
                        TableViewPainted.this.cTable.redraw();
                        updateTable = true;
                    }
                } else if (event2.keyCode == 0x1000003 && event2.stateMask == 0) {
                    if (event2.stateMask == 0 && TableViewPainted.this.focusedRow != null && TableViewPainted.this.focusedRow.isExpanded() && TableViewPainted.this.canHaveSubItems()) {
                        TableViewPainted.this.focusedRow.setExpanded(false);
                    } else if (TableViewPainted.this.hBar.isEnabled()) {
                        TableViewPainted.this.hBar.setSelection(TableViewPainted.this.hBar.getSelection() - 50);
                        TableViewPainted.this.cTable.redraw();
                        updateTable = true;
                    }
                }
                if (updateTable) {
                    TableViewPainted.this.cTable.update();
                }
                super.keyPressed(event2);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TableViewPainted.this.swt_calculateClientArea();
                TableViewPainted.this.visibleRowsChanged();
                super.keyReleased(e);
            }
        };
    }

    private void sortRowsByVisibilityIndex(TableRowCore[] selectedRows) {
        Arrays.sort(selectedRows, new Comparator<TableRowCore>(){

            @Override
            public int compare(TableRowCore o1, TableRowCore o2) {
                return o1.getVisibleRowIndex() - o2.getVisibleRowIndex();
            }
        });
    }

    protected boolean isRowPartiallyVisible(TableRowPainted row) {
        if (row == null) {
            return false;
        }
        Point drawOffset = row.getDrawOffset();
        int height = row.getHeight();
        return drawOffset.y < this.clientArea.y && drawOffset.y + height > this.clientArea.y || drawOffset.y < this.clientArea.y + this.clientArea.height && drawOffset.y + height > this.clientArea.y + this.clientArea.height;
    }

    protected void selectRowsTo(TableRowCore clickedRow) {
        ArrayList<TableRowCore> rowsToSelect;
        TableRowCore firstRow;
        if (!this.isMultiSelect) {
            this.setSelectedRows(new TableRowCore[]{clickedRow});
            return;
        }
        TableRowCore[] selectedRows = this.getSelectedRows();
        TableRowCore tableRowCore = firstRow = selectedRows.length > 0 ? selectedRows[0] : this.getRow(0);
        if (this.getFilterSubRows()) {
            boolean reverse;
            TableRowCore[] rows = this.getRowsAndSubRows(false);
            int startPos = -1;
            int endPos = -1;
            int i = 0;
            while (i < rows.length) {
                TableRowCore row = rows[i];
                if (row == firstRow) {
                    startPos = i;
                }
                if (row == clickedRow) {
                    endPos = i;
                }
                ++i;
            }
            if (startPos == -1 || endPos == -1) {
                return;
            }
            boolean bl = reverse = endPos < startPos;
            if (reverse) {
                int temp = endPos;
                endPos = startPos;
                startPos = temp;
            }
            rowsToSelect = new ArrayList(endPos - startPos + 1);
            int i2 = startPos;
            while (i2 <= endPos) {
                rowsToSelect.add(rows[i2]);
                ++i2;
            }
            if (reverse) {
                Collections.reverse(rowsToSelect);
            }
        } else {
            TableRowCore newRow;
            int endPos;
            int startPos;
            TableRowCore parentFirstRow = firstRow;
            while (parentFirstRow.getParentRowCore() != null) {
                parentFirstRow = parentFirstRow.getParentRowCore();
            }
            TableRowCore parentClickedRow = clickedRow;
            while (parentClickedRow.getParentRowCore() != null) {
                parentClickedRow = parentClickedRow.getParentRowCore();
            }
            if (parentFirstRow == parentClickedRow) {
                startPos = parentFirstRow == firstRow ? -1 : firstRow.getIndex();
                endPos = parentClickedRow == clickedRow ? -1 : clickedRow.getIndex();
            } else {
                startPos = this.indexOf(parentFirstRow);
                endPos = this.indexOf(parentClickedRow);
                if (endPos == -1 || startPos == -1) {
                    return;
                }
            }
            rowsToSelect = new ArrayList<TableRowCore>(Arrays.asList(selectedRows));
            TableRowCore curRow = firstRow;
            int maxToDo = this.getRowAndSubRowCount()[1];
            do {
                if (!rowsToSelect.contains(curRow)) {
                    rowsToSelect.add(curRow);
                }
                TableRowCore tableRowCore2 = newRow = startPos < endPos ? this.getNextRow(curRow) : this.getPreviousRow(curRow);
            } while (newRow != curRow && (curRow = newRow) != clickedRow && curRow != null && maxToDo-- > 0);
            if (curRow != null && !rowsToSelect.contains(curRow)) {
                rowsToSelect.add(curRow);
            }
        }
        this.setSelectedRows(rowsToSelect.toArray(new TableRowCore[0]));
        this.setFocusedRow(clickedRow);
    }

    protected TableRowCore getPreviousRow(TableRowCore relativeToRow) {
        int index;
        TableRowCore row;
        if (relativeToRow == null) {
            return this.getRow(0);
        }
        if (this.getFilterSubRows()) {
            TableRowCore[] rows = this.getRowsAndSubRows(false);
            int i = rows.length - 1;
            while (i > 0) {
                if (rows[i] == relativeToRow) {
                    return rows[i - 1];
                }
                --i;
            }
            return this.getRow(0);
        }
        TableRowCore rowToSelect = null;
        TableRowCore parentRow = relativeToRow.getParentRowCore();
        rowToSelect = parentRow == null ? ((row = this.getRow(this.indexOf(relativeToRow) - 1)) != null && row.isExpanded() && row.getSubItemCount() > 0 ? row.getSubRow(row.getSubItemCount() - 1) : row) : ((index = relativeToRow.getIndex()) > 0 ? parentRow.getSubRow(index - 1) : parentRow);
        if (rowToSelect == null) {
            return this.getRow(0);
        }
        return rowToSelect;
    }

    protected TableRowCore getNextRow(TableRowCore relativeToRow) {
        if (relativeToRow == null) {
            return this.getRow(0);
        }
        if (this.getFilterSubRows()) {
            TableRowCore[] rows = this.getRowsAndSubRows(false);
            int i = 0;
            while (i < rows.length - 1) {
                if (rows[i] == relativeToRow) {
                    TableRowCore next = rows[i + 1];
                    return next;
                }
                ++i;
            }
            return rows[rows.length - 1];
        }
        TableRowCore rowToSelect = null;
        if (relativeToRow.isExpanded() && relativeToRow.getSubItemCount() > 0) {
            TableRowCore[] subRowsWithNull;
            TableRowCore[] tableRowCoreArray = subRowsWithNull = relativeToRow.getSubRowsWithNull();
            int n = subRowsWithNull.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                if (row != null) {
                    rowToSelect = row;
                    break;
                }
                ++n2;
            }
            if (rowToSelect == null) {
                rowToSelect = this.getRow(relativeToRow.getIndex() + 1);
            }
        } else {
            TableRowCore parentRow = relativeToRow.getParentRowCore();
            if (parentRow != null) {
                rowToSelect = parentRow.getSubRow(relativeToRow.getIndex() + 1);
                if (rowToSelect == null) {
                    rowToSelect = this.getRow(parentRow.getIndex() + 1);
                }
            } else {
                rowToSelect = this.getRow(relativeToRow.getIndex() + 1);
            }
        }
        return rowToSelect;
    }

    @Override
    public void clipboardSelected() {
        TableRowCore[] rows;
        String sToClipboard = "";
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        int j = 0;
        while (j < visibleColumns.length) {
            if (j != 0) {
                sToClipboard = String.valueOf(sToClipboard) + "\t";
            }
            String title = MessageText.getString(visibleColumns[j].getTitleLanguageKey());
            sToClipboard = String.valueOf(sToClipboard) + title;
            ++j;
        }
        TableRowCore[] tableRowCoreArray = rows = this.getSelectedRows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            sToClipboard = String.valueOf(sToClipboard) + "\n";
            TableRowPainted p_row = (TableRowPainted)row;
            p_row.setShown(true, true);
            p_row.refresh(true, true);
            int j2 = 0;
            while (j2 < visibleColumns.length) {
                TableCellCore cell;
                TableColumnCore column = visibleColumns[j2];
                if (j2 != 0) {
                    sToClipboard = String.valueOf(sToClipboard) + "\t";
                }
                if ((cell = row.getTableCellCore(column.getName())) != null) {
                    sToClipboard = String.valueOf(sToClipboard) + cell.getClipboardText();
                }
                ++j2;
            }
            ++n2;
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public boolean isDisposed() {
        return this.destroying || this.cTable == null || this.cTable.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getVisibleRows() {
        Object object = this.visibleRows_sync;
        synchronized (object) {
            return this.visibleRows.toArray(new TableRowCore[this.visibleRows.size()]);
        }
    }

    @Override
    public boolean hasChangesPending() {
        if (this.hasPendingDSChanges()) {
            return true;
        }
        this.sortRows(true, false);
        return this.lastMC != this.mutationCount.get();
    }

    @Override
    public void refreshTable(boolean bForceSort) {
        this.refreshTableRunnable.setForceSort(bForceSort);
        this.refresh_dispatcher.dispatch();
    }

    private void __refreshTable(boolean bForceSort) {
        boolean bWillSort;
        long lStart = SystemTime.getCurrentTime();
        super.refreshTable(bForceSort);
        Utils.execSWTThread(display -> this.isVisible());
        final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
        boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
        if (bWillSort) {
            TableColumnCore[] sortColumns = this.getSortColumns();
            if (bForceSort && sortColumns.length > 0) {
                this.resetLastSortedOn();
                TableColumnCore[] tableColumnCoreArray = sortColumns;
                int n = sortColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumnCore sortColumn = tableColumnCoreArray[n2];
                    sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
                    ++n2;
                }
            }
            this._sortColumn(true, false, false);
        }
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            @Override
            public void run(TableRowCore row, boolean bVisible) {
                row.refresh(bDoGraphics, bVisible);
            }
        });
        ++this.loopFactor;
        long diff = SystemTime.getCurrentTime() - lStart;
    }

    @Override
    public void setEnableTabViews(boolean enableTabViews, boolean expandByDefault) {
        this.enableTabViews = enableTabViews;
        this.tabViewsExpandedByDefault = expandByDefault;
    }

    @Override
    public boolean isTabViewsEnabled() {
        return this.enableTabViews;
    }

    @Override
    public boolean getTabViewsExpandedByDefault() {
        return this.tabViewsExpandedByDefault;
    }

    @Override
    public void requestFocus(final int reason) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.isDisposed()) {
                    return;
                }
                if (reason == 1) {
                    String text;
                    TableViewSWTFilter<?> filter2 = TableViewPainted.this.getSWTFilter();
                    if (filter2 != null && (text = filter2.text) != null && !text.isEmpty()) {
                        return;
                    }
                    TableViewPainted.this.cTable.setFocus();
                } else if (reason == 2) {
                    TableRowCore[] rows;
                    if (TableViewPainted.this.getSelectedRowsSize() == 0 && (rows = TableViewPainted.this.getRows()).length > 0) {
                        TableViewPainted.this.setSelectedRows(new TableRowCore[]{rows[0]});
                    }
                    TableViewPainted.this.cTable.setFocus();
                } else {
                    TableViewPainted.this.cTable.setFocus();
                }
            }
        });
    }

    @Override
    public void setRowDefaultHeightEM(final float lineHeight) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.cTable == null || TableViewPainted.this.cTable.isDisposed()) {
                    TableViewPainted.this.iHeightEM = lineHeight;
                    return;
                }
                int fontHeightInPX = FontUtils.getFontHeightInPX(TableViewPainted.this.cTable.getFont());
                int height = (int)((float)fontHeightInPX * lineHeight + lineHeight);
                TableViewPainted.this.setRowDefaultHeightPX(height);
            }
        });
    }

    @Override
    public void setRowDefaultHeight(int iHeight) {
        this.setRowDefaultHeightPX(iHeight);
    }

    @Override
    public void setRowDefaultHeightPX(int iHeight) {
        if (iHeight != this.defaultRowHeight) {
            this.defaultRowHeight = iHeight;
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (TableViewPainted.this.vBar != null && !TableViewPainted.this.vBar.isDisposed()) {
                        TableViewPainted.this.vBar.setIncrement(TableViewPainted.this.defaultRowHeight);
                    }
                }
            });
        }
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public int getRowMinHeight() {
        return this.rowMinHeight;
    }

    @Override
    public TableRowCore getRow(int x, int y) {
        LinkedHashSet<TableRowPainted> visibleRows = this.visibleRows;
        if (visibleRows.size() == 0) {
            return null;
        }
        boolean firstRow = true;
        int curY = 0;
        for (TableRowPainted row : visibleRows) {
            if (firstRow) {
                curY = row.getDrawOffset().y;
            }
            int h = row.getHeight();
            if (y >= curY && y < curY + h) {
                return row;
            }
            curY += h;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRowVisible(TableRowCore row) {
        if (row == null) {
            return false;
        }
        Object object = this.visibleRows_sync;
        synchronized (object) {
            return this.visibleRows.contains(row);
        }
    }

    @Override
    public TableCellCore getTableCellWithCursor() {
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        return this.getTableCell(pt.x, this.clientArea.y + pt.y);
    }

    @Override
    public TableRowCore getTableRowWithCursor() {
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        return this.getTableRow(pt.x, pt.y, true);
    }

    @Override
    public int getRowDefaultHeight() {
        return this.defaultRowHeight;
    }

    @Override
    public void setEnabled(final boolean enable) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (!TableViewPainted.this.isDisposed()) {
                    TableViewPainted.this.cTable.setEnabled(enable);
                    if (TableViewPainted.this.header != null) {
                        TableViewPainted.this.header.setEnabled(enable);
                    }
                }
            }
        });
    }

    @Override
    public boolean canHaveSubItems() {
        return true;
    }

    @Override
    public void setExpandEnabled(boolean b) {
        this.expandEnabled = b;
    }

    @Override
    public boolean isExpandEnabled() {
        return this.expandEnabled;
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        super.setHeaderVisible(visible);
        if (this.header != null) {
            this.header.setHeaderVisible(visible);
        }
    }

    @Override
    public int getMaxItemShown() {
        return 0;
    }

    @Override
    public void setMaxItemShown(int newIndex) {
    }

    @Override
    public void localeChanged(Locale old_locale, Locale new_locale) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.tvTabsCommon != null) {
                    TableViewPainted.this.tvTabsCommon.localeChanged();
                }
                TableViewPainted.this.tableInvalidate();
                TableViewPainted.this.refreshTable(true);
                if (TableViewPainted.this.header != null) {
                    TableViewPainted.this.header.redraw();
                }
            }
        });
    }

    @Override
    public void columnOrderChanged(int[] iPositions) {
    }

    @Override
    public void columnSizeChanged(TableColumnCore tableColumn, int diff) {
        this.columnsWidth += diff;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.header != null) {
                    TableViewPainted.this.header.redraw();
                }
                TableViewPainted.this.swt_fixupSize();
                TableViewPainted.this.redrawTable();
            }
        });
    }

    @Override
    public void sortOrderChanged() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String[] sortColumnNames = tcManager.getDefaultSortColumnNames(this.tableID);
        if (sortColumnNames.length == 0) {
            sortColumnNames = new String[]{this.sDefaultSortOn};
        }
        TableColumnCore[] tableColumns = this.getAllColumns();
        TableColumnCore[] sortColumns = new TableColumnCore[sortColumnNames.length];
        int i = 0;
        while (i < sortColumnNames.length) {
            String sortColumnName = sortColumnNames[i];
            TableColumnCore tc = tcManager.getTableColumnCore(this.tableID, sortColumnName);
            if (tc == null && tableColumns.length > 0) {
                tc = tableColumns[0];
            }
            sortColumns[i] = tc;
            ++i;
        }
        this.setSortColumns(sortColumns, false);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.addKeyListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.removeKeyListener(listener);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        if (this.tvSWTCommon == null) {
            return new KeyListener[0];
        }
        return this.tvSWTCommon.getKeyListeners();
    }

    @Override
    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        if (this.tvSWTCommon == null) {
            return;
        }
        this.tvSWTCommon.addMenuFillListener(l);
    }

    @Override
    public DragSource createDragSource(int style) {
        if (this.dragSource != null && !this.dragSource.isDisposed()) {
            this.dragSource.dispose();
        }
        this.dragSource = DragDropUtils.createDragSource((Control)this.cTable, style);
        this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event2) {
                TableViewPainted.this.cTable.setCursor(null);
                TableRowSWT row = TableViewPainted.this.getTableRow(event2.x, event2.y, true);
                if (row != null && !row.isSelected()) {
                    TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                }
                TableViewPainted.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent event2) {
                TableViewPainted.this.isDragging = false;
            }
        });
        return this.dragSource;
    }

    @Override
    public DropTarget createDropTarget(int style) {
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.dispose();
        }
        this.dropTarget = new DropTarget((Control)this.cTable, style);
        return this.dropTarget;
    }

    @Override
    public Composite getComposite() {
        return this.cTable;
    }

    @Override
    public TableRowCore getRow(DropTargetEvent event2) {
        Point pt = this.cTable.toControl(event2.x, event2.y);
        return this.getRow(pt.x, this.clientArea.y + pt.y);
    }

    @Override
    public TableRowSWT getRowSWT(Object dataSource) {
        return (TableRowSWT)this.getRow(dataSource);
    }

    @Override
    public Composite getTableComposite() {
        return this.cTable;
    }

    @Override
    public Composite createMainPanel(Composite composite) {
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        if (mainPanelCreator != null) {
            return mainPanelCreator.createTableViewPanel(composite);
        }
        Composite panel = new Composite(composite, 524288);
        composite.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        Layout parentLayout = composite.getLayout();
        if (parentLayout == null || parentLayout instanceof GridLayout) {
            panel.setLayoutData((Object)new GridData(1808));
        }
        return panel;
    }

    @Override
    public void initialize(Composite parent) {
        this.initialize(null, parent);
    }

    @Override
    public void initialize(UISWTView parentView, Composite parent) {
        this.tvTabsCommon = new TableViewSWT_TabsCommon(parentView, this);
        this.shell = parent.getShell();
        this.mainComposite = this.tvTabsCommon.createSashForm(parent);
        this.mainComposite.setData("Name", (Object)this.tableID);
        this.mainComposite.setData("ObfuscateImage", (Object)this);
        Composite cTableComposite = this.tvTabsCommon.tableComposite;
        GridLayout tableLayout = new GridLayout(1, false);
        tableLayout.horizontalSpacing = 0;
        tableLayout.verticalSpacing = 0;
        tableLayout.marginWidth = 0;
        tableLayout.marginHeight = 0;
        cTableComposite.setLayout((Layout)tableLayout);
        Layout layout = parent.getLayout();
        if (layout instanceof FormLayout) {
            FormData fd = Utils.getFilledFormData();
            cTableComposite.setLayoutData((Object)fd);
        }
        Canvas cHeaderArea = new Canvas(cTableComposite, 0x20000000);
        cHeaderArea.setLayoutData((Object)new GridData(4, 128, true, false));
        this.cTable = new Canvas(cTableComposite, 262912);
        this.cTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rowMinHeight = this.lineHeight = FontUtils.getFontHeightInPX(this.cTable.getFont());
        if (this.iHeightEM > 0.0f) {
            this.defaultRowHeight = (int)((float)this.rowMinHeight * this.iHeightEM + this.iHeightEM);
            this.iHeightEM = -1.0f;
        }
        this.rowMinHeight = (int)((double)this.rowMinHeight + Math.ceil((double)this.rowMinHeight * 2.0 / 16.0));
        if (this.defaultRowHeight < this.rowMinHeight) {
            this.defaultRowHeight = this.rowMinHeight;
        }
        this.cTable.setBackground(TablePaintedUtils.getColour((Device)parent.getDisplay(), 25));
        this.clientArea = this.cTable.getClientArea();
        TableColumnCore[] tableColumns = this.getAllColumns();
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[tableColumns.length];
        int columnOrderPos = 0;
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        int i = 0;
        while (i < tableColumns.length) {
            int position = tableColumns[i].getPosition();
            if (position != -1 && tableColumns[i].isVisible()) {
                tmpColumnsOrdered[columnOrderPos++] = tableColumns[i];
            }
            ++i;
        }
        TableColumnCore[] columnsOrdered = new TableColumnCore[columnOrderPos];
        System.arraycopy(tmpColumnsOrdered, 0, columnsOrdered, 0, columnOrderPos);
        this.setColumnsOrdered(columnsOrdered);
        this.cTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableViewPainted.this.swt_paintComposite(e);
            }
        });
        this.header = new TableHeaderPainted(this, cHeaderArea);
        this.menu = this.createMenu();
        this.cTable.setMenu(this.menu);
        this.cTable.addControlListener(new ControlListener(){
            boolean inControlResize = false;

            public void controlResized(ControlEvent e) {
                if (this.inControlResize) {
                    return;
                }
                try {
                    this.inControlResize = true;
                    TableViewPainted.this.swt_calculateClientArea();
                    TableViewPainted.this.swt_fixupSize();
                }
                finally {
                    this.inControlResize = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.hBar = this.cTable.getHorizontalBar();
        if (this.hBar != null) {
            this.hBar.setValues(0, 0, 0, 10, 10, 100);
            this.hBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (DIRECT_DRAW) {
                        TableViewPainted.this.swt_calculateClientArea();
                        TableViewPainted.this.redrawTable();
                    } else {
                        TableViewPainted.this.cTable.redraw();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.vBar = this.cTable.getVerticalBar();
        this.vBar.setData("ScrollOnMouseOver", () -> this.swt_vBarChanged());
        if (this.vBar != null) {
            this.vBar.setValues(0, 0, 0, 50, this.getRowDefaultHeight(), 50);
            this.vBar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewPainted.this.swt_vBarChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.cTable.addMouseListener((MouseListener)this.tvSWTCommon);
        this.cTable.addMouseMoveListener((MouseMoveListener)this.tvSWTCommon);
        this.cTable.addKeyListener((KeyListener)this.tvSWTCommon);
        this.cTable.addMenuDetectListener((MenuDetectListener)this.tvSWTCommon);
        this.cTable.addListener(37, e -> {
            if (e.stateMask == 0) {
                return;
            }
            if (e.widget != e.display.getCursorControl()) {
                return;
            }
            if ((e.stateMask & SWT.MOD1) > 0) {
                int newHeight = Math.min(Math.max(this.getRowMinHeight(), this.getRowDefaultHeight() - e.count), 300);
                this.setRowHeight(newHeight);
                e.doit = false;
            }
        });
        this.cTable.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.cTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TableViewPainted.this.canvasImage != null) {
                    TableViewPainted.this.canvasImage.dispose();
                    TableViewPainted.this.canvasImage = null;
                }
            }
        });
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            @Override
            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                if (TableViewPainted.this.cTable == null || TableViewPainted.this.cTable.isDisposed()) {
                    SelectedContentManager.removeCurrentlySelectedContentListener(this);
                } else {
                    TableRowCore[] rows;
                    TableRowCore[] tableRowCoreArray = rows = TableViewPainted.this.getSelectedRows();
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        row.invalidate();
                        TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                        ++n2;
                    }
                }
            }
        });
        this.cTable.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TableViewPainted.this.isFocused = false;
                TableViewPainted.this.redrawTable();
            }

            public void focusGained(FocusEvent e) {
                TableViewPainted.this.isFocused = true;
                TableViewPainted.this.redrawTable();
            }
        });
        this.isFocused = this.cTable.isFocusControl();
        new TableTooltips(this, this.cTable);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String[] sortColumnNames = tcManager.getDefaultSortColumnNames(this.tableID);
        if (sortColumnNames.length == 0) {
            sortColumnNames = new String[]{this.sDefaultSortOn};
        }
        TableColumnCore[] sortColumns = new TableColumnCore[sortColumnNames.length];
        int i2 = 0;
        while (i2 < sortColumnNames.length) {
            String sortColumnName = sortColumnNames[i2];
            TableColumnCore tc = tcManager.getTableColumnCore(this.tableID, sortColumnName);
            if (tc == null && tableColumns.length > 0) {
                tc = tableColumns[0];
            }
            sortColumns[i2] = tc;
            ++i2;
        }
        this.setSortColumns(sortColumns, false);
        Map tableConfigMap = tcManager.getTableConfigMap(this.tableID);
        this.defaultRowHeight = MapUtils.getMapInt(tableConfigMap, "RowHeight", this.defaultRowHeight);
        this.triggerLifeCycleListener(0);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        configMan.addParameterListener("Table.extendedErase", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.tableID).addListener(this);
        MessageText.addListener(this);
    }

    protected void swt_vBarChanged() {
        this.vbarDispatcher.dispatch();
    }

    protected void rowCreated() {
        this.mutationCount.incrementAndGet();
    }

    @Override
    public void tableMutated() {
        super.tableMutated();
        this.mutationCount.incrementAndGet();
    }

    @Override
    public void tableStructureChanged(final boolean columnAddedOrRemoved, final Class forPluginDataSourceType) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TableViewPainted.super.tableStructureChanged(columnAddedOrRemoved, forPluginDataSourceType);
                if (TableViewPainted.this.header != null) {
                    TableViewPainted.this.header.redraw();
                }
                TableViewPainted.this.redrawTable();
            }
        });
    }

    protected void swt_paintComposite(PaintEvent e) {
        this.swt_calculateClientArea();
        if (this.canvasImage == null) {
            this.swt_paintCanvasImage(e.gc, e.gc.getClipping());
            return;
        }
        e.gc.drawImage(this.canvasImage, -this.clientArea.x, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_paintCanvasImage(GC gc, Rectangle drawBounds) {
        if (this.cTable == null || this.cTable.isDisposed()) {
            return;
        }
        int mut = this.mutationCount.get();
        if (mut != this.lastMC) {
            boolean changed = this.numberAllVisibleRows();
            Object object = this.visibleRows_sync;
            synchronized (object) {
                for (TableColumnPainted tcp : this.paintedColumns.values()) {
                    tcp.sync();
                }
            }
        }
        try {
            int x;
            int h;
            int yDirty;
            int end = drawBounds.y + drawBounds.height;
            gc.setFont(this.cTable.getFont());
            Utils.setClipping(gc, drawBounds);
            TableRowPainted oldRow = null;
            int pos = -1;
            LinkedHashSet<TableRowPainted> visibleRows = this.visibleRows;
            boolean isTableSelected = this.isTableSelected();
            boolean isTableEnabled = this.cTable.isEnabled();
            for (TableRowPainted row : visibleRows) {
                TableRowPainted paintedRow = row;
                int rowHeight = paintedRow.getHeight();
                if (rowHeight > 0) {
                    int rowStartY;
                    pos = pos == -1 ? row.getVisibleRowIndex() : ++pos;
                    Point drawOffset = paintedRow.getDrawOffset();
                    int rowStartX = 0;
                    if (DIRECT_DRAW) {
                        rowStartX = -drawOffset.x;
                    }
                    if (drawBounds.intersects(rowStartX, rowStartY = drawOffset.y - this.clientArea.y, 9999, rowHeight)) {
                        int diffY2 = rowStartY + rowHeight - (drawBounds.y + drawBounds.height);
                        if (diffY2 > 0) {
                            drawBounds.height += diffY2;
                            Utils.setClipping(gc, drawBounds);
                        }
                        paintedRow.swt_paintGC(gc, drawBounds, rowStartX, rowStartY, pos, isTableSelected, isTableEnabled);
                    }
                }
                oldRow = row;
            }
            if (oldRow == null) {
                yDirty = drawBounds.y;
                h = drawBounds.height;
            } else {
                yDirty = ((TableRowPainted)oldRow).getDrawOffset().y + ((TableRowPainted)oldRow).getFullHeight();
                h = drawBounds.y + drawBounds.height - yDirty;
            }
            if (h > 0) {
                int rowHeight = this.getRowDefaultHeight();
                if (this.extendedErase && this.cTable.isEnabled()) {
                    while (yDirty < end) {
                        Color color;
                        if ((color = Colors.alternatingColors[++pos % 2]) != null) {
                            gc.setBackground(color);
                        }
                        if (color == null) {
                            gc.setBackground(TablePaintedUtils.getColour(gc, 25));
                        }
                        gc.fillRectangle(drawBounds.x, yDirty, drawBounds.width, rowHeight);
                        yDirty += rowHeight;
                    }
                } else {
                    gc.setBackground(TablePaintedUtils.getColour(gc, this.cTable.isEnabled() ? 25 : 22));
                    gc.fillRectangle(drawBounds.x, yDirty, drawBounds.width, h);
                }
            }
            Utils.setClipping(gc, drawBounds);
            TableColumnCore[] visibleColumns = this.getVisibleColumns();
            int n = x = DIRECT_DRAW ? -this.clientArea.x : 0;
            if (TablePaintedUtils.isDark()) {
                gc.setAlpha(120);
                gc.setForeground(TablePaintedUtils.getColour(gc, 22));
            } else {
                gc.setAlpha(20);
            }
            TableColumnCore[] tableColumnCoreArray = visibleColumns;
            int n2 = visibleColumns.length;
            int n3 = 0;
            while (n3 < n2) {
                TableColumnCore column = tableColumnCoreArray[n3];
                gc.drawLine((x += column.getWidth()) - 1, drawBounds.y, x - 1, drawBounds.y + drawBounds.height);
                ++n3;
            }
            gc.setAlpha(255);
        }
        finally {
            this.lastMC = mut;
        }
    }

    private Color getColorLine() {
        if (this.colorLine == null) {
            this.colorLine = TablePaintedUtils.getColour((Device)this.cTable.getDisplay(), 25);
            HSLColor hslColor = new HSLColor();
            hslColor.initHSLbyRGB(this.colorLine.getRed(), this.colorLine.getGreen(), this.colorLine.getBlue());
            int lum = hslColor.getLuminence();
            lum = lum > 127 ? (lum -= 25) : (lum += 40);
            hslColor.setLuminence(lum);
            this.colorLine = new Color((Device)this.cTable.getDisplay(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        }
        return this.colorLine;
    }

    @Override
    public Image obfuscatedImage(Image image) {
        TableRowPainted[] visibleRows;
        TableColumnCore[] visibleColumns = this.getVisibleColumns();
        TableRowPainted[] tableRowPaintedArray = visibleRows = this.visibleRows.toArray(new TableRowPainted[0]);
        int n = visibleRows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowPainted row = tableRowPaintedArray[n2];
            if (row != null && !row.isRowDisposed()) {
                TableColumnCore[] tableColumnCoreArray = visibleColumns;
                int n3 = visibleColumns.length;
                int n4 = 0;
                while (n4 < n3) {
                    String text;
                    TableCellPainted cell;
                    TableColumnCore tc = tableColumnCoreArray[n4];
                    if (tc != null && tc.isObfuscated() && (cell = (TableCellPainted)row.getTableCell(tc.getName())) != null && (text = cell.getObfuscatedText()) != null) {
                        int tableWidth;
                        Rectangle cellBounds = cell.getBoundsOnDisplay();
                        Point ptDisplay = this.cTable.getShell().getLocation();
                        cellBounds.x -= ptDisplay.x;
                        cellBounds.y -= ptDisplay.y;
                        Rectangle boundsRaw = cell.getBoundsRaw();
                        if (boundsRaw.y + cellBounds.height > this.clientArea.y + this.clientArea.height) {
                            cellBounds.height -= boundsRaw.y + cellBounds.height - (this.clientArea.y + this.clientArea.height);
                        }
                        if (boundsRaw.x + cellBounds.width > this.clientArea.x + (tableWidth = this.cTable.getClientArea().width)) {
                            cellBounds.width -= boundsRaw.x + cellBounds.width - (this.clientArea.x + tableWidth);
                        }
                        UIDebugGenerator.obfuscateArea(image, cellBounds, text);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.obfuscatedImage(image);
        }
        return image;
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    @Override
    public TableViewCreator getTableViewCreator() {
        return this.mainPanelCreator;
    }

    @Override
    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    @Override
    public TableCellCore getTableCell(int x, int y) {
        TableRowSWT row = this.getTableRow(x, y, true);
        if (row == null) {
            return null;
        }
        TableColumnCore column = this.getTableColumnByOffset(x);
        if (column == null) {
            return null;
        }
        return row.getTableCellCore(column.getName());
    }

    @Override
    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.cTable.getDisplay().getCursorLocation();
        pt = this.cTable.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        int x = pt.x - bounds.x;
        if (x < 0 || x > bounds.width) {
            return null;
        }
        int y = pt.y - bounds.y;
        if (y < 0 || y > bounds.height) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    public void enableFilterCheck(Text txtFilter, TableViewFilterCheck<Object> filterCheck) {
        Object o = txtFilter.getData("BubbleTextBox");
        if (o instanceof BubbleTextBox) {
            this.enableFilterCheck((BubbleTextBox)o, filterCheck, false);
        }
    }

    @Override
    public void enableFilterCheck(BubbleTextBox txtFilter, TableViewFilterCheck<Object> filterCheck) {
        this.enableFilterCheck(txtFilter, filterCheck, false);
    }

    @Override
    public void enableFilterCheck(BubbleTextBox filterBox, TableViewFilterCheck<Object> filterCheck, boolean filterSubRows) {
        this.filterSubRows = filterSubRows;
        TableViewSWTFilter<Object> filter2 = this.getSWTFilter();
        if (filter2 != null) {
            if (filter2.filterBox != null && !filter2.filterBox.isDisposed()) {
                filter2.filterBox.setKeyListener(null);
                filter2.filterBox.removeBubbleTextBoxChangeListenener(this);
            }
        } else {
            filter2 = new TableViewSWTFilter();
            this.filter = filter2;
        }
        filter2.filterBox = filterBox;
        if (filterBox != null) {
            Class<?> cla = this.getDataSourceType();
            String historyKey = "";
            if (cla != null && cla != DownloadTypeComplete.class && cla != DownloadTypeIncomplete.class && cla != Download.class) {
                historyKey = "." + cla.getName();
            }
            TextWithHistory twh = new TextWithHistory("tableviewpainted.search" + historyKey, "table.filter.history", filterBox.getTextWidget());
            twh.setKeDownShowsHistory(false);
            filterBox.getTextWidget().addListener(16, ev -> {
                String text = filterBox.getText().trim();
                if (!text.isEmpty()) {
                    twh.addHistory(text);
                }
            });
            filterBox.setKeyListener(this.tvSWTCommon);
            if (filterBox.getText().length() == 0) {
                filterBox.setText(filter2.text);
            }
            filterBox.setAllowRegex(true);
            filterBox.addBubbleTextBoxChangeListener(this);
        } else {
            filter2.nextText = "";
            filter2.text = "";
        }
        filter2.checker = filterCheck;
        filter2.checker.filterSet(filter2.text);
        this.refilter();
    }

    @Override
    protected boolean getFilterSubRows() {
        return this.filterSubRows;
    }

    @Override
    public boolean hasFilterControl() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        return filter2 != null && filter2.filterBox != null && !filter2.filterBox.isDisposed();
    }

    protected TableColumnPainted getColumnPainted(TableColumnCore c) {
        TableColumnPainted tcp = this.paintedColumns.get(c);
        if (tcp == null) {
            this.mutationCount.incrementAndGet();
            tcp = new TableColumnPainted(c);
            this.paintedColumns.put(c, tcp);
        }
        return tcp;
    }

    @Override
    public void disableFilterCheck() {
        TableViewSWTFilter<?> filter2 = this.getSWTFilter();
        if (filter2 == null) {
            return;
        }
        if (filter2.filterBox != null && !filter2.filterBox.isDisposed()) {
            filter2.filterBox.setKeyListener(null);
            filter2.filterBox.removeBubbleTextBoxChangeListenener(this);
        }
        this.filter = null;
    }

    @Override
    public void setFilterText(String s, boolean force) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.setFilterText(s, force);
        }
    }

    @Override
    public boolean enableSizeSlider(Composite composite, int min, int max) {
        return false;
    }

    @Override
    public void setRowHeight(int newHeight) {
        if (newHeight == this.defaultRowHeight) {
            return;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map tableConfigMap = tcManager.getTableConfigMap(this.tableID);
        tableConfigMap.put("RowHeight", newHeight);
        tcManager.setTableConfigMap(this.tableID, tableConfigMap);
        this.setRowDefaultHeightPX(newHeight);
        TableRowCore[] rows = this.getRowsAndSubRows(true);
        if (rows.length == 0) {
            Utils.execSWTThreadLater(0, () -> this.swt_updateCanvasImage(false));
            return;
        }
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            ((TableRowPainted)row).setHeight(newHeight, true);
            ++n2;
        }
        Utils.execSWTThreadLater(0, () -> rows[0].redraw());
    }

    @Override
    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowPaintListener(listener);
        }
    }

    @Override
    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowPaintListener(listener);
        }
    }

    @Override
    public void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokePaintListeners(gc, row, column, cellArea);
        }
    }

    @Override
    public void addRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.addRowMouseListener(listener);
        }
    }

    @Override
    public void removeRowMouseListener(TableRowMouseListener listener) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.removeRowMouseListener(listener);
        }
    }

    @Override
    public void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.invokeRowMouseListener(event2);
        }
    }

    @Override
    public void packColumns() {
    }

    @Override
    public void parameterChanged(String parameterName) {
        boolean invalidate;
        boolean bl = invalidate = parameterName == null;
        if (parameterName == null || parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
        }
        if (parameterName == null || parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
        }
        if (parameterName == null || parameterName.equals("Table.extendedErase")) {
            this.extendedErase = configMan.getBooleanParameter("Table.extendedErase");
            invalidate = true;
        }
        if (parameterName == null || parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    @Override
    public TableRowCore createNewRow(Object object) {
        return new TableRowPainted(null, this, object, true);
    }

    @Override
    public TableRowSWT createFakeRow(Object object) {
        return new TableRowPainted(null, this, object);
    }

    @Override
    public void visibleRowsChanged() {
        if (Utils.isDisplayDisposed()) {
            return;
        }
        this.swt_visibleRowsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_visibleRowsChanged() {
        List<TableRowSWT> newVisibleRows;
        Object rows;
        final ArrayList<TableRowSWT> newlyVisibleRows = new ArrayList<TableRowSWT>();
        final ArrayList<TableRowSWT> rowsStayedVisibleButMoved = new ArrayList<TableRowSWT>();
        if (this.isVisible()) {
            rows = this.getRows();
            newVisibleRows = new ArrayList();
            this.recalculateVisibleRows((TableRowCore[])rows, 0, newVisibleRows, rowsStayedVisibleButMoved);
        } else {
            newVisibleRows = Collections.emptyList();
        }
        final ArrayList<TableRowPainted> nowInVisibleRows = new ArrayList<TableRowPainted>(0);
        rows = this.visibleRows_sync;
        synchronized (rows) {
            if (this.visibleRows != null) {
                nowInVisibleRows.addAll(this.visibleRows);
            }
        }
        rows = new LinkedHashSet(newVisibleRows.size());
        for (TableRowSWT row : newVisibleRows) {
            ((HashSet)rows).add((TableRowPainted)row);
            boolean removed = nowInVisibleRows.remove(row);
            if (removed) continue;
            newlyVisibleRows.add(row);
        }
        Object object = this.visibleRows_sync;
        synchronized (object) {
            this.visibleRows = rows;
        }
        Utils.getOffOfSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                boolean bTableUpdate = false;
                for (TableRowSWT row : newlyVisibleRows) {
                    row.setShown(true, false);
                    rowsStayedVisibleButMoved.remove(row);
                    if (!Constants.isOSX) continue;
                    bTableUpdate = true;
                }
                for (TableRowSWT row : rowsStayedVisibleButMoved) {
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                }
                for (TableRowSWT row : nowInVisibleRows) {
                    row.setShown(false, false);
                }
                if (bTableUpdate) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (TableViewPainted.this.cTable != null && !TableViewPainted.this.cTable.isDisposed()) {
                                TableViewPainted.this.cTable.update();
                            }
                        }
                    });
                }
            }
        });
    }

    private void recalculateVisibleRows(TableRowCore[] rows, int yStart, List<TableRowSWT> newVisibleRows, List<TableRowSWT> rowsStayedVisibleButMoved) {
        Rectangle bounds = this.clientArea;
        int y = yStart;
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (row != null) {
                TableRowPainted rowSWT = (TableRowPainted)row;
                int rowHeight = rowSWT.getHeight();
                int rowFullHeight = rowSWT.getFullHeight();
                if (y < bounds.y + bounds.height && y + rowFullHeight > bounds.y) {
                    TableRowCore[] subRowsWithNull;
                    boolean offsetChanged = rowSWT.setDrawOffset(new Point(bounds.x, y));
                    if (y + rowHeight > bounds.y) {
                        if (offsetChanged) {
                            rowsStayedVisibleButMoved.add(rowSWT);
                        }
                        newVisibleRows.add(rowSWT);
                    }
                    if (row.isExpanded() && (subRowsWithNull = row.getSubRowsWithNull()).length > 0) {
                        this.recalculateVisibleRows(subRowsWithNull, y + rowHeight, newVisibleRows, rowsStayedVisibleButMoved);
                    }
                } else if (newVisibleRows.size() > 0) break;
                y += rowFullHeight;
            }
            ++n2;
        }
    }

    @Override
    public int uiGuessMaxVisibleRows() {
        return this.clientArea.height / this.defaultRowHeight + 1;
    }

    @Override
    public void uiRemoveRows(TableRowCore[] rows, Integer[] rowIndexes) {
        int bottomIndex;
        if (this.focusedRow != null) {
            TableRowCore[] tableRowCoreArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowCore row = tableRowCoreArray[n2];
                if (row == this.focusedRow) {
                    this.setFocusedRow(null);
                    break;
                }
                ++n2;
            }
        }
        if ((bottomIndex = this.getRowCount() - 1) < 0) {
            this.redrawTable();
        } else {
            TableRowCore rowBottom = this.getLastVisibleRow();
            if (rowBottom != null) {
                while (rowBottom.getParentRowCore() != null) {
                    rowBottom = rowBottom.getParentRowCore();
                }
                if (this.indexOf(rowBottom) < 0) {
                    this.redrawTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRowPainted getLastVisibleRow() {
        Object object = this.visibleRows_sync;
        synchronized (object) {
            block5: {
                if (this.visibleRows != null && this.visibleRows.size() != 0) break block5;
                return null;
            }
            TableRowPainted rowBottom = null;
            Iterator iterator = this.visibleRows.iterator();
            while (iterator.hasNext()) {
                TableRowPainted row;
                rowBottom = row = (TableRowPainted)iterator.next();
            }
            return rowBottom;
        }
    }

    @Override
    public void getOffUIThread(AERunnable runnable) {
        Utils.getOffOfSWTThread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swt_calculateClientArea() {
        boolean changedH;
        boolean changedY;
        boolean changedX;
        TableColumnCore[] visibleColumns;
        if (this.cTable == null || this.cTable.isDisposed()) {
            return;
        }
        Rectangle oldClientArea = this.clientArea;
        Rectangle newClientArea = this.cTable.getClientArea();
        newClientArea.x = this.hBar.getSelection();
        newClientArea.y = this.vBar.getSelection();
        int w = 0;
        TableColumnCore[] tableColumnCoreArray = visibleColumns = this.getVisibleColumns();
        int n = visibleColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnCore column = tableColumnCoreArray[n2];
            w += column.getWidth();
            ++n2;
        }
        this.columnsWidth = w;
        w = newClientArea.width = Math.max(newClientArea.width, w);
        boolean refreshTable = false;
        if (oldClientArea != null) {
            changedX = oldClientArea.x != newClientArea.x;
            changedY = oldClientArea.y != newClientArea.y;
            changedH = oldClientArea.height != newClientArea.height;
        } else {
            changedH = true;
            changedY = true;
            changedX = true;
        }
        this.clientArea = newClientArea;
        if (this.tvSWTCommon != null) {
            this.tvSWTCommon.xAdj = -this.clientArea.x;
        }
        boolean needRedraw = false;
        if (changedY || changedH) {
            LinkedHashSet<TableRowPainted> visibleRows;
            this.visibleRowsChanged();
            if (changedY && oldClientArea != null && (visibleRows = this.visibleRows).size() > 0) {
                if (this.canvasImage != null && !this.canvasImage.isDisposed() && !changedH) {
                    int yDiff = oldClientArea.y - newClientArea.y;
                    if (Math.abs(yDiff) < this.clientArea.height) {
                        block44: {
                            boolean wasIn = this.in_swt_updateCanvasImage;
                            this.in_swt_updateCanvasImage = true;
                            try {
                                try {
                                    GC gc = new GC((Drawable)this.canvasImage);
                                    try {
                                        Rectangle bounds = this.canvasImage.getBounds();
                                        if (yDiff > 0) {
                                            if (Utils.isGTK3) {
                                                gc.copyArea(this.canvasImage, 0, -yDiff);
                                            } else {
                                                gc.copyArea(0, 0, bounds.width, bounds.height, 0, yDiff, false);
                                            }
                                            this.swt_paintCanvasImage(gc, new Rectangle(0, 0, 9999, yDiff));
                                            Utils.setClipping(gc, null);
                                        } else {
                                            if (Utils.isGTK3) {
                                                gc.drawImage(this.canvasImage, 0, yDiff);
                                            } else {
                                                gc.copyArea(0, -yDiff, bounds.width, bounds.height, 0, 0, false);
                                            }
                                            int h = -yDiff;
                                            TableRowPainted row = this.getLastVisibleRow();
                                            if (row != null) {
                                                h += row.getHeight();
                                            }
                                            this.swt_paintCanvasImage(gc, new Rectangle(0, bounds.height - h, 9999, h));
                                            Utils.setClipping(gc, null);
                                        }
                                    }
                                    finally {
                                        gc.dispose();
                                    }
                                }
                                catch (Throwable e) {
                                    refreshTable = true;
                                    this.in_swt_updateCanvasImage = wasIn;
                                    break block44;
                                }
                            }
                            catch (Throwable throwable) {
                                this.in_swt_updateCanvasImage = wasIn;
                                throw throwable;
                            }
                            this.in_swt_updateCanvasImage = wasIn;
                        }
                        needRedraw = true;
                    } else {
                        refreshTable = true;
                    }
                } else if (this.canvasImage == null) {
                    needRedraw = true;
                }
            }
        }
        if (changedX && this.header != null) {
            this.header.redraw();
        }
        if (!DIRECT_DRAW) {
            boolean canvasChanged;
            int oldW;
            Image newImage = this.canvasImage;
            int h = 0;
            Object wasIn = this.visibleRows_sync;
            synchronized (wasIn) {
                TableRowPainted lastRow = this.getLastVisibleRow();
                if (lastRow != null && (h = lastRow.getDrawOffset().y - this.clientArea.y + lastRow.getHeight()) < this.clientArea.height && lastRow.isExpanded()) {
                    TableRowCore[] subRows;
                    TableRowCore[] tableRowCoreArray = subRows = lastRow.getSubRowsWithNull();
                    int n3 = subRows.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TableRowPainted subRowP;
                        TableRowCore subRow = tableRowCoreArray[n4];
                        if (subRow != null && (h += (subRowP = (TableRowPainted)subRow).getFullHeight()) >= this.clientArea.height) break;
                        ++n4;
                    }
                }
            }
            if (h < this.clientArea.height) {
                h = this.clientArea.height;
            }
            int oldH = this.canvasImage == null || this.canvasImage.isDisposed() ? 0 : this.canvasImage.getBounds().height;
            int n5 = oldW = this.canvasImage == null || this.canvasImage.isDisposed() ? 0 : this.canvasImage.getBounds().width;
            if (this.canvasImage == null || oldW != w || h > oldH) {
                if (h <= 0 || this.clientArea.width <= 0) {
                    if (newImage != null) {
                        newImage.dispose();
                    }
                    newImage = null;
                } else {
                    newImage = new Image((Device)this.shell.getDisplay(), w, h);
                }
            }
            boolean bl = canvasChanged = this.canvasImage != newImage;
            if (canvasChanged) {
                Image oldImage = this.canvasImage;
                this.canvasImage = newImage;
                if (oldImage != null && !oldImage.isDisposed()) {
                    oldImage.dispose();
                }
            }
            if (changedH || canvasChanged || refreshTable) {
                this.__refreshTable(false);
                if (canvasChanged) {
                    this.swt_updateCanvasImage(false);
                }
            }
        }
        if (needRedraw) {
            this.cTable.redraw();
        }
    }

    private void forceDebugShellRefresh(Rectangle bounds) {
        if (this.sCanvasImage == null || this.sCanvasImage.isDisposed()) {
            return;
        }
        if (this.canvasImage == null || this.canvasImage.isDisposed()) {
            this.sCanvasImage.getShell().setSize(0, 0);
            return;
        }
        Point size = this.sCanvasImage.getShell().computeSize(this.canvasImage.getBounds().width, this.canvasImage.getBounds().height);
        this.sCanvasImage.getShell().setSize(size);
        if (bounds == null) {
            this.sCanvasImage.redraw();
        } else {
            this.sCanvasImage.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        this.sCanvasImage.update();
    }

    public void swt_updateCanvasImage(boolean immediateRedraw) {
        if (this.canvasImage != null && !this.canvasImage.isDisposed()) {
            this.swt_updateCanvasImage(this.canvasImage.getBounds(), immediateRedraw);
        } else {
            this.cTable.redraw();
        }
    }

    protected void swt_updateCanvasImage(final Rectangle bounds, final boolean immediateRedraw) {
        if (this.in_swt_updateCanvasImage) {
            Utils.execSWTThreadLater(0, new SWTRunnable(){

                @Override
                public void runWithDisplay(Display display) {
                    TableViewPainted.this.in_swt_updateCanvasImage = false;
                    TableViewPainted.this.swt_updateCanvasImage(bounds, immediateRedraw);
                }
            });
            return;
        }
        this.in_swt_updateCanvasImage = true;
        try {
            int x;
            if (!DIRECT_DRAW) {
                if (this.canvasImage == null || this.canvasImage.isDisposed() || bounds == null) {
                    return;
                }
                GC gc = new GC((Drawable)this.canvasImage);
                this.swt_paintCanvasImage(gc, bounds);
                gc.dispose();
                x = bounds.x - this.clientArea.x;
            } else {
                x = bounds.x;
            }
            if (this.cTable != null && !this.cTable.isDisposed()) {
                this.cTable.redraw(x, bounds.y, bounds.width, bounds.height, false);
                if (immediateRedraw) {
                    this.cTable.update();
                }
            }
        }
        finally {
            this.in_swt_updateCanvasImage = false;
        }
    }

    @Override
    public Rectangle getClientArea() {
        return this.clientArea;
    }

    @Override
    public boolean isVisible() {
        if (!Utils.isThisThreadSWT()) {
            return this.isVisible;
        }
        boolean wasVisible = this.isVisible;
        boolean bl = this.isVisible = this.cTable != null && !this.cTable.isDisposed() && this.cTable.isVisible() && !this.shell.getMinimized();
        if (this.isVisible != wasVisible) {
            MdiEntrySWT view;
            this.visibleRowsChanged();
            MdiEntrySWT mdiEntrySWT = view = this.tvTabsCommon == null ? null : this.tvTabsCommon.getActiveSubView();
            if (this.isVisible) {
                this.loopFactor = 0;
                if (view != null) {
                    view.getMDI().showEntry(view);
                }
            } else if (view != null) {
                view.triggerEvent(4, null);
            }
        }
        return this.isVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTableRows() {
        super.removeAllTableRows();
        Object object = this.visibleRows_sync;
        synchronized (object) {
            this.visibleRows = new LinkedHashSet();
        }
        this.setFocusedRow(null);
        this.totalHeight = 0;
        Utils.execSWTThread(new SWTRunnable(){

            @Override
            public void runWithDisplay(Display display) {
                if (TableViewPainted.this.cTable == null || TableViewPainted.this.cTable.isDisposed()) {
                    return;
                }
                TableViewPainted.this.swt_fixupSize();
                TableViewPainted.this.swt_updateCanvasImage(false);
            }
        });
    }

    protected void swt_fixupSize() {
        int tableSize;
        int max;
        boolean vBarValid;
        boolean bl = vBarValid = this.vBar != null && !this.vBar.isDisposed();
        if (vBarValid) {
            max = this.totalHeight;
            tableSize = this.clientArea.height;
            if (max < tableSize) {
                this.vBar.setSelection(0);
                this.vBar.setEnabled(false);
                this.vBar.setVisible(false);
            } else {
                if (!this.vBar.isVisible()) {
                    this.vBar.setVisible(true);
                    this.vBar.setEnabled(true);
                }
                if (this.vBar.getMaximum() != max) {
                    this.vBar.setMaximum(max);
                    this.swt_vBarChanged();
                }
                this.vBar.setThumb(tableSize);
                this.vBar.setPageIncrement(tableSize);
            }
        }
        if (this.hBar != null && !this.hBar.isDisposed()) {
            tableSize = this.cTable.getSize().x;
            max = this.columnsWidth;
            if (vBarValid && this.vBar.isVisible() && this.getScrollbarsMode() == 0) {
                int vBarW = this.vBar.getSize().x;
                max += vBarW;
            }
            if (max < tableSize) {
                this.hBar.setSelection(0);
                this.hBar.setEnabled(false);
                this.hBar.setVisible(false);
            } else {
                if (!this.hBar.isVisible()) {
                    this.hBar.setVisible(true);
                    this.hBar.setEnabled(true);
                }
                this.hBar.setValues(this.hBar.getSelection(), 0, max, tableSize, 50, tableSize);
            }
            if (vBarValid && this.hBar.isVisible()) {
                int hBarW = this.getScrollbarsMode() == 0 ? this.hBar.getSize().y : 0;
                this.vBar.setThumb(this.clientArea.height - hBarW);
                this.vBar.setMaximum(this.totalHeight - hBarW);
                this.vBar.setPageIncrement(this.vBar.getPageIncrement() - hBarW);
            }
        }
    }

    private int getScrollbarsMode() {
        if (hasGetScrollBarMode) {
            return this.cTable.getScrollbarsMode();
        }
        return 0;
    }

    @Override
    protected void uiChangeColumnIndicator() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.header != null) {
                    TableViewPainted.this.header.redraw();
                }
            }
        });
    }

    @Override
    public TableColumnCore getTableColumnByOffset(int mouseX) {
        TableColumnCore[] visibleColumns;
        int x = -this.clientArea.x;
        TableColumnCore[] tableColumnCoreArray = visibleColumns = this.getVisibleColumns();
        int n = visibleColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumnCore column = tableColumnCoreArray[n2];
            int w = column.getWidth();
            if (mouseX >= x && mouseX < x + w) {
                return column;
            }
            x += w;
            ++n2;
        }
        return null;
    }

    @Override
    public TableRowSWT getTableRow(int x, int y, boolean anyX) {
        return (TableRowSWT)this.getRow(anyX ? 2 : x, this.clientArea.y + y);
    }

    @Override
    public void setSelectedRows(TableRowCore[] newSelectionArray, boolean trigger) {
        super.setSelectedRows(newSelectionArray, trigger);
        boolean focusInSelection = false;
        TableRowCore[] tableRowCoreArray = newSelectionArray;
        int n = newSelectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (row != null && row.equals(this.focusedRow)) {
                focusInSelection = true;
                break;
            }
            ++n2;
        }
        if (focusInSelection) {
            this.reaffirmSelection();
        } else {
            this.setFocusedRow(newSelectionArray.length == 0 ? null : newSelectionArray[0]);
        }
    }

    @Override
    public void setRowSelected(TableRowCore row, boolean selected, boolean trigger) {
        if (selected && !this.isSelected(row)) {
            this.setFocusedRow(row);
        }
        super.setRowSelected(row, selected, trigger);
        if (row instanceof TableRowSWT) {
            ((TableRowSWT)row).setWidgetSelected(selected);
        }
    }

    @Override
    public void editCell(TableColumnCore column, int row) {
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public TableViewSWTFilter<?> getSWTFilter() {
        return (TableViewSWTFilter)this.filter;
    }

    @Override
    public void openFilterDialog() {
        if (this.filter == null) {
            return;
        }
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setFilter.title", null, "MyTorrentsView.dialog.setFilter.text", new String[]{MessageText.getString(String.valueOf(this.getTableID()) + "View" + ".header")});
        entryWindow.setPreenteredText(this.filter.text, false);
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String message = entryWindow.getSubmittedInput();
                if (message == null) {
                    message = "";
                }
                TableViewPainted.this.setFilterText(message, false);
            }
        });
    }

    @Override
    public boolean isSingleSelection() {
        return !this.isMultiSelect;
    }

    @Override
    public void expandColumns() {
    }

    @Override
    public void triggerTabViewsDataSourceChanged() {
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.triggerTabViewsDataSourceChanged(this);
        }
    }

    @Override
    public TableViewSWT_TabsCommon getTabsCommon() {
        return this.tvTabsCommon;
    }

    @Override
    public void uiSelectionChanged(final TableRowCore[] newlySelectedRows, final TableRowCore[] deselectedRows) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TableRowCore row;
                TableRowCore[] tableRowCoreArray = deselectedRows;
                int n = deselectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    row = tableRowCoreArray[n2];
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                    ++n2;
                }
                tableRowCoreArray = newlySelectedRows;
                n = newlySelectedRows.length;
                n2 = 0;
                while (n2 < n) {
                    row = tableRowCoreArray[n2];
                    row.invalidate();
                    TableViewPainted.this.redrawRow((TableRowPainted)row, false);
                    ++n2;
                }
            }
        });
    }

    @Override
    protected void triggerLifeCycleListener(int eventType) {
        super.triggerLifeCycleListener(eventType);
        if (eventType == 1) {
            Utils.execSWTThread(new SWTRunnable(){

                @Override
                public void runWithDisplay(Display display) {
                    Utils.disposeSWTObjects(TableViewPainted.this.dragSource, TableViewPainted.this.dropTarget);
                    TableViewPainted.this.dragSource = null;
                    TableViewPainted.this.dropTarget = null;
                }
            });
        }
    }

    @Override
    public void delete() {
        this.destroying = true;
        this.triggerLifeCycleListener(1);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.delete();
            this.tvTabsCommon = null;
        }
        TableStructureEventDispatcher.getInstance(this.tableID).removeListener(this);
        if (!Utils.isDisplayDisposed()) {
            Utils.disposeSWTObjects(this.cTable);
            this.cTable = null;
            if (this.filter != null) {
                this.disableFilterCheck();
            }
            this.removeAllTableRows();
        }
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        configMan.removeParameterListener("Table.extendedErase", this);
        Colors colorInstance = Colors.getInstance();
        if (colorInstance != null) {
            colorInstance.removeColorsChangedListener(this);
        }
        this.header.delete();
        this.header = null;
        super.delete();
        MessageText.removeListener(this);
        this.destroying = false;
    }

    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        if (this.tvTabsCommon != null) {
            this.tvTabsCommon.generate(writer);
        }
    }

    private Menu createMenu() {
        if (!this.isMenuEnabled()) {
            return null;
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        this.cTable.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                Composite cHeaderArea;
                Composite composite = cHeaderArea = TableViewPainted.this.header == null ? null : TableViewPainted.this.header.getHeaderArea();
                if (event2.widget == cHeaderArea) {
                    menu.setData(TableViewPainted.MENUKEY_IN_BLANK_AREA, (Object)false);
                    menu.setData(TableViewPainted.MENUKEY_IS_HEADER, (Object)true);
                } else {
                    boolean noRow;
                    if (event2.detail == 1) {
                        noRow = TableViewPainted.this.getFocusedRow() == null;
                    } else {
                        TableRowCore row = TableViewPainted.this.getTableRowWithCursor();
                        boolean bl = noRow = row == null;
                        if (!TableViewPainted.this.isSelected(row)) {
                            TableViewPainted.this.setSelectedRows(new TableRowCore[]{row});
                        }
                    }
                    menu.setData(TableViewPainted.MENUKEY_IN_BLANK_AREA, (Object)noRow);
                    menu.setData(TableViewPainted.MENUKEY_IS_HEADER, (Object)false);
                }
                Point pt = cHeaderArea.toControl(event2.x, event2.y);
                menu.setData("table-view", (Object)TableViewPainted.this);
                menu.setData(TableViewPainted.MENUKEY_COLUMN, (Object)TableViewPainted.this.getTableColumnByOffset(pt.x));
            }
        });
        if (this.header != null) {
            this.header.createMenu(menu);
        }
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                Object oIsHeader = menu.getData(TableViewPainted.MENUKEY_IS_HEADER);
                boolean isHeader = oIsHeader instanceof Boolean ? (Boolean)oIsHeader : false;
                Object oInBlankArea = menu.getData(TableViewPainted.MENUKEY_IN_BLANK_AREA);
                boolean inBlankArea = oInBlankArea instanceof Boolean ? (Boolean)oInBlankArea : false;
                TableColumnCore column = (TableColumnCore)menu.getData(TableViewPainted.MENUKEY_COLUMN);
                if (isHeader) {
                    TableViewPainted.this.tvSWTCommon.fillColumnMenu(menu, column, false);
                } else if (inBlankArea) {
                    TableViewPainted.this.tvSWTCommon.fillColumnMenu(menu, column, true);
                } else {
                    TableViewPainted.this.tvSWTCommon.fillMenu(menu, column);
                }
            }
        });
        return menu;
    }

    @Override
    public TableRowCore getFocusedRow() {
        return this.focusedRow;
    }

    public void setFocusedRow(TableRowCore row) {
        TableRowPainted oldFocusedRow = this.focusedRow;
        if (!(row instanceof TableRowPainted)) {
            row = null;
        }
        this.focusedRow = (TableRowPainted)row;
        if (this.focusedRow != null) {
            if (this.focusedRow.isVisible() && this.focusedRow.getDrawOffset().y + this.focusedRow.getHeight() <= this.clientArea.y + this.clientArea.height && this.focusedRow.getDrawOffset().y >= this.clientArea.y) {
                this.redrawRow(this.focusedRow, false);
            } else {
                this.showRow(this.focusedRow);
            }
        }
        if (oldFocusedRow != null) {
            this.redrawRow(oldFocusedRow, false);
        }
    }

    @Override
    public void showRow(final TableRowCore rowToShow) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.isDisposed()) {
                    return;
                }
                if (rowToShow.isVisible()) {
                    int y = ((TableRowPainted)rowToShow).getDrawOffset().y;
                    if (y + rowToShow.getHeight() > TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height) {
                        y -= TableViewPainted.this.clientArea.height - rowToShow.getHeight();
                    }
                    TableViewPainted.this.vBar.setSelection(y);
                    TableViewPainted.this.swt_vBarChanged();
                } else {
                    TableRowCore parentFocusedRow = rowToShow;
                    while (parentFocusedRow.getParentRowCore() != null) {
                        parentFocusedRow = parentFocusedRow.getParentRowCore();
                    }
                    TableRowCore[] rows = TableViewPainted.this.getRows();
                    int y = 0;
                    TableRowCore[] tableRowCoreArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    block1: while (n2 < n) {
                        TableRowCore row = tableRowCoreArray[n2];
                        if (row == parentFocusedRow) {
                            TableRowCore[] subRowsWithNull;
                            if (parentFocusedRow == rowToShow) break;
                            y += row.getHeight();
                            TableRowCore[] tableRowCoreArray2 = subRowsWithNull = parentFocusedRow.getSubRowsRecursive(false);
                            int n3 = subRowsWithNull.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TableRowCore subrow = tableRowCoreArray2[n4];
                                if (subrow == rowToShow) break block1;
                                y += ((TableRowPainted)subrow).getHeight();
                                ++n4;
                            }
                            break;
                        }
                        y += ((TableRowPainted)row).getFullHeight();
                        ++n2;
                    }
                    if (y + rowToShow.getHeight() > TableViewPainted.this.clientArea.y + TableViewPainted.this.clientArea.height) {
                        y -= TableViewPainted.this.clientArea.height - rowToShow.getHeight();
                    }
                    TableViewPainted.this.vBar.setSelection(y);
                    TableViewPainted.this.swt_vBarChanged();
                }
            }
        });
    }

    @Override
    public void scrollVertically(final int distance) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TableViewPainted.this.isDisposed()) {
                    return;
                }
                int pos = TableViewPainted.this.vBar.getSelection();
                if (distance > 0) {
                    pos += distance;
                    pos = Math.min(pos, TableViewPainted.this.vBar.getMaximum());
                    TableViewPainted.this.vBar.setSelection(pos);
                } else {
                    pos += distance;
                    pos = Math.max(pos, TableViewPainted.this.vBar.getMinimum());
                    TableViewPainted.this.vBar.setSelection(pos);
                }
                TableViewPainted.this.swt_vBarChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowHeightChanged(TableRowCore row, int oldHeight, int newHeight) {
        Object object = this.heightChangeSync;
        synchronized (object) {
            this.totalHeight += newHeight - oldHeight;
            if (this.totalHeight < 0) {
                Debug.out("eh?");
            }
            if (this.qdRowHeightChanged) {
                return;
            }
            this.qdRowHeightChanged = true;
        }
        Utils.execSWTThreadLater(0, new SWTRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runWithDisplay(Display display) {
                Object object = TableViewPainted.this.heightChangeSync;
                synchronized (object) {
                    TableViewPainted.this.qdRowHeightChanged = false;
                }
                TableViewPainted.this.visibleRowsChanged();
                TableViewPainted.this.swt_fixupSize();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runNoDisplay() {
                Object object = TableViewPainted.this.heightChangeSync;
                synchronized (object) {
                    TableViewPainted.this.qdRowHeightChanged = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRedrawEnabled(boolean enabled) {
        TableViewPainted tableViewPainted = this;
        synchronized (tableViewPainted) {
            this.redrawTableDisabled = enabled ? --this.redrawTableDisabled : ++this.redrawTableDisabled;
        }
        if (enabled) {
            this.redrawTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redrawTable() {
        TableViewPainted tableViewPainted = this;
        synchronized (tableViewPainted) {
            if (this.redrawTableScheduled || this.redrawTableDisabled > 0) {
                return;
            }
            this.redrawTableScheduled = true;
        }
        this.redraw_dispatcher.dispatch();
    }

    private String prettyIndex(TableRowCore row) {
        String s = "" + row.getIndex();
        if (row.getParentRowCore() != null) {
            s = String.valueOf(row.getParentRowCore().getIndex()) + "." + s;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawRow(TableRowPainted row, final boolean immediateRedraw) {
        if (row == null) {
            return;
        }
        if (TableRowPainted.DEBUG_ROW_PAINT) {
            System.out.println(String.valueOf(SystemTime.getCurrentTime()) + "} redraw " + this.prettyIndex(row) + " scheduled via " + Debug.getCompressedStackTrace());
        }
        Object object = this.visibleRows_sync;
        synchronized (object) {
            this.pending_rows.add(row);
        }
        Utils.execSWTThread(new SWTRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runWithDisplay(Display display) {
                Composite composite;
                ArrayList<TableRowPainted> rows;
                Object object = TableViewPainted.this.visibleRows_sync;
                synchronized (object) {
                    if (TableViewPainted.this.pending_rows.size() == 0) {
                        return;
                    }
                    rows = new ArrayList<TableRowPainted>(TableViewPainted.this.pending_rows.size());
                    for (TableRowPainted row : TableViewPainted.this.pending_rows) {
                        if (!row.isVisible()) continue;
                        rows.add(row);
                    }
                    TableViewPainted.this.pending_rows.clear();
                    if (!TableViewPainted.this.isVisible || rows.size() == 0) {
                        return;
                    }
                }
                Rectangle bounds = null;
                boolean has_last = false;
                for (TableRowPainted row : rows) {
                    Rectangle b = row.getDrawBounds();
                    if (b != null) {
                        bounds = bounds == null ? b : bounds.union(b);
                    }
                    if (has_last || !TableViewPainted.this.isLastRow(row)) continue;
                    has_last = true;
                }
                if (bounds != null && (composite = TableViewPainted.this.getComposite()) != null && !composite.isDisposed()) {
                    int h = has_last ? composite.getSize().y - bounds.y : bounds.height;
                    TableViewPainted.this.swt_updateCanvasImage(new Rectangle(bounds.x, bounds.y, bounds.width, h), immediateRedraw);
                }
            }
        });
    }

    public Object getSyncObject() {
        return this.visibleRows_sync;
    }

    @Override
    public boolean isTableSelected() {
        TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
        return tv == this || tv == null && this.isFocused || tv != this && tv != null && tv.getSelectedRowsSize() == 0;
    }

    @Override
    protected boolean isTableFocused() {
        return this.isFocused;
    }

    public boolean isEnabled() {
        return this.cTable.isEnabled();
    }

    @Override
    public void bubbleTextBoxChanged(BubbleTextBox bubbleTextBox) {
        boolean changed;
        if (this.filter != null) {
            changed = bubbleTextBox.isRegexEnabled() ^ this.filter.regex;
            if (changed) {
                this.filter.regex = !this.filter.regex;
            }
        } else {
            changed = false;
        }
        this.setFilterText(bubbleTextBox.getText(), changed);
    }

    private class RedrawTableRunnable
    extends AERunnable {
        private SWTRunnable target = new SWTRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runNoDisplay() {
                TableViewPainted tableViewPainted = TableViewPainted.this;
                synchronized (tableViewPainted) {
                    TableViewPainted.this.redrawTableScheduled = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runWithDisplay(Display display) {
                TableViewPainted tableViewPainted = TableViewPainted.this;
                synchronized (tableViewPainted) {
                    TableViewPainted.this.redrawTableScheduled = false;
                }
                TableViewPainted.this.visibleRowsChanged();
                if (DIRECT_DRAW) {
                    if (TableViewPainted.this.cTable != null && !TableViewPainted.this.cTable.isDisposed()) {
                        TableViewPainted.this.cTable.redraw();
                    }
                } else {
                    if (TableViewPainted.this.canvasImage != null && !TableViewPainted.this.canvasImage.isDisposed()) {
                        TableViewPainted.this.canvasImage.dispose();
                        TableViewPainted.this.canvasImage = null;
                    }
                    TableViewPainted.this.swt_calculateClientArea();
                }
            }
        };

        private RedrawTableRunnable() {
        }

        @Override
        public void runSupport() {
            Utils.execSWTThread(this.target);
        }
    }

    private class RefreshTableRunnable
    extends AERunnable {
        private AtomicBoolean forceSortPending = new AtomicBoolean();

        private RefreshTableRunnable() {
        }

        @Override
        public void runSupport() {
            TableViewPainted.this.__refreshTable(this.forceSortPending.getAndSet(false));
        }

        public void setForceSort(boolean fs) {
            if (fs) {
                this.forceSortPending.set(true);
            }
        }
    }
}

