/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.utils;

import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import java.util.regex.Pattern;

public class TableColumnFilterHelper<T> {
    private static final int MM_EQ = 0;
    private static final int MM_GT = 1;
    private static final int MM_GE = 2;
    private static final int MM_LT = 3;
    private static final int MM_LE = 4;
    private final TableViewSWT<T> table_view;
    private final String regex_key;
    private TimerEventPeriodic filter_refilter;
    private Object refilter_lock = this;
    private volatile boolean filter_active;
    private TableColumn col_cache;
    private String col_cache_name;
    private int match_mode;

    public TableColumnFilterHelper(TableViewSWT<T> _table_view, String _regex_key) {
        this.table_view = _table_view;
        this.regex_key = _regex_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSet(String filter2) {
        Object object = this.refilter_lock;
        synchronized (object) {
            if (filter2.isEmpty()) {
                if (this.filter_refilter != null) {
                    this.filter_refilter.cancel();
                    this.filter_refilter = null;
                }
            } else if (this.filter_refilter == null) {
                this.filter_refilter = SimpleTimer.addPeriodicEvent("tcfh:refilter", 5000L, ev -> {
                    if (this.table_view.isDisposed()) {
                        Object object = this.refilter_lock;
                        synchronized (object) {
                            if (this.filter_refilter != null) {
                                this.filter_refilter.cancel();
                                this.filter_refilter = null;
                            }
                            return;
                        }
                    }
                    if (this.filter_active) {
                        this.table_view.refilter();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterCheck(T data_source, String original_filter, boolean regex, String default_match_text, boolean ignore_column_match) {
        Pattern pattern;
        boolean active;
        if (original_filter.isEmpty()) {
            return true;
        }
        String filter_text = null;
        String match_text = null;
        double match_numeric = Double.NaN;
        int pos = original_filter.indexOf(58);
        if (pos != -1 && !ignore_column_match) {
            TableColumn col;
            String col_name = original_filter.substring(0, pos).trim();
            String col_value = original_filter.substring(pos + 1).trim();
            if (col_value.startsWith(">")) {
                if (col_value.startsWith(">=")) {
                    this.match_mode = 2;
                    col_value = col_value.substring(2);
                } else {
                    this.match_mode = 1;
                    col_value = col_value.substring(1);
                }
            } else if (col_value.startsWith("<")) {
                if (col_value.startsWith("<=")) {
                    this.match_mode = 4;
                    col_value = col_value.substring(2);
                } else {
                    this.match_mode = 3;
                    col_value = col_value.substring(1);
                }
            } else {
                if (col_value.startsWith("=")) {
                    col_value = col_value.substring(1);
                }
                this.match_mode = 0;
            }
            filter_text = col_value;
            Object object = this.refilter_lock;
            synchronized (object) {
                if (this.col_cache_name == null || !this.col_cache_name.equals(col_name)) {
                    this.col_cache = this.table_view.getTableColumn(col_name, true);
                    this.col_cache_name = col_name;
                }
                col = this.col_cache;
            }
            if (col != null) {
                match_text = "";
                TableRowSWT row = this.table_view.getRowSWT(data_source);
                boolean is_fake = false;
                if (row == null) {
                    row = this.table_view.createFakeRow(data_source);
                    is_fake = true;
                }
                try {
                    row.setShown(true, true);
                    TableCellCore cell = (TableCellCore)row.getTableCell(col);
                    if (cell != null) {
                        cell.refresh();
                        match_text = cell.getTextEquivalent();
                        if (match_text == null) {
                            match_text = cell.getText();
                        }
                        match_numeric = cell.getNumeric();
                    }
                }
                finally {
                    if (is_fake) {
                        row.delete();
                    }
                }
            }
        }
        if (match_text == null || filter_text == null) {
            filter_text = original_filter;
            match_text = default_match_text;
            active = false;
        } else {
            active = true;
        }
        if (this.filter_active != active) {
            this.filter_active = active;
        }
        if (active && this.match_mode != 0) {
            double match_num;
            double filter_num = this.getNumber(filter_text);
            double d = match_num = Double.isNaN(match_numeric) ? this.getNumber(match_text) : match_numeric;
            if (filter_num == Double.MIN_VALUE || match_num == Double.MIN_VALUE) {
                return false;
            }
            switch (this.match_mode) {
                case 1: {
                    return match_num > filter_num;
                }
                case 2: {
                    return match_num >= filter_num;
                }
                case 3: {
                    return match_num < filter_num;
                }
                case 4: {
                    return match_num <= filter_num;
                }
            }
            return false;
        }
        String s = regex ? filter_text : RegExUtil.splitAndQuote(filter_text, "\\s*[|;]\\s*");
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        return (pattern = RegExUtil.getCachedPattern(this.regex_key, s, 66)).matcher(match_text).find() == match_result;
    }

    private double getNumber(String str) {
        str = str.trim();
        char[] chars = str.toCharArray();
        try {
            char sep = DisplayFormatters.getDecimalSeparator();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c != sep && !Character.isDigit(c)) {
                    String num = str.substring(0, i);
                    String unit = str.substring(i).trim();
                    long mult = GeneralUtils.getUnitMultiplier(unit, true);
                    if (mult <= 0L) {
                        mult = 1L;
                    }
                    return Double.parseDouble(num) * (double)mult;
                }
                ++i;
            }
            return Double.parseDouble(str);
        }
        catch (Throwable e) {
            return Double.MIN_VALUE;
        }
    }
}

