/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FileExtensionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FileExtensionItem() {
        super("fileext", 1, -1, 50, "Files");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        cell.setText(FileExtensionItem.determineFileExt(fileInfo2));
    }

    private static String determineFileExt(DiskManagerFileInfo fileInfo2) {
        int dot_position;
        String incomp_suffix;
        if (fileInfo2 instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf()) {
            return "";
        }
        String name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        DownloadManager dm = fileInfo2 == null ? null : fileInfo2.getDownloadManager();
        String string = incomp_suffix = dm == null ? null : dm.getDownloadState().getAttribute("incompfilesuffix");
        if (incomp_suffix != null && name.endsWith(incomp_suffix)) {
            name = name.substring(0, name.length() - incomp_suffix.length());
        }
        if ((dot_position = name.lastIndexOf(".")) == -1) {
            return "";
        }
        return name.substring(dot_position + 1);
    }
}

