/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FileReadSpeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public FileReadSpeedItem() {
        super("readrate", 2, -1, 60, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int speed = 0;
        if (fileInfo2 != null) {
            speed = fileInfo2.getReadBytesPerSecond();
        }
        if (!cell.setSortValue(speed) && cell.isValid()) {
            return;
        }
        cell.setText(speed <= 0 ? "" : DisplayFormatters.formatByteCountToKiBEtcPerSec(speed));
    }
}

