/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class LastPieceItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public LastPieceItem() {
        super("lastpiece", 2, -2, 75, "Files");
        this.setDefaultSortAscending(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        long sort_value;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        if (fileInfo2 == null) {
            sort_value = 0L;
        } else {
            sort_value = fileInfo2.getLastPieceNumber();
            if (cell.isSecondarySortEnabled() && sort_value >= 0L) {
                int index = fileInfo2.getIndex();
                if (index < 0) {
                    index = 0;
                }
                sort_value = (sort_value << 32) + (long)index;
            }
        }
        if (!cell.setSortValue(sort_value) && cell.isValid()) {
            return;
        }
        cell.setText(sort_value < 0L || fileInfo2 == null ? "" : "" + fileInfo2.getLastPieceNumber());
    }
}

