/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PercentItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PercentItem() {
        super("%", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        long length;
        long bytesDownloaded;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        boolean internal = fileInfo2 instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf();
        long percent = 0L;
        percent = fileInfo2 != null ? ((bytesDownloaded = fileInfo2.getDownloaded()) < 0L ? -1L : ((length = fileInfo2.getLength()) != 0L ? 1000L * bytesDownloaded / length : 1000L)) : -1L;
        if (!cell.setSortValue(percent) && cell.isValid()) {
            return;
        }
        if (percent < 0L) {
            text = "";
            cell.setNumeric(Double.NaN);
        } else {
            text = DisplayFormatters.formatPercentFromThousands((int)percent);
            cell.setNumeric((double)percent / 10.0);
        }
        cell.setText(text);
    }
}

