/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class RemainingPiecesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public RemainingPiecesItem() {
        super("remaining", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        DiskManager dm = fileInfo2 == null ? null : fileInfo2.getDiskManager();
        int remaining = 0;
        if (fileInfo2 != null && dm != null) {
            if (fileInfo2 instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf()) {
                remaining = -1;
            } else {
                int start = fileInfo2.getFirstPieceNumber();
                int end = start + fileInfo2.getNbPieces();
                DiskManagerPiece[] pieces = dm.getPieces();
                int i = start;
                while (i < end) {
                    if (!pieces[i].isDone()) {
                        ++remaining;
                    }
                    ++i;
                }
            }
        } else {
            remaining = -1;
        }
        if (!cell.setSortValue(remaining) && cell.isValid()) {
            return;
        }
        cell.setText(remaining < 0 ? "" : "" + remaining);
    }
}

