/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerTrackerListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;

abstract class AbstractTrackerCell
implements TableCellRefreshListener,
TableCellToolTipListener,
TableCellDisposeListener,
DownloadManagerTrackerListener {
    TableCell cell;
    private DownloadManager dm;
    private Download download;

    public AbstractTrackerCell(TableCell cell) {
        this.cell = cell;
        cell.addListeners(this);
        this.dm = (DownloadManager)cell.getDataSource();
        if (this.dm == null) {
            return;
        }
        this.dm.addTrackerListener(this);
        this.download = PluginCoreUtils.wrap(this.dm);
    }

    @Override
    public void announceResult(TRTrackerAnnouncerResponse response) {
    }

    @Override
    public void scrapeResult(TRTrackerScraperResponse response) {
        if (this.checkScrapeResult(response)) {
            this.updateSeedsPeers(this.download, false);
        }
    }

    protected abstract void updateSeedsPeers(Download var1, boolean var2);

    protected Download getDownload() {
        return this.download;
    }

    public boolean checkScrapeResult(TRTrackerScraperResponse response) {
        if (response != null) {
            TableCell cell_ref = this.cell;
            if (cell_ref == null) {
                return false;
            }
            DownloadManager dm = (DownloadManager)this.cell.getDataSource();
            if (dm == null || dm != this.dm) {
                return false;
            }
            cell_ref.invalidate();
            return response.isValid();
        }
        return false;
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager oldDM = this.dm;
        this.dm = (DownloadManager)cell.getDataSource();
        if (this.dm != oldDM) {
            if (oldDM != null) {
                oldDM.removeTrackerListener(this);
            }
            if (this.dm != null) {
                this.dm.addTrackerListener(this);
                this.download = PluginCoreUtils.wrap(this.dm);
            }
        }
    }

    @Override
    public void cellHover(TableCell cell) {
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    @Override
    public void dispose(TableCell cell) {
        DownloadManager dm;
        if (this.dm != null) {
            this.dm.removeTrackerListener(this);
        }
        if ((dm = (DownloadManager)cell.getDataSource()) != null && dm != this.dm) {
            dm.removeTrackerListener(this);
        }
        dm = null;
        cell = null;
    }
}

