/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CategoryIconsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "cat_icons";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public CategoryIconsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        List<Tag> tags;
        String sTags = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (tags = tag_manager.getTagsForTaggable(1, (Taggable)dm)).size() > 0) {
            for (Tag t : tags) {
                String file = t.getImageFile();
                if (file == null) continue;
                String str = t.getTagName(true);
                sTags = sTags == null ? str : String.valueOf(sTags) + ", " + str;
            }
        }
        cell.setSortValue((Comparable)((Object)sTags));
        cell.setToolTip(sTags == null ? "" : sTags);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        int num_files;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        ArrayList<String> files = new ArrayList<String>();
        if (dm != null) {
            List<Tag> tags = tag_manager.getTagsForTaggable(1, (Taggable)dm);
            tags = TagUtils.sortTagIcons(tags);
            for (Tag tag : tags) {
                String file = tag.getImageFile();
                if (file == null) continue;
                files.add(file);
            }
        }
        if ((num_files = files.size()) > 0) {
            Rectangle bounds = cell.getBounds();
            ++bounds.x;
            ++bounds.y;
            --bounds.width;
            --bounds.height;
            int w = bounds.width / num_files;
            final ArrayList images = new ArrayList();
            final ArrayList keys = new ArrayList();
            for (String file : files) {
                try {
                    ImageLoader.getInstance().getFileImage(new File(file), new Point(w - 1, bounds.height), new ImageLoader.ImageDownloaderListener(){

                        @Override
                        public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                            if (image != null && returnedImmediately) {
                                images.add(image);
                                keys.add(key);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (images.size() > 0) {
                int width_per_image = bounds.width / images.size();
                int i = 0;
                while (i < images.size()) {
                    Image image = (Image)images.get(i);
                    int iw = image.getBounds().width;
                    gc.drawImage(image, bounds.x + (width_per_image - iw) / 2, bounds.y);
                    bounds.x += width_per_image;
                    ImageLoader.getInstance().releaseImage((String)keys.get(i));
                    ++i;
                }
            }
        }
    }
}

