/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;

public class ColumnSizeWithDND
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "sizewithdnd";

    public ColumnSizeWithDND(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setPosition(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing", "bytes"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        long value = 0L;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)ds;
            value = dm.getSize();
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            value = fileInfo2.getLength();
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(value));
        TableColumnSWTUtils.setSizeAlpha(cell, value);
    }
}

