/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;

public class CommentIconItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
TableCellAddedListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    final UISWTGraphic graphicComment;
    final UISWTGraphic noGraphicComment;
    public static final String COLUMN_ID = "commenticon";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public CommentIconItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, -2, 20, sTableID);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-2, 20);
        this.setMinWidth(20);
        this.setIconReference("comment", true);
        this.graphicComment = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("comment"));
        this.noGraphicComment = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("no_comment"));
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        TorrentUtil.promptUserForComment(new DownloadManager[]{dm});
        this.refresh(event2.cell);
    }

    @Override
    public void refresh(TableCell cell) {
        if (cell.isDisposed()) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String comment = null;
        if (dm != null && (comment = dm.getDownloadState().getUserComment()) != null && comment.length() == 0) {
            comment = null;
        }
        Graphic oldGraphic = cell.getGraphic();
        if (comment == null && oldGraphic != this.noGraphicComment) {
            cell.setGraphic(this.noGraphicComment);
            cell.setSortValue(null);
        } else if (comment != null && oldGraphic != this.graphicComment) {
            cell.setGraphic(this.graphicComment);
            cell.setSortValue((Comparable)((Object)comment));
        }
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String comment = null;
        if (dm != null && (comment = dm.getDownloadState().getUserComment()) != null && comment.length() == 0) {
            comment = null;
        }
        cell.setToolTip(comment);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

