/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DiskLatencyItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "disk.latency";

    public DiskLatencyItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
    }

    @Override
    public void refresh(TableCell cell) {
        String str;
        long sort;
        long[] value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        DiskManager disk_man = dm == null ? null : dm.getDiskManager();
        long[] lArray = value = disk_man == null ? null : disk_man.getLatency();
        if (value == null) {
            sort = -1L;
            str = "";
        } else {
            sort = value[0] << 32 | value[1];
            str = String.valueOf(value[0]) + "/" + value[1];
        }
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

