/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ETAItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class<?> DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "eta";
    private boolean eta_absolute;
    private final MyParameterListener myParameterListener;
    private ViewUtils.CustomDateFormat cdf;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ETAItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setRefreshInterval(-2);
        this.myParameterListener = new MyParameterListener();
        COConfigurationManager.addWeakParameterListener(this.myParameterListener, true, "mtv.eta.show_absolute");
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.myParameterListener, "mtv.eta.show_absolute");
    }

    @Override
    public void refresh(TableCell cell) {
        Long sortVal;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0L : dm.getStats().getETA();
        Long l = sortVal = value < 0L ? null : Long.valueOf(value);
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        cell.setText(this.cdf.formatETA(value, this.eta_absolute));
    }

    @Override
    public void postConfigLoad() {
        super.postConfigLoad();
        this.cdf.update();
    }

    private class MyParameterListener
    implements ParameterListener {
        private MyParameterListener() {
        }

        @Override
        public void parameterChanged(String name) {
            ETAItem.this.eta_absolute = COConfigurationManager.getBooleanParameter("mtv.eta.show_absolute", false);
        }
    }
}

