/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class IPFilterItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static IpFilter ipfilter = null;
    public static final Class DATASOURCE_TYPE = Download.class;
    private static UISWTGraphic tick_icon;
    private static UISWTGraphic cross_icon;
    public static final String COLUMN_ID = "ipfilter";

    public IPFilterItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 100, sTableID);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-1, 100);
        this.setMinWidth(20);
        tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("tick_mark_s"));
        cross_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("cross_mark_s"));
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm;
        UISWTGraphic icon = null;
        int sort = 0;
        if (ipfilter == null) {
            ipfilter = IpFilterManagerFactory.getSingleton().getIPFilter();
        }
        if (ipfilter.isEnabled() && (dm = (DownloadManager)cell.getDataSource()) != null) {
            boolean excluded = dm.getDownloadState().getFlag(256L);
            if (excluded) {
                icon = cross_icon;
                sort = 1;
            } else {
                icon = tick_icon;
                sort = 2;
            }
        }
        cell.setSortValue(sort);
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
    }
}

