/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.io.File;
import java.util.List;

public class MoveOnCompleteItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "moveoncomplete";

    public MoveOnCompleteItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 120, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String tt = null;
        if (dm == null) {
            text = null;
        } else {
            text = dm.getDownloadState().getAttribute("moc.dir");
            if (text == null) {
                List<Tag> moc_tags = TagUtils.getActiveMoveOnCompleteTags(dm, true, str -> {});
                String str_text = "";
                String str_tt = "";
                if (!moc_tags.isEmpty()) {
                    for (Tag tag : moc_tags) {
                        TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag);
                        File file = fl.getTagMoveOnCompleteFolder();
                        if (file == null) continue;
                        str_text = String.valueOf(str_text) + (str_text.isEmpty() ? "" : ", ") + (moc_tags.size() == 1 ? "" : String.valueOf(tag.getTagName(true)) + "->") + file.getAbsolutePath();
                        str_tt = String.valueOf(str_tt) + (str_tt.isEmpty() ? "" : ", ") + tag.getTagName(true) + "->" + file.getAbsolutePath();
                    }
                }
                if (!str_text.isEmpty()) {
                    text = "(" + str_text + ")";
                    tt = str_tt;
                }
            }
        }
        if (text == null) {
            text = "";
        }
        cell.setToolTip(tt);
        if (!cell.setSortValue((Comparable)((Object)text)) && cell.isValid()) {
            return;
        }
        cell.setText(text);
    }
}

