/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Image;

public class NameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfuscateCellText,
TableCellDisposeListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "name";
    private final ParameterListener configShowProgramIconListener;
    private boolean showIcon;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    public NameItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 250, sTableID);
        this.setObfuscation(true);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setMinWidth(100);
        TableContextMenuItem menuItem = this.addContextMenuItem("MyTorrentsView.menu.rename.displayed");
        menuItem.setHeaderCategory("Control");
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Object[] o;
                if (target == null) {
                    return;
                }
                Object[] objectArray = o = (Object[])target;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TableRowCore) {
                        object = ((TableRowCore)object).getDataSource(true);
                    }
                    if (object instanceof DownloadManager) {
                        final DownloadManager dm = (DownloadManager)object;
                        String msg_key_prefix = "MyTorrentsView.menu.rename.displayed.enter.";
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(String.valueOf(msg_key_prefix) + "title", String.valueOf(msg_key_prefix) + "message");
                        entryWindow.setPreenteredText(dm.getDisplayName(), false);
                        entryWindow.maintainWhitespace(true);
                        entryWindow.prompt(new UIInputReceiverListener(){

                            @Override
                            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                                if (!entryWindow.hasSubmittedInput()) {
                                    return;
                                }
                                String value = entryWindow.getSubmittedInput();
                                if (value != null && value.length() > 0) {
                                    dm.getDownloadState().setDisplayName(value);
                                }
                            }
                        });
                    }
                    ++n2;
                }
            }
        });
        this.configShowProgramIconListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                NameItem.this.setShowIcon(COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon"));
            }
        };
        COConfigurationManager.addWeakParameterListener(this.configShowProgramIconListener, true, "NameColumn.showProgramIcon");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.configShowProgramIconListener, "NameColumn.showProgramIcon");
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter("NameColumn.showProgramIcon");
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        DiskManagerFileInfo fileInfo2;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && dm != null && this.isShowIcon() && !sortOnlyRefresh && cell instanceof TableCellSWT && (fileInfo2 = dm.getDownloadState().getPrimaryFile()) != null) {
            TOTorrent torrent = dm.getTorrent();
            Image icon = ImageRepository.getPathIcon(fileInfo2.getFile(false).getName(), false, torrent != null && !torrent.isSimpleTorrent());
            ((TableCellSWT)cell).setIcon(icon);
        }
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        return UIDebugGenerator.obfuscateDownloadName((DownloadManager)cell.getDataSource());
    }

    @Override
    public void dispose(TableCell cell) {
    }

    private void disposeCellIcon(TableCell cell) {
        if (!(cell instanceof TableCellSWT)) {
            return;
        }
        Image img = ((TableCellSWT)cell).getIcon();
        if (img != null) {
            ((TableCellSWT)cell).setIcon(null);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }
}

