/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Image;

public class RankItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "#";
    private final ParameterListener paramShowIconKeyListener;
    private String showIconKey;
    private boolean showIcon;
    private Image imgUp;
    private Image imgDown;
    private GMListener gmListener;
    private boolean bInvalidByTrigger = false;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public RankItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 50, sTableID);
        this.setRefreshInterval(-3);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                RankItem.this.gmListener = new GMListener();
                core.getGlobalManager().addListener(RankItem.this.gmListener);
            }
        });
        this.showIconKey = "RankColumn.showUpDownIcon." + (sTableID.endsWith(".big") ? "big" : "small");
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showRankIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(RankItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(RankItem.this.showIconKey, (Boolean)menu.getData());
            }
        });
        this.paramShowIconKeyListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                RankItem.this.showIcon = COConfigurationManager.getBooleanParameter(RankItem.this.showIconKey);
                RankItem.this.invalidateCells();
            }
        };
        COConfigurationManager.addWeakParameterListener(this.paramShowIconKeyListener, true, this.showIconKey);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgUp = imageLoader.getImage("image.torrentspeed.up");
        this.imgDown = imageLoader.getImage("image.torrentspeed.down");
        final TableContextMenuItem menuSetFromSort = this.addContextMenuItem("menu.set.order.from.sort", 1);
        menuSetFromSort.setStyle(1);
        menuSetFromSort.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                TableRowCore[] selRows;
                TableView<?> tv = menuSetFromSort.getTable();
                if (tv != null && (selRows = tv.getSelectedRows()).length > 1) {
                    menuSetFromSort.setText(MessageText.getString("menu.set.order.for.selection"));
                    return;
                }
                menuSetFromSort.setText(MessageText.getString("menu.set.order.from.sort"));
            }
        });
        menuSetFromSort.addListener((menu, target) -> {
            TableView<?> tv = menuSetFromSort.getTable();
            if (tv != null) {
                TableRowCore[] selRows = tv.getSelectedRows();
                TableRowCore[] rows = selRows.length > 1 ? selRows : tv.getRows();
                int pos = 1;
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                TableRowCore[] tableRowCoreArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    DownloadManager o = (DownloadManager)row.getDataSource(true);
                    gm.moveTo(o, pos++);
                    ++n2;
                }
                this.invalidateCells();
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(this.showIconKey);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.gmListener != null) {
            try {
                CoreFactory.getSingleton().getGlobalManager().removeListener(this.gmListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.gmListener = null;
        }
        COConfigurationManager.removeWeakParameterListener(this.paramShowIconKeyListener, this.showIconKey);
    }

    @Override
    public void refresh(TableCell cell) {
        Class dst;
        boolean complete;
        this.bInvalidByTrigger = false;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0 : dm.getPosition();
        String text = "" + value;
        boolean bl = complete = dm == null ? false : dm.getAssumedComplete();
        if (complete) {
            value += 0x1000000L;
        }
        cell.setSortValue(value);
        cell.setText(text);
        TableView<?> table = cell.getTableRow().getView();
        if (table != null && (dst = table.getDataSourceType()) == Download.class) {
            cell.setToolTip(String.valueOf(text) + ", " + MessageText.getString(complete ? "label.complete" : "label.incomplete"));
        }
        if (cell instanceof TableCellSWT) {
            if (this.showIcon && dm != null) {
                Image img = dm.getAssumedComplete() ? this.imgUp : this.imgDown;
                ((TableCellSWT)cell).setIcon(img);
            } else {
                ((TableCellSWT)cell).setIcon(null);
            }
        }
    }

    private class GMListener
    implements GlobalManagerListener {
        DownloadManagerListener listener = new DownloadManagerListener(){

            @Override
            public void completionChanged(DownloadManager manager, boolean bCompleted) {
            }

            @Override
            public void downloadComplete(DownloadManager manager) {
            }

            @Override
            public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                if (RankItem.this.bInvalidByTrigger) {
                    return;
                }
                RankItem.this.invalidateCells();
                RankItem.this.bInvalidByTrigger = true;
            }

            @Override
            public void stateChanged(DownloadManager manager, int state) {
            }

            @Override
            public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
            }
        };

        @Override
        public void destroyed() {
        }

        @Override
        public void destroyInitiated() {
            try {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                gm.removeListener(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }

        @Override
        public void downloadManagerAdded(DownloadManager dm) {
            dm.addListener(this.listener);
        }

        @Override
        public void downloadManagerRemoved(DownloadManager dm) {
            dm.removeListener(this.listener);
        }

        @Override
        public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
        }
    }
}

