/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class RemainingItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "remaining";

    public RemainingItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress"});
    }

    @Override
    public void refresh(TableCell cell) {
        long lRemaining = this.getRemaining(cell);
        if (!cell.setSortValue(lRemaining) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
    }

    private long getRemaining(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager manager = (DownloadManager)cell.getDataSource();
            if (manager != null) {
                return manager.getStats().getRemainingExcludingDND();
            }
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            return fileInfo2.getLength() - fileInfo2.getDownloaded();
        }
        return 0L;
    }
}

