/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class SeedToPeerRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "seed_to_peer_ratio";

    public SeedToPeerRatioItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        TableRowCore row;
        float ratio = -1.0f;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        Download download = null;
        if (cell instanceof TableCellCore && dm != null && (row = ((TableCellCore)cell).getTableRowCore()) != null) {
            download = (Download)row.getDataSource(false);
        }
        if (dm != null && download != null) {
            int peers;
            int seeds;
            DownloadScrapeResult response = download.getAggregatedScrapeResult();
            if (response.getResponseType() == 1) {
                seeds = Math.max(dm.getNbSeeds(), response.getSeedCount());
                int trackerPeerCount = response.getNonSeedCount();
                peers = dm.getNbPeers();
                if ((peers == 0 || trackerPeerCount > peers) && trackerPeerCount > 0) {
                    peers = trackerPeerCount;
                }
            } else {
                seeds = dm.getNbSeeds();
                peers = dm.getNbPeers();
            }
            ratio = peers < 0 || seeds < 0 ? 0.0f : (peers == 0 ? (seeds == 0 ? 0.0f : Float.POSITIVE_INFINITY) : (float)seeds / (float)peers);
        }
        if (!cell.setSortValue(ratio) && cell.isValid()) {
            return;
        }
        if (ratio == -1.0f) {
            cell.setText("");
        } else if (ratio == 0.0f) {
            cell.setText("??");
        } else {
            cell.setText(DisplayFormatters.formatDecimal(ratio, 3));
        }
    }
}

