/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.text.DecimalFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.MessageBox;

public class ShareRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String CONFIG_ID = "StartStopManager_iFirstPriority_ShareRatio";
    public static final String COLUMN_ID = "shareRatio";
    private int iMinShareRatio;
    private boolean changeFG = true;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing", "swarm"});
    }

    public ShareRatioItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 73, sTableID);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setPosition(-2);
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addWeakParameterListener(this, false, CONFIG_ID);
        TableContextMenuItem menuItem = this.addContextMenuItem("label.set.share.ratio");
        menuItem.setStyle(1);
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                final Object[] dms = (Object[])target;
                int existing = -1;
                Object[] objectArray = dms;
                int n = dms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof TableRowCore) {
                        TableRowCore rowCore = (TableRowCore)object;
                        object = rowCore.getDataSource(true);
                    }
                    if (object instanceof DownloadManager) {
                        int x = ((DownloadManager)object).getStats().getShareRatio();
                        if (existing == -1) {
                            existing = x;
                        } else if (existing != x) {
                            existing = -1;
                            break;
                        }
                    }
                    ++n2;
                }
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("set.share.ratio.win.title", "set.share.ratio.win.msg");
                final DecimalFormat df = new DecimalFormat("0.000");
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(3);
                entryWindow.setPreenteredText(existing == -1 ? df.format(1L) : df.format((float)existing / 1000.0f), false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver receiver) {
                        if (!receiver.hasSubmittedInput()) {
                            return;
                        }
                        try {
                            String str = receiver.getSubmittedInput().trim();
                            int share_ratio = (int)(DisplayFormatters.parseFloat(df, str) * 1000.0f);
                            Object[] objectArray = dms;
                            int n = dms.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object instanceof TableRowCore) {
                                    object = ((TableRowCore)object).getDataSource(true);
                                }
                                DownloadManager dm = (DownloadManager)object;
                                dm.getStats().setShareRatio(share_ratio);
                                ++n2;
                            }
                        }
                        catch (Throwable e) {
                            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                            mb.open();
                            Debug.out(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void refresh(TableCell cell) {
        int sr;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int n = sr = dm == null ? 0 : dm.getStats().getShareRatio();
        if (sr == Integer.MAX_VALUE) {
            sr = 0x7FFFFFFE;
        }
        if (sr == -1) {
            sr = Integer.MAX_VALUE;
        }
        if (!cell.setSortValue(sr) && cell.isValid()) {
            return;
        }
        String shareRatio = "";
        shareRatio = sr == Integer.MAX_VALUE ? "\u221e" : DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
        if (cell.setText(shareRatio) && this.changeFG) {
            Color color = sr < this.iMinShareRatio ? Colors.colorWarning : null;
            cell.setForeground(Utils.colorToIntArray(color));
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        this.invalidateCells();
    }

    public boolean isChangeFG() {
        return this.changeFG;
    }

    public void setChangeFG(boolean changeFG) {
        this.changeFG = changeFG;
    }
}

