/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TagColorsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
ParameterListener {
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tag_colors";
    private static String CFG_SHOW_DEF_COLOURS = "TagColorsItem.showdefcolours";
    private static TableViewSWT.ColorRequester color_requester = () -> 10;
    private static boolean show_default_colours;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public TagColorsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
        show_default_colours = COConfigurationManager.getBooleanParameter(CFG_SHOW_DEF_COLOURS);
        COConfigurationManager.addWeakParameterListener(this, false, CFG_SHOW_DEF_COLOURS);
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("menu.show.default.colors", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(show_default_colours);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(CFG_SHOW_DEF_COLOURS, (Boolean)menu.getData());
            }
        });
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SHOW_DEF_COLOURS);
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.setShowDefaultColours(COConfigurationManager.getBooleanParameter(CFG_SHOW_DEF_COLOURS));
    }

    public void setShowDefaultColours(boolean b) {
        show_default_colours = b;
        this.invalidateCells();
    }

    @Override
    public void refresh(TableCell cell) {
        String sTags = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            List<Tag> tags = tag_manager.getTagsForTaggable(3, (Taggable)dm);
            if (tags.size() > 0) {
                for (Tag tag : tags) {
                    String str = tag.getTagName(true);
                    sTags = sTags == null ? str : String.valueOf(sTags) + ", " + str;
                }
            }
            int[] row_fg_color = null;
            int[] row_bg_color = null;
            long row_fg_color_priority = -1L;
            long row_fg_color_uuid = -1L;
            long row_bg_color_priority = -1L;
            long row_bg_color_uuid = -1L;
            for (Tag tag : tags) {
                long bg;
                long[] colours = tag.getColors();
                if (colours.length <= 0) continue;
                long uuid = tag.getTagUID();
                long priority = colours.length >= 3 ? colours[2] : uuid;
                boolean set_fg = false;
                boolean set_bg = false;
                long fg = colours[0];
                if (fg >= 0L) {
                    if (row_fg_color_priority == -1L || row_fg_color_priority < priority) {
                        set_fg = true;
                    } else if (row_fg_color_priority == priority && row_fg_color_uuid < uuid) {
                        set_fg = true;
                    }
                }
                long l = bg = colours.length > 1 ? colours[1] : -1L;
                if (bg >= 0L) {
                    if (row_bg_color_priority == -1L || row_bg_color_priority < priority) {
                        set_bg = true;
                    } else if (row_bg_color_priority == priority && row_bg_color_uuid < uuid) {
                        set_bg = true;
                    }
                }
                if (set_fg) {
                    row_fg_color = new int[]{(int)(fg >> 16 & 0xFFL), (int)(fg >> 8 & 0xFFL), (int)fg & 0xFF};
                    row_fg_color_priority = priority;
                    row_fg_color_uuid = uuid;
                }
                if (!set_bg) continue;
                row_bg_color = new int[]{(int)(bg >> 16 & 0xFFL), (int)(bg >> 8 & 0xFFL), (int)bg & 0xFF};
                row_bg_color_priority = priority;
                row_bg_color_uuid = uuid;
            }
            TableRow row = cell.getTableRow();
            if (row instanceof TableRowSWT) {
                boolean missing_fg = false;
                boolean missing_bg = false;
                Color fg = null;
                Color bg = null;
                if (row_fg_color != null && (fg = ColorCache.getColor(null, row_fg_color)) == null) {
                    missing_fg = true;
                }
                if (row_bg_color != null && (bg = ColorCache.getColor(null, row_bg_color)) == null) {
                    missing_bg = true;
                }
                if (missing_fg) {
                    int[] f_row_color = row_fg_color;
                    Utils.execSWTThread(() -> ((TableRowSWT)row).requestForegroundColor(color_requester, ColorCache.getColor((Device)Display.getCurrent(), f_row_color)));
                } else {
                    ((TableRowSWT)row).requestForegroundColor(color_requester, fg);
                }
                if (missing_bg) {
                    int[] f_row_color = row_bg_color;
                    Utils.execSWTThread(() -> ((TableRowSWT)row).requestBackgroundColor(color_requester, ColorCache.getColor((Device)Display.getCurrent(), f_row_color)));
                } else {
                    ((TableRowSWT)row).requestBackgroundColor(color_requester, bg);
                }
            }
        }
        cell.setSortValue((Comparable)((Object)sTags));
        cell.setToolTip(sTags == null ? "" : sTags);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        int num_colors;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        ArrayList<Color> colors = new ArrayList<Color>();
        if (dm != null) {
            List<Tag> tags = tag_manager.getTagsForTaggable(3, (Taggable)dm);
            for (Tag tag : tags) {
                Color color;
                int[] rgb = tag.getColor();
                if (rgb == null || rgb.length != 3 || !show_default_colours && tag.isColorDefault() || (color = ColorCache.getColor(gc.getDevice(), rgb)) == null) continue;
                colors.add(color);
            }
        }
        if ((num_colors = colors.size()) > 0) {
            Rectangle bounds = cell.getBounds();
            Utils.setClipping(gc, new Rectangle(bounds.x, bounds.y + 1, bounds.width - 1, bounds.height - 2));
            if (num_colors == 1) {
                gc.setBackground((Color)colors.get(0));
                gc.fillRectangle(bounds);
            } else {
                int width = bounds.width;
                int chunk = width / num_colors;
                if (chunk == 0) {
                    chunk = 1;
                }
                bounds.width = chunk;
                int i = 0;
                while (i < num_colors) {
                    int rem;
                    if (i == num_colors - 1 && (rem = width - chunk * (num_colors - 1)) > 0) {
                        bounds.width = rem;
                    }
                    gc.setBackground((Color)colors.get(i));
                    gc.fillRectangle(bounds);
                    bounds.x += chunk;
                    ++i;
                }
            }
        }
    }
}

