/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.graphics.Color;

public class TrackerCellUtils {
    public static final Class DATASOURCE_TYPE = Download.class;

    public static void updateColor(TableCell cell, DownloadManager dm, boolean show_errors) {
        if (dm == null || cell == null) {
            return;
        }
        if (show_errors && dm.isTrackerError()) {
            cell.setForegroundToErrorColor();
            return;
        }
        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
        if (response instanceof TRTrackerBTScraperResponseImpl && response.getStatus() == 2) {
            boolean bMultiHashScrapes = ((TRTrackerBTScraperResponseImpl)response).getTrackerStatus().getSupportsMultipeHashScrapes();
            Color color = bMultiHashScrapes ? null : Colors.grey;
            cell.setForeground(Utils.colorToIntArray(color));
        } else {
            cell.setForeground(Utils.colorToIntArray(null));
        }
    }

    public static String getTooltipText(TableCell cell, DownloadManager dm, boolean show_errors) {
        if (dm == null || cell == null) {
            return null;
        }
        if (show_errors && dm.isTrackerError()) {
            return null;
        }
        String sToolTip = null;
        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
        if (response instanceof TRTrackerBTScraperResponseImpl && response.getStatus() == 2) {
            String sPrefix = ((TRTrackerBTScraperResponseImpl)response).getTrackerStatus().getSupportsMultipeHashScrapes() ? "" : "No";
            sToolTip = MessageText.getString("Tracker.tooltip." + sPrefix + "MultiSupport");
        }
        return sToolTip;
    }
}

