/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.StringInterner;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class TrackerNameItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "trackername";
    private static Set<String> preferred_tracker_names;
    private MyParameterListener myParameterListener;

    public TrackerNameItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 120, sTableID);
        this.setRefreshInterval(5);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"tracker"});
        info.setProficiency((byte)1);
        this.myParameterListener = new MyParameterListener();
        COConfigurationManager.addWeakParameterListener(this.myParameterListener, true, "mtv.trackername.pref.hosts");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.myParameterListener, "mtv.trackername.pref.hosts");
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String name = "";
        if (dm != null && dm.getTorrent() != null) {
            TOTorrent torrent = dm.getTorrent();
            name = TrackerNameItem.getTrackerName(torrent);
        }
        if (cell.setText(name) || !cell.isValid()) {
            TrackerCellUtils.updateColor(cell, dm, false);
        }
    }

    public static String getTrackerName(TOTorrent torrent) {
        String host;
        TOTorrentAnnounceURLSet[] sets;
        String name = "";
        Set<String> pref_names = preferred_tracker_names;
        URL url = null;
        if (pref_names != null && (sets = torrent.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
            String host2 = torrent.getAnnounceURL().getHost();
            if (pref_names.contains(host2)) {
                url = torrent.getAnnounceURL();
            } else {
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    URL[] urls;
                    TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n2];
                    URL[] uRLArray = urls = set.getAnnounceURLs();
                    int n3 = urls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        URL u = uRLArray[n4];
                        if (pref_names.contains(u.getHost())) {
                            url = u;
                            break;
                        }
                        ++n4;
                    }
                    if (url != null) break;
                    ++n2;
                }
            }
        }
        if (url == null) {
            url = torrent.getAnnounceURL();
        }
        if ((host = url.getHost()).endsWith(".dht")) {
            name = "dht";
        } else if (AENetworkClassifier.categoriseAddress(host) == "Public") {
            String[] parts = host.split("\\.");
            int used = 0;
            int i = parts.length - 1;
            while (i >= 0) {
                if (used > 4) break;
                String chunk = parts[i];
                if (used < 2 || chunk.length() < 11) {
                    name = used == 0 ? chunk : String.valueOf(chunk) + "." + name;
                    ++used;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            name = host;
        }
        name = name.equals(host) ? host : StringInterner.intern(name);
        return name;
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, false));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    private class MyParameterListener
    implements ParameterListener {
        private MyParameterListener() {
        }

        @Override
        public void parameterChanged(String name) {
            String prefs = COConfigurationManager.getStringParameter("mtv.trackername.pref.hosts", null);
            HashSet<String> new_vals = new HashSet<String>();
            if (prefs != null) {
                String[] bits;
                String[] stringArray = bits = prefs.split(";");
                int n = bits.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if ((s = s.trim()).length() > 0) {
                        new_vals.add(s);
                    }
                    ++n2;
                }
            }
            preferred_tracker_names = new_vals;
        }
    }
}

