/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;
import com.biglybt.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerStatusItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tracker";

    public TrackerStatusItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 90, sTableID);
        this.setRefreshInterval(15);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{COLUMN_ID});
        info.setProficiency((byte)1);
    }

    @Override
    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, true));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    private static class Cell
    extends AbstractTrackerCell {
        public Cell(TableCell cell) {
            super(cell);
        }

        @Override
        public void refresh(TableCell cell) {
            super.refresh(cell);
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            String status = dm == null ? "" : dm.getTrackerStatus();
            int nl_pos = status.indexOf(10);
            if (nl_pos >= 0) {
                status = status.substring(0, nl_pos);
            }
            if (cell.setText(status) || !cell.isValid()) {
                TrackerCellUtils.updateColor(cell, dm, true);
            }
        }

        @Override
        protected void updateSeedsPeers(Download d, boolean cache) {
        }

        @Override
        public void announceResult(TRTrackerAnnouncerResponse response) {
            this.cell.invalidate();
        }
    }
}

