/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class UploadHealthItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "upload.health";

    public UploadHealthItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    @Override
    public void refresh(TableCell cell) {
        String str;
        long sort_val;
        PEPeerManager pm;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        PEPeerManager pEPeerManager = pm = dm == null ? null : dm.getPeerManager();
        if (pm == null) {
            sort_val = -1L;
            str = "";
        } else {
            int queued_bytes = pm.getBytesQueuedForUpload();
            int peers_with_upq = pm.getNbPeersWithUploadQueued();
            int peers_with_block = pm.getNbPeersWithUploadBlocked();
            sort_val = queued_bytes << 32 | peers_with_upq << 16 | peers_with_block;
            str = String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(queued_bytes)) + "/" + peers_with_upq + "/" + peers_with_block;
        }
        if (!cell.setSortValue(sort_val) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

