/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ASItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "as";

    public ASItem(String table_id) {
        super(COLUMN_ID, 1, -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    @Override
    public void refresh(TableCell cell) {
        String[] details;
        PEPeer peer = (PEPeer)cell.getDataSource();
        String text = "";
        if (peer != null && (details = PeerUtils.getASandASN(peer)) != null) {
            String as = details[0];
            String asn = details[1];
            if (!as.isEmpty() || !asn.isEmpty()) {
                text = String.valueOf(details[1]) + " (" + details[0] + ")";
            }
        }
        if (!cell.setSortValue((Comparable)((Object)text)) && cell.isValid()) {
            return;
        }
        cell.setText(text);
    }
}

