/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.OutgoingMessageQueue;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class BytesQueuedForUpload
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "bytes-queued";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    public BytesQueuedForUpload(String table_id) {
        super(COLUMN_ID, 3, -1, 120, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        OutgoingMessageQueue mq;
        Connection con;
        PEPeer peer = (PEPeer)cell.getDataSource();
        String value = "";
        if (peer != null && (con = peer.getPluginConnection()) != null && (mq = con.getOutgoingMessageQueue()) != null) {
            value = String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(mq.getDataQueuedBytes())) + "/" + DisplayFormatters.formatByteCountToKiBEtc(mq.getProtocolQueuedBytes());
        }
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

