/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ClientIdentificationItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "client_identification";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    public ClientIdentificationItem(String table_id) {
        super(COLUMN_ID, -1, 200, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            cell.setText("");
            return;
        }
        String peer_id_name = peer.getClientNameFromPeerID();
        String peer_handshake_name = peer.getClientNameFromExtensionHandshake();
        if (peer_id_name == null) {
            peer_id_name = "";
        }
        if (peer_handshake_name == null) {
            peer_handshake_name = "";
        }
        if (peer_id_name.equals("") && peer_handshake_name.equals("")) {
            cell.setText("");
            return;
        }
        String result = peer_id_name;
        if (!peer_handshake_name.equals("")) {
            result = String.valueOf(result) + " / " + peer_handshake_name;
        }
        cell.setText(result);
    }
}

