/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ConnectedTimeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "connected_time";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
    }

    public ConnectedTimeItem(String table_id) {
        super(COLUMN_ID, 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        long connected_for;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long connected_at = peer == null ? -1L : peer.getConnectionEstablishedMonoTime();
        long l = connected_for = connected_at < 0L ? 0L : SystemTime.getMonotonousTime() / 1000L - connected_at / 1000L;
        if (!cell.setSortValue(connected_for) && cell.isValid()) {
            return;
        }
        cell.setText(connected_for == 0L ? "" : TimeFormatter.format(connected_for));
    }
}

