/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class HandshakeReservedBytesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "handshake_reserved";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    public HandshakeReservedBytesItem(String table_id) {
        super(COLUMN_ID, -1, 80, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        byte[] handshake_reserved = null;
        if (peer != null) {
            handshake_reserved = peer.getHandshakeReservedBytes();
        }
        if (handshake_reserved == null) {
            cell.setText("");
            return;
        }
        cell.setText(ByteFormatter.nicePrint(handshake_reserved, false));
    }
}

