/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class LocalInterfaceItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "localintf";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    public LocalInterfaceItem(String table_id) {
        super(COLUMN_ID, 2, -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null || AENetworkClassifier.categoriseAddress(peer.getIp()) != "Public") {
            text = "";
        } else {
            NetworkInterface ni = PeerUtils.getLocalNetworkInterface(peer);
            if (ni == null) {
                text = "";
            } else {
                text = ni.getName();
                InetAddress ia = PeerUtils.getLocalAddress(peer);
                if (ia != null) {
                    text = String.valueOf(ia.getHostAddress()) + " (" + text + ")";
                }
            }
        }
        cell.setText(text);
    }
}

